/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.database;

import com.cognos.mobile.common.CMIDs;
import com.cognos.mobile.standardedition.SERes;
import java.util.Date;
import java.util.Locale;

public class HistoryObject {
    private int historyID;
    private int eventID;
    private Date timeStamp;
    private String arguments;
    private String renderLabel;
    private String storeID;
    private int[] userIDs;
    private int[] renderIDs;

    public int[] getUserIDs() {
        return this.userIDs;
    }

    public String getStoreID() {
        return this.storeID;
    }

    public void setStoreID(String storeID) {
        this.storeID = storeID;
    }

    public void setUserIDs(int[] userIDs) {
        this.userIDs = userIDs;
    }

    public int[] getRenderIDs() {
        return this.renderIDs;
    }

    public int getRenderID() {
        if (this.renderIDs == null) {
            return -1;
        }
        return this.renderIDs[0];
    }

    public void setRenderIDs(int[] renderIDs) {
        this.renderIDs = renderIDs;
    }

    public HistoryObject(int historyID, int eventID, Date timeStamp, String arguments) {
        this.historyID = historyID;
        this.eventID = eventID;
        this.timeStamp = timeStamp;
        this.arguments = arguments;
    }

    public HistoryObject(String renderLabel, int userID, int historyID, int eventID, Date timeStamp, String arguments, int renderID, String storeID) {
        this.renderLabel = renderLabel;
        this.historyID = historyID;
        this.eventID = eventID;
        this.timeStamp = timeStamp;
        this.arguments = arguments;
        this.userIDs = new int[]{userID};
        this.renderIDs = new int[]{renderID};
        this.storeID = storeID;
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public String getRenderLabel() {
        return this.renderLabel;
    }

    public void setRenderLabel(String renderLabel) {
        this.renderLabel = renderLabel;
    }

    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    public int getHistoryID() {
        return this.historyID;
    }

    public void setHistoryID(int historyID) {
        this.historyID = historyID;
    }

    public int getEventID() {
        return this.eventID;
    }

    public void setEventID(int eventID) {
        this.eventID = eventID;
    }

    public String getArguments() {
        return this.arguments;
    }

    public void setArguments(String arguments) {
        this.arguments = arguments;
    }

    public String toXML(Locale lang) {
        StringBuffer sb = new StringBuffer();
        String label = "";
        if (this.renderLabel != null) {
            label = this.renderLabel;
        }
        switch (this.eventID) {
            case 1: {
                sb.append(SERes.singleton.getString(CMIDs.HISTORY_LOG_IN, lang));
                break;
            }
            case 4: 
            case 7: {
                if (this.eventID == 4) {
                    sb.append(SERes.singleton.formatString(CMIDs.HISTORY_DOWNLOAD_REPORT, label, lang));
                    break;
                }
                sb.append(SERes.singleton.formatString(CMIDs.HISTORY_VIEW_REPORT, label, lang));
                break;
            }
            case 2: {
                sb.append(SERes.singleton.formatString(CMIDs.HISTORY_REPORT_START, label, lang));
                break;
            }
            case 3: {
                sb.append(SERes.singleton.formatString(CMIDs.HISTORY_REPORT_FINISH, label, lang));
                break;
            }
            case 5: {
                sb.append(SERes.singleton.formatString(CMIDs.HISTORY_SCHEDULED_REPORT_START, label, lang));
                break;
            }
            case 6: {
                sb.append(SERes.singleton.formatString(CMIDs.HISTORY_SCHEDULED_REPORT_FINISH, label, lang));
            }
        }
        return sb.toString();
    }
}

