/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.database;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.database.IConnectionPool;
import com.cognos.mobile.database.IPreparedStatementParameterizer;
import com.cognos.mobile.database.IResultSetAccumulator;
import com.cognos.mobile.database.ISyncDatabase;
import com.cognos.mobile.database.SchemaVersion;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public interface ISQLDatabase {
    public String getDriverClass() throws CMException;

    public String getDatabaseProductName() throws CMException;

    public String getConnectionUrl() throws CMException;

    public IConnectionPool getConnectionPool();

    public String getHostPort() throws CMException;

    public String getDatabaseName() throws CMException;

    public String getUsername() throws CMException;

    public String getPassword() throws CMException;

    public String getSchemaDirectory();

    public void executeQuery(String var1, IResultSetAccumulator var2) throws CMException;

    public void executeQuery(Connection var1, String var2, IResultSetAccumulator var3) throws CMException;

    public void executeQuery(String var1, IPreparedStatementParameterizer var2, IResultSetAccumulator var3) throws CMException;

    public void executeQuery(Connection var1, String var2, IPreparedStatementParameterizer var3, IResultSetAccumulator var4) throws CMException;

    public void executePreparedStatement(String var1, IPreparedStatementParameterizer var2, StringBuilder var3) throws CMException;

    public void executePreparedStatement(Connection var1, String var2, IPreparedStatementParameterizer var3, StringBuilder var4) throws CMException;

    public void executeBatchedPreparedStatement(String var1, IPreparedStatementParameterizer var2, int var3, StringBuilder var4) throws CMException;

    public void executeBatchedPreparedStatement(Connection var1, String var2, IPreparedStatementParameterizer var3, int var4, StringBuilder var5) throws CMException;

    public int executeUpdate(String var1, IPreparedStatementParameterizer var2, String var3, String var4) throws CMException;

    public int executeCommittedUpdate(String var1, IPreparedStatementParameterizer var2, String var3, String var4) throws CMException;

    public int executeUpdate(Connection var1, String var2, IPreparedStatementParameterizer var3, String var4, String var5) throws CMException;

    public void executeInsert(String var1, IPreparedStatementParameterizer var2) throws CMException;

    public void executeCommittedInsert(String var1, IPreparedStatementParameterizer var2) throws CMException;

    public void execute(String var1) throws CMException;

    public void execute(Connection var1, String var2) throws CMException;

    public void executeScript(File var1) throws CMException;

    public void executeScript(File var1, Connection var2) throws CMException;

    public byte[] getBlobBytes(ResultSet var1, int var2) throws SQLException;

    public ISyncDatabase.SyncResultSet createScrollableResultSet(Connection var1, String var2) throws CMException;

    public SchemaVersion getSchemaVersion(String var1) throws CMException;

    public SchemaVersion getSchemaVersion(Connection var1, String var2) throws CMException;

    public void updateSchemaVersion(int var1, int var2) throws CMException;

    public void updateSchemaVersion(int var1, int var2, String var3) throws CMException;

    public void updateSchemaVersion(Connection var1, int var2, int var3) throws CMException;

    public void updateSchemaVersion(Connection var1, int var2, int var3, String var4) throws CMException;

    public void updateSchemaVersion(Connection var1, SchemaVersion var2) throws CMException;

    public Connection getConnection() throws CMException;

    public void quietlyReleaseConnection(Connection var1);

    public int getDatabaseType();

    public boolean supportsVaultus();

    public int getMaxBlobChunkSize();

    public void setBlobSpecial(PreparedStatement var1, int var2, byte[] var3, int var4, int var5, StringBuilder var6) throws SQLException;

    public String[] getUserTableNames(Connection var1) throws SQLException;

    public Connection getTransactionConnection() throws Exception;

    public void releaseTransactionConnection(Connection var1);

    public void clean(Connection var1) throws SQLException;

    public void dispose();
}

