/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.database;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.database.DefaultPreparedStatementParameterizer;
import com.cognos.mobile.database.ISQLDatabase;
import com.cognos.mobile.vm.VM;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.PreparedStatement;

class InsertBlobStatementParameterizer
extends DefaultPreparedStatementParameterizer {
    private static final Class CLASS = InsertBlobStatementParameterizer.class;
    private int currentRecord = 0;
    private int recordCount;
    private byte[] blob;
    private int tsId;
    private final ISQLDatabase database;

    public InsertBlobStatementParameterizer(int tsId, byte[] blob, ISQLDatabase database) {
        if (blob == null) {
            blob = new byte[]{};
        }
        this.recordCount = (blob.length + database.getMaxBlobChunkSize() - 1) / database.getMaxBlobChunkSize();
        this.blob = blob;
        this.tsId = tsId;
        this.database = database;
    }

    @Override
    public boolean parameterize(PreparedStatement statement) throws CMException {
        if (this.currentRecord >= this.recordCount) {
            return false;
        }
        int startByte = this.currentRecord * this.database.getMaxBlobChunkSize();
        int stopByte = Math.min(this.blob.length, (this.currentRecord + 1) * this.database.getMaxBlobChunkSize());
        int length = stopByte - startByte;
        ByteArrayInputStream in = new ByteArrayInputStream(this.blob, startByte, length);
        try {
            int i = 1;
            statement.setInt(i++, this.tsId);
            statement.setInt(i++, this.currentRecord);
            statement.setBinaryStream(i++, (InputStream)in, length);
            ++this.currentRecord;
            return true;
        }
        catch (Exception ex) {
            String details = "failed to insert blob! max blob chunk size used: " + this.database.getMaxBlobChunkSize();
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1126, details, (Throwable)ex);
        }
    }
}

