/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.database;

import com.cognos.mobile.common.C8;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.database.IPortalItemDAO;
import com.cognos.mobile.database.ISQLDatabase;
import com.cognos.mobile.database.IUserPortalItemDAO;
import com.cognos.mobile.database.PortalItemRow;
import com.cognos.mobile.database.SQLPortalItemDAO;
import com.cognos.mobile.database.SQLUserPortalItemDAO;

public class PortalItemManager {
    private final IPortalItemDAO portalItemDAO;
    private final IUserPortalItemDAO userPortalItemDAO;

    public PortalItemManager(ISQLDatabase database) {
        this.portalItemDAO = new SQLPortalItemDAO(database);
        this.userPortalItemDAO = new SQLUserPortalItemDAO(database);
    }

    public PortalItemRow addFavourite(int userId, C8.PortalItem item) throws CMException {
        PortalItemRow portalItem = this.portalItemDAO.addFavourite(userId, item);
        this.userPortalItemDAO.insert(userId, portalItem.getPortalItemID(), 1);
        return portalItem;
    }

    public void deleteFavourite(int userId, PortalItemRow pi) throws CMException {
        this.portalItemDAO.deleteFavourite(userId, pi);
        this.userPortalItemDAO.delete(userId, pi.getPortalItemID(), 1);
    }

    public void deleteFavourites(int userId) throws CMException {
        this.portalItemDAO.deleteFavourites(userId);
    }

    public void deletePortalItem(int id) throws CMException {
        this.portalItemDAO.deletePortalItem(id);
    }

    public PortalItemRow getPortalItem(int portalItemID) throws CMException {
        return this.portalItemDAO.getPortalItem(portalItemID);
    }

    public PortalItemRow getPortalItem(String storeID, String cmPath, String sourcePath) throws CMException {
        return this.portalItemDAO.getPortalItem(storeID, cmPath, sourcePath);
    }

    public int getPortalItemID(int userID, int portalItemType) throws CMException {
        return this.userPortalItemDAO.getPortalItemID(userID, portalItemType);
    }

    public String getPortalItemLabel(String storeID) throws CMException {
        return this.portalItemDAO.getPortalItemLabel(storeID);
    }

    public int insertPortalItem(String label, String storeID, String cmPath, String sourcePath, String description, int portalItemType) throws CMException {
        return this.portalItemDAO.insertPortalItem(label, storeID, cmPath, sourcePath, description, portalItemType);
    }

    public void insertUserPortalItem(int userID, int portalItemID, int portalItemType) throws CMException {
        this.userPortalItemDAO.insert(userID, portalItemID, portalItemType);
    }

    public PortalItemRow[] listFavourites(int userId) throws CMException {
        return this.portalItemDAO.listFavourites(userId);
    }

    public void removeUserPortalItem(int userID, int portalItemID, int portalItemType) throws CMException {
        this.userPortalItemDAO.delete(userID, portalItemID, portalItemType);
    }

    public void updateUserPortalItem(int userID, int portalItemID, int portalItemType) throws CMException {
        this.userPortalItemDAO.update(userID, portalItemID, portalItemType);
    }
}

