/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.database;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.database.IRenderGroupDAO;
import com.cognos.mobile.database.IRenderRow;
import com.cognos.mobile.database.ISQLDatabase;
import com.cognos.mobile.database.SQLRenderGroupDAO;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class RenderGroupManager {
    public static final int MAX_EXPRESSIONS = 500;
    private final IRenderGroupDAO renderGroupDAO;

    public RenderGroupManager(ISQLDatabase database) {
        this.renderGroupDAO = new SQLRenderGroupDAO(database);
    }

    public List<IRenderRow> getRendersForGroup(List<String> groups) throws CMException {
        ArrayList<IRenderRow> renderList = new ArrayList<IRenderRow>();
        List<List<String>> chunkedGroups = this.breakdownGroupsIntoChunks(groups);
        for (int i = 0; i < chunkedGroups.size(); ++i) {
            List<IRenderRow> renderList1 = this.renderGroupDAO.getRendersForGroup(chunkedGroups.get(i));
            renderList.addAll(renderList1);
        }
        return renderList;
    }

    public void deleteRenderGrouping(int[] renderID) throws CMException {
        this.renderGroupDAO.deleteRenderGrouping(renderID);
    }

    public void deleteRendersForGroups(List<String> groups) throws CMException {
        List<List<String>> chunkedGroups = this.breakdownGroupsIntoChunks(groups);
        for (int i = 0; i < chunkedGroups.size(); ++i) {
            this.renderGroupDAO.deleteRendersForGroups(chunkedGroups.get(i));
        }
    }

    public void insertRenderToGroupMapping(int renderID, List<String> groups) throws CMException {
        List<List<String>> chunkedGroups = this.breakdownGroupsIntoChunks(groups);
        for (int i = 0; i < chunkedGroups.size(); ++i) {
            this.renderGroupDAO.insertRenderToGroupMapping(renderID, chunkedGroups.get(i));
        }
    }

    public LinkedHashMap<String, IRenderRow> getGroupToRenders() throws CMException {
        return this.renderGroupDAO.getGroupToRenders();
    }

    public List<List<String>> breakdownGroupsIntoChunks(List<String> groups) {
        if (groups == null || groups.size() == 0) {
            return new ArrayList<List<String>>(0);
        }
        ArrayList<List<String>> chunkedGroups = new ArrayList<List<String>>(1);
        for (int i = 0; i < groups.size(); i += 500) {
            List<String> groupChunk = groups.subList(i, Math.min(groups.size(), i + 500));
            chunkedGroups.add(groupChunk);
        }
        return chunkedGroups;
    }
}

