/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.database;

import com.cognos.mobile.c8.OutputTypeManager;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.database.IRenderDAO;
import com.cognos.mobile.database.IRenderRow;
import com.cognos.mobile.database.ISQLDatabase;
import com.cognos.mobile.database.IUserRenderDAO;
import com.cognos.mobile.database.PortalItemManager;
import com.cognos.mobile.database.PortalItemRow;
import com.cognos.mobile.database.RenderRow;
import com.cognos.mobile.database.RenderState;
import com.cognos.mobile.database.RenderStatus;
import com.cognos.mobile.database.SQLRenderDAO;
import com.cognos.mobile.database.SQLUserRenderDAO;
import com.cognos.mobile.model.data.SavedOutputType;
import com.cognos.mobile.server.core.RenderWatcher;
import com.cognos.mobile.server.monitoring.InteractiveReportMonitoringController;
import com.cognos.mobile.vm.VM;
import java.util.Date;
import java.util.List;

public class RenderManager {
    private static final Class CLASS = RenderManager.class;
    private final IRenderDAO renderDAO;
    private final IUserRenderDAO userRenderDAO;
    private final PortalItemManager portalItemManager;
    private final InteractiveReportMonitoringController monitoringController;

    public RenderManager(ISQLDatabase database, PortalItemManager portalItemManager, InteractiveReportMonitoringController aMonitoringController) {
        this.renderDAO = new SQLRenderDAO(database);
        this.userRenderDAO = new SQLUserRenderDAO(database);
        this.portalItemManager = portalItemManager;
        this.monitoringController = aMonitoringController;
    }

    public RenderManager(ISQLDatabase database, PortalItemManager portalItemManager) {
        this(database, portalItemManager, null);
    }

    public IRenderRow[] browseRenders(int userID, List<Integer> supportedOutputFormats) throws CMException {
        return this.renderDAO.browseRenders(userID, false, supportedOutputFormats);
    }

    private void cancelAndWaitUntilRenderIsNoLongerInProgress(int aRenderID) {
        if (null != this.monitoringController && !RenderWatcher.isRenderComplete(aRenderID, 0)) {
            this.monitoringController.promoteToCanceledRequestByUser(aRenderID);
            do {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (!RenderWatcher.isRenderComplete(aRenderID, 0));
        }
    }

    private void updateRenderMask(IRenderRow previousRender, int userID, int newOutputTypeMask) throws CMException {
        int prevRenderId = previousRender.getIntField(RenderRow.RenderField.RENDERID);
        int userCount = this.userRenderDAO.getUserCount(prevRenderId);
        if (userCount > 1 && userID != -1) {
            this.userRenderDAO.delete(userID, prevRenderId);
        } else {
            this.renderDAO.updateRenderRow(new RenderRow().setField(RenderRow.RenderField.OUTPUT_TYPE_MASK, newOutputTypeMask).setField(RenderRow.RenderField.RENDERID, prevRenderId));
        }
    }

    public void deleteRender(int renderID, int userID) throws CMException {
        VM.log(CLASS, 0, "deleting render " + renderID + " for user " + userID);
        IRenderRow render = this.renderDAO.loadRender(renderID);
        if (render != null) {
            int userCount = this.userRenderDAO.getUserCount(renderID);
            if (userCount > 1 && userID != -1) {
                this.userRenderDAO.delete(userID, renderID);
            } else {
                this.cancelAndWaitUntilRenderIsNoLongerInProgress(renderID);
                this.renderDAO.deleteRender(renderID, userID);
                this.portalItemManager.deletePortalItem(render.getIntField(RenderRow.RenderField.PORTALITEM_ID));
            }
        }
    }

    public void softDeleteRender(int renderID, int userID) throws CMException {
        VM.log(CLASS, 0, "soft-deleting render " + renderID + " for user " + userID);
        IRenderRow render = this.renderDAO.loadRender(renderID);
        if (render != null) {
            int userCount = this.userRenderDAO.getUserCount(renderID);
            if (userCount > 1 && userID != -1) {
                this.userRenderDAO.delete(userID, renderID);
            } else {
                this.cancelAndWaitUntilRenderIsNoLongerInProgress(renderID);
                try {
                    IRenderRow row = new RenderRow().setField(RenderRow.RenderField.RENDERID, renderID).setField(RenderRow.RenderField.STATUS, RenderState.DELETED.getCode());
                    this.renderDAO.updateRenderRow(row);
                }
                catch (CMException ex) {
                    VM.log(CLASS, 2, "Problem soft-deleting render with: " + ex.getErrorCode() + " render: " + renderID, ex);
                }
            }
        }
    }

    public void deletePreviousRenders(int ownerID, int[] targetUserIDs, String cmPath, int outputTypeMask, int sourceCode, String drillParams, String burstValue, SavedOutputType savedOutputType) throws CMException {
        if (targetUserIDs != null && targetUserIDs.length > 0) {
            for (int i = 0; i < targetUserIDs.length; ++i) {
                this.deletePreviousRenders(targetUserIDs[i], cmPath, outputTypeMask, sourceCode, drillParams, burstValue, savedOutputType);
            }
        } else {
            this.deletePreviousRenders(ownerID, cmPath, outputTypeMask, sourceCode, drillParams, burstValue, savedOutputType);
        }
    }

    public void deletePreviousRenders(int userID, String cmPath, int outputTypeMask, int sourceCode, String drillParams, String burstValue, SavedOutputType savedOutputType) throws CMException {
        List<IRenderRow> previousRenders = this.renderDAO.getPreviousRenders(cmPath, userID, -1, drillParams, burstValue, savedOutputType, OutputTypeManager.getInstance().getAllOutputFormats());
        for (IRenderRow previousRender : previousRenders) {
            int mask = previousRender.getIntField(RenderRow.RenderField.OUTPUT_TYPE_MASK);
            if (mask <= 0) {
                mask = OutputTypeManager.getInstance().getOutputTypesForUnspecified();
            }
            if ((mask & outputTypeMask) == mask) {
                VM.log(CLASS, 0, "Trying to delete previous renders with id: " + previousRender.getIntField(RenderRow.RenderField.RENDERID));
                this.softDeleteRender(previousRender.getIntField(RenderRow.RenderField.RENDERID), userID);
                continue;
            }
            if ((mask & outputTypeMask) != outputTypeMask) continue;
            this.updateRenderMask(previousRender, userID, mask & ~outputTypeMask);
        }
    }

    public List<RenderStatus> findRenderStatusByRenderId(int renderID) throws CMException {
        return this.renderDAO.findRenderStatusByRenderId(renderID);
    }

    public void flushOldRenders(int maxAgeDays) throws CMException {
        Integer[] oldRenders = this.renderDAO.getExpiredRenders(maxAgeDays);
        for (int i = 0; i < oldRenders.length; ++i) {
            if (oldRenders[i] == null) continue;
            this.deleteRender(oldRenders[i], -1);
        }
    }

    public IRenderRow getDashboard(int userID) throws CMException {
        return this.renderDAO.getDashboard(userID);
    }

    public int getDashboardID(int userID) throws CMException {
        IRenderRow row = this.renderDAO.getDashboard(userID);
        return row != null ? row.getIntField(RenderRow.RenderField.RENDERID) : 0;
    }

    public void updateDashboardForPortalItem(int ownerID, String cmPath, int portalItemID) throws CMException {
        IRenderRow render = this.renderDAO.getDashboard(ownerID);
        if (render != null && render.getStringField(RenderRow.RenderField.CMPATH).equals(cmPath)) {
            this.portalItemManager.updateUserPortalItem(ownerID, portalItemID, 0);
        }
    }

    public IRenderRow getLatestDrillTargetRender(int userID, String storeID, String drillParams) throws CMException {
        return this.renderDAO.getLatestDrillTargetRender(userID, storeID, drillParams);
    }

    public int getRenderSize(int renderID) throws CMException {
        return this.renderDAO.getRenderSize(renderID);
    }

    public IRenderRow[] getReportRecentRenders(int userID, String storeID) throws CMException {
        return this.renderDAO.getReportRecentRenders(userID, storeID);
    }

    public IRenderRow[] getReportSavedRenders(int userID, String storeID) throws CMException {
        return this.renderDAO.getReportSavedRenders(userID, storeID);
    }

    protected void updateUserDashboardPortalItem(int ownerID, String cmPath, int portalItemID, int[] targetUserIDs) throws CMException {
        if (targetUserIDs != null && targetUserIDs.length > 0) {
            for (int i = 0; i < targetUserIDs.length; ++i) {
                this.updateDashboardForPortalItem(targetUserIDs[i], cmPath, portalItemID);
            }
        } else {
            this.updateDashboardForPortalItem(ownerID, cmPath, portalItemID);
        }
    }

    public IRenderRow insertRender(int outputTypeMask, int ownerID, String label, String storeID, String cmPath, String sourcePath, String description, int sourceCode, String drillParams, String burstValue, String saveName, int portalItemID, String baseDoc, String smallThumb, String mediumThumb, String largeThumb, int portalItemType, SavedOutputType savedOutputType, Date creationDate, int[] targetUserIDs, String execId) throws CMException {
        this.updateUserDashboardPortalItem(ownerID, cmPath, portalItemID, targetUserIDs);
        PortalItemRow portalItem = new PortalItemRow(portalItemID, label, storeID, cmPath, sourcePath, description, portalItemType);
        IRenderRow render = this.renderDAO.insertRender(outputTypeMask, ownerID, sourceCode, drillParams, burstValue, portalItemID, baseDoc, smallThumb, mediumThumb, largeThumb, savedOutputType, creationDate, execId);
        render.setPortalItemInfo(portalItem);
        return render;
    }

    public IRenderRow insertRender(int[] targetUserIDs, IRenderRow row) throws CMException {
        this.updateUserDashboardPortalItem(row.getIntField(RenderRow.RenderField.OWNER_ID), row.getStringField(RenderRow.RenderField.CMPATH), row.getIntField(RenderRow.RenderField.PORTALITEM_ID), targetUserIDs);
        return this.renderDAO.insertRender(row);
    }

    public void insertRenderIntoInbox(IRenderRow render, int userID) throws CMException {
        int renderStatus = render.getIntField(RenderRow.RenderField.STATUS);
        if (renderStatus == RenderState.COMPLETE.getCode() || renderStatus == RenderState.ERROR.getCode() || renderStatus == RenderState.AVAILABLE.getCode()) {
            this.deletePreviousRenders(userID, render.getStringField(RenderRow.RenderField.CMPATH), render.getIntField(RenderRow.RenderField.OUTPUT_TYPE_MASK), render.getIntField(RenderRow.RenderField.SOURCECODE), render.getStringField(RenderRow.RenderField.DRILLPARAMS), render.getStringField(RenderRow.RenderField.BURST_VALUE), SavedOutputType.parse(render.getSavedOutputType()));
        }
        this.userRenderDAO.insert(userID, render.getIntField(RenderRow.RenderField.RENDERID));
    }

    public IRenderRow loadRender(int renderID) throws CMException {
        return this.renderDAO.loadRender(renderID);
    }

    public boolean renderIsInUsersInbox(int renderID, int userID) throws CMException {
        return this.renderDAO.renderIsInUsersInbox(renderID, userID);
    }

    public void setRenderLastViewed(int renderID, int userID) throws CMException {
        this.renderDAO.setRenderLastViewed(renderID, userID);
    }

    public void updateRenderRow(IRenderRow render) throws CMException {
        this.renderDAO.updateRenderRow(render);
    }

    public IRenderRow[] getRendersBySource(int sourceID) throws CMException {
        return this.renderDAO.getRendersBySource(sourceID);
    }

    public static enum PageOutputType {
        DB(1),
        CCSHTML(2),
        CCSHTMLI(4),
        VIEWERHTML(8),
        ACTIVEREPORTHTML(16),
        CWLIVEREPORT(32);

        private int mask;

        private PageOutputType(int mask) {
            this.mask = mask;
        }

        public int getMask() {
            return this.mask;
        }
    }
}

