/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.database;

import com.cognos.mobile.c8.OutputTypeManager;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.database.IRenderRow;
import com.cognos.mobile.database.PortalItemRow;
import com.cognos.mobile.database.RenderManager;
import com.cognos.mobile.database.RenderState;
import com.cognos.mobile.model.data.SavedOutputType;
import com.cognos.mobile.server.tabs.TabInfoHelper;
import com.cognos.mobile.server.tabs.TabInfoList;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;

public class RenderRow
implements IRenderRow {
    private int renderID = -1;
    private int ownerID = -1;
    private String label;
    private String storeID;
    private String cmPath;
    private String sourcePath;
    private String description;
    private Date renderTime;
    private int renderSize = -1;
    private int sourceCode = -1;
    private String drillParams;
    private String tmpFile;
    private int status = -1;
    private int portalItemID = -1;
    private String savedName;
    private int portalItemType = -1;
    private String baseDoc;
    private String smallThumb;
    private String mediumThumb;
    private String largeThumb;
    private boolean isViewed = false;
    private Exception exception;
    private SavedOutputType savedOutputType;
    private Date creationTime;
    private String burstValue;
    private int m_outputTypeMask = -1;
    private String m_executionID;
    private boolean isPromptPage = false;
    private int hasMorePages = -1;
    private String passport;
    private TabInfoList tabInfoList;
    private boolean needToSetOutputTypeMask = false;

    public RenderRow(ResultSet rs) throws SQLException {
        int i = 1;
        this.renderID = rs.getInt(i++);
        this.ownerID = rs.getInt(i++);
        this.label = rs.getString(i++);
        this.storeID = rs.getString(i++);
        this.cmPath = rs.getString(i++);
        this.sourcePath = rs.getString(i++);
        this.description = rs.getString(i++);
        this.renderTime = rs.getTimestamp(i++);
        this.renderSize = rs.getInt(i++);
        this.status = rs.getInt(i++);
        this.drillParams = rs.getString(i++);
        this.portalItemID = rs.getInt(i++);
        this.sourceCode = rs.getInt(i++);
        this.baseDoc = rs.getString(i++);
        this.smallThumb = rs.getString(i++);
        this.mediumThumb = rs.getString(i++);
        this.largeThumb = rs.getString(i++);
        this.isViewed = rs.getTimestamp(i++) != null;
        this.setField(RenderField.PORTALITEM_TYPE, rs.getInt(i++));
        this.savedName = rs.getString(i++);
        this.savedOutputType = SavedOutputType.parse(rs.getInt(i++));
        this.creationTime = rs.getTimestamp(i++);
        this.burstValue = rs.getString(i++);
        this.m_executionID = rs.getString(i++);
        this.setField(RenderField.OUTPUT_TYPE_MASK, rs.getInt(i++));
        this.hasMorePages = rs.getInt(i++);
        this.passport = rs.getString(i++);
        String jsonTabInfo = rs.getString(i++);
        this.tabInfoList = TabInfoHelper.generateTabInfoList(jsonTabInfo);
    }

    @Override
    public IRenderRow setField(RenderField field, boolean value) {
        switch (field) {
            case IS_VIEWED: {
                this.isViewed = value;
                break;
            }
            case IS_PROMPT_PAGE: {
                this.isPromptPage = value;
                break;
            }
            case HAS_MORE_PAGES: {
                this.hasMorePages = value ? 1 : 0;
                break;
            }
            default: {
                throw new RuntimeException("Unknown boolean field");
            }
        }
        return this;
    }

    @Override
    public boolean getBooleanField(RenderField field) {
        switch (field) {
            case IS_VIEWED: {
                return this.isViewed;
            }
            case IS_PROMPT_PAGE: {
                return this.isPromptPage;
            }
            case HAS_MORE_PAGES: {
                return this.hasMorePages == 1;
            }
        }
        throw new RuntimeException("Unknown boolean field");
    }

    @Override
    public IRenderRow setField(RenderField field, String value) {
        switch (field) {
            case LABEL: {
                this.label = value;
                break;
            }
            case STOREID: {
                this.storeID = value;
                break;
            }
            case CMPATH: {
                this.cmPath = value;
                break;
            }
            case SOURCEPATH: {
                this.sourcePath = value;
                break;
            }
            case DESCRIPTION: {
                this.description = value;
                break;
            }
            case DRILLPARAMS: {
                this.drillParams = value;
                break;
            }
            case TMP_FILE: {
                this.tmpFile = value;
                break;
            }
            case SAVED_NAME: {
                this.savedName = value;
                break;
            }
            case BASEDOC: {
                this.baseDoc = value;
                break;
            }
            case MEDIUM_THUMB: {
                this.mediumThumb = value;
                break;
            }
            case SMALL_THUMB: {
                this.smallThumb = value;
                break;
            }
            case LARGE_THUMB: {
                this.largeThumb = value;
                break;
            }
            case BURST_VALUE: {
                this.burstValue = value;
                break;
            }
            case EXECUTION_ID: {
                this.m_executionID = value;
                break;
            }
            case PASSPORT: {
                this.passport = value;
                break;
            }
            default: {
                throw new RuntimeException("Unknown string field");
            }
        }
        return this;
    }

    @Override
    public String getStringField(RenderField field) {
        switch (field) {
            case LABEL: {
                return this.label;
            }
            case STOREID: {
                return this.storeID;
            }
            case CMPATH: {
                return this.cmPath;
            }
            case SOURCEPATH: {
                return this.sourcePath;
            }
            case DESCRIPTION: {
                return this.description;
            }
            case DRILLPARAMS: {
                return this.drillParams;
            }
            case TMP_FILE: {
                return this.tmpFile;
            }
            case SAVED_NAME: {
                return this.savedName;
            }
            case BASEDOC: {
                return this.baseDoc;
            }
            case SMALL_THUMB: {
                return this.smallThumb;
            }
            case MEDIUM_THUMB: {
                return this.mediumThumb;
            }
            case LARGE_THUMB: {
                return this.largeThumb;
            }
            case BURST_VALUE: {
                return this.burstValue;
            }
            case EXECUTION_ID: {
                return this.m_executionID;
            }
            case PASSPORT: {
                return this.passport;
            }
        }
        throw new RuntimeException("Unknown string field");
    }

    @Override
    public IRenderRow setField(RenderField field, int value) {
        switch (field) {
            case RENDERID: {
                this.renderID = value;
                break;
            }
            case OWNER_ID: {
                this.ownerID = value;
                break;
            }
            case RENDERSIZE: {
                this.renderSize = value;
                break;
            }
            case SOURCECODE: {
                this.sourceCode = value;
                break;
            }
            case STATUS: {
                this.status = value;
                break;
            }
            case PORTALITEM_ID: {
                this.portalItemID = value;
                break;
            }
            case PORTALITEM_TYPE: {
                this.portalItemType = value == 0 ? 51 : (value == 1 ? 57 : (value == 5 ? 56 : (value == 12 ? 52 : (value == 13 ? 53 : (value == 14 ? 55 : (value == 15 ? 54 : (value == 16 ? 65 : value)))))));
                if (!this.needToSetOutputTypeMask) break;
                this.setField(RenderField.OUTPUT_TYPE_MASK, 0);
                this.needToSetOutputTypeMask = false;
                break;
            }
            case OUTPUT_TYPE_MASK: {
                if (value == 0) {
                    if (!this.isSet(RenderField.PORTALITEM_TYPE)) {
                        this.needToSetOutputTypeMask = true;
                        break;
                    }
                    if (this.getIntField(RenderField.PORTALITEM_TYPE) == 57) {
                        this.m_outputTypeMask = RenderManager.PageOutputType.ACTIVEREPORTHTML.getMask();
                        break;
                    }
                    this.m_outputTypeMask = OutputTypeManager.getInstance().getOutputTypesForUnspecified();
                    break;
                }
                this.m_outputTypeMask = value;
                break;
            }
            default: {
                throw new RuntimeException("Unknown int field");
            }
        }
        return this;
    }

    @Override
    public int getIntField(RenderField field) {
        switch (field) {
            case RENDERID: {
                return this.renderID;
            }
            case OWNER_ID: {
                return this.ownerID;
            }
            case RENDERSIZE: {
                return this.renderSize;
            }
            case SOURCECODE: {
                return this.sourceCode;
            }
            case STATUS: {
                return this.status;
            }
            case PORTALITEM_ID: {
                return this.portalItemID;
            }
            case PORTALITEM_TYPE: {
                return this.portalItemType;
            }
            case OUTPUT_TYPE_MASK: {
                return this.m_outputTypeMask;
            }
        }
        throw new RuntimeException("Unknown int field");
    }

    @Override
    public boolean isSet(RenderField field) {
        switch (field) {
            case RENDERID: {
                return this.renderID != -1;
            }
            case OWNER_ID: {
                return this.ownerID != -1;
            }
            case LABEL: {
                return this.label != null;
            }
            case STOREID: {
                return this.storeID != null;
            }
            case CMPATH: {
                return this.cmPath != null;
            }
            case SOURCEPATH: {
                return this.sourcePath != null;
            }
            case DESCRIPTION: {
                return this.description != null;
            }
            case RENDERTIME: {
                return this.renderTime != null;
            }
            case RENDERSIZE: {
                return this.renderSize != -1;
            }
            case SOURCECODE: {
                return this.sourceCode != -1;
            }
            case DRILLPARAMS: {
                return this.drillParams != null;
            }
            case TMP_FILE: {
                return this.tmpFile != null;
            }
            case STATUS: {
                return this.status != -1;
            }
            case PORTALITEM_ID: {
                return this.portalItemID != -1;
            }
            case PORTALITEM_TYPE: {
                return this.portalItemType != -1;
            }
            case SAVED_NAME: {
                return this.savedName != null;
            }
            case BASEDOC: {
                return this.baseDoc != null;
            }
            case SMALL_THUMB: {
                return this.smallThumb != null;
            }
            case MEDIUM_THUMB: {
                return this.mediumThumb != null;
            }
            case LARGE_THUMB: {
                return this.largeThumb != null;
            }
            case IS_VIEWED: {
                return this.isViewed;
            }
            case EXCEPTION: {
                return this.exception != null;
            }
            case BURST_VALUE: {
                return this.burstValue != null;
            }
            case OUTPUT_TYPE_MASK: {
                return this.m_outputTypeMask != -1;
            }
            case IS_PROMPT_PAGE: {
                return this.isPromptPage;
            }
            case HAS_MORE_PAGES: {
                return this.hasMorePages != -1;
            }
            case EXECUTION_ID: {
                return this.m_executionID != null;
            }
            case PASSPORT: {
                return this.passport != null;
            }
            case TAB_INFO: {
                return this.tabInfoList != null;
            }
        }
        throw new RuntimeException("Unknown field");
    }

    public RenderRow(int renderID, int ownerID, String label, String storeID, String cmPath, String sourcePath, String description, Date renderTime, int renderSize, int sourceCode, String drillParams, int status, int portalItemID, String baseDoc, String smallThumb, String mediumThumb, String largeThumb, int savedOutputType, Date creationTime, String burstValue, int hasMorePages, String passport, int portalItemType, int outputTypeMask, String tabInfo) {
        this.renderID = renderID;
        this.ownerID = ownerID;
        this.label = label;
        this.storeID = storeID;
        this.cmPath = cmPath;
        this.sourcePath = sourcePath;
        this.description = description;
        this.renderTime = renderTime;
        this.renderSize = renderSize;
        this.sourceCode = sourceCode;
        this.drillParams = drillParams;
        this.status = status;
        this.portalItemID = portalItemID;
        this.baseDoc = baseDoc;
        this.smallThumb = smallThumb;
        this.mediumThumb = mediumThumb;
        this.largeThumb = largeThumb;
        this.savedOutputType = SavedOutputType.parse(savedOutputType);
        this.creationTime = creationTime;
        this.burstValue = burstValue;
        this.hasMorePages = hasMorePages;
        this.passport = passport;
        this.setField(RenderField.PORTALITEM_TYPE, portalItemType);
        this.setField(RenderField.OUTPUT_TYPE_MASK, outputTypeMask);
        this.tabInfoList = TabInfoHelper.generateTabInfoList(tabInfo);
    }

    public RenderRow(int renderID, int ownerID, Date renderTime, int renderSize, int sourceCode, String drillParams, int status, int portalItemID, String baseDoc, String smallThumb, String mediumThumb, String largeThumb, int savedOutputType, Date creationTime, String burstValue, int hasMorePages, String passport, int portalItemType, int outputTypeMask, TabInfoList tabInfoList) {
        this.renderID = renderID;
        this.ownerID = ownerID;
        this.renderTime = renderTime;
        this.renderSize = renderSize;
        this.sourceCode = sourceCode;
        this.drillParams = drillParams;
        this.status = status;
        this.portalItemID = portalItemID;
        this.baseDoc = baseDoc;
        this.smallThumb = smallThumb;
        this.mediumThumb = mediumThumb;
        this.largeThumb = largeThumb;
        this.savedOutputType = SavedOutputType.parse(savedOutputType);
        this.creationTime = creationTime;
        this.burstValue = burstValue;
        this.hasMorePages = hasMorePages;
        this.passport = passport;
        this.setField(RenderField.PORTALITEM_TYPE, portalItemType);
        this.setField(RenderField.OUTPUT_TYPE_MASK, outputTypeMask);
        this.setTabInfoList(tabInfoList);
    }

    public RenderRow() {
        this.savedOutputType = SavedOutputType.NONE;
    }

    @Override
    public void initCompileData(int renderID, int renderSize) {
        this.renderID = renderID;
        this.renderSize = renderSize;
    }

    @Override
    public Date getRenderTime() {
        return this.renderTime;
    }

    @Override
    public void setRenderTime(Date renderTime) {
        this.renderTime = renderTime;
    }

    @Override
    public void setPortalItemInfo(PortalItemRow portalItem) {
        this.portalItemID = portalItem.getPortalItemID();
        this.label = portalItem.getLabel();
        this.storeID = portalItem.getStoreID();
        this.cmPath = portalItem.getCMPath();
        this.sourcePath = portalItem.getSourcePath();
        this.description = portalItem.getDescription();
        this.setField(RenderField.PORTALITEM_TYPE, portalItem.getPortalItemType());
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    @Override
    public boolean hasPromptException() {
        if (this.exception != null) {
            CMException ex;
            if (this.exception.getMessage().indexOf("RDS-ERR-1021") != -1) {
                return true;
            }
            if (this.exception.getMessage().indexOf("PROMPT_ERROR") != -1) {
                return true;
            }
            if (this.exception instanceof CMException && (ex = (CMException)this.exception).getErrorCode() == 1113) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setException(Exception exception) {
        this.exception = exception;
    }

    @Override
    public int getSavedOutputType() {
        if (this.savedOutputType != null) {
            return this.savedOutputType.getType();
        }
        return -1;
    }

    @Override
    public IRenderRow setSavedOutputType(int savedOutput) {
        this.savedOutputType = SavedOutputType.parse(savedOutput);
        return this;
    }

    @Override
    public IRenderRow setSavedOutputType(SavedOutputType savedOutputType) {
        this.savedOutputType = savedOutputType;
        return this;
    }

    @Override
    public String getSavedOutputDesc() {
        return this.savedOutputType.toString();
    }

    @Override
    public Date getCreationTime() {
        return this.creationTime;
    }

    @Override
    public IRenderRow setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    @Override
    public String getCMPath() {
        return this.cmPath;
    }

    @Override
    public int updateResultSet(ResultSet rs) throws SQLException {
        int count = 0;
        if (rs.getInt(1) != this.renderID) {
            rs.updateInt(1, this.renderID);
            ++count;
        }
        if (CMStringHelper.compareStrings(rs.getString(3), this.label) != 0) {
            rs.updateString(3, this.label);
            ++count;
        }
        if (CMStringHelper.compareStrings(rs.getString(4), this.cmPath) != 0) {
            rs.updateString(4, this.cmPath);
            ++count;
        }
        if (CMStringHelper.compareStrings(rs.getString(5), this.sourcePath) != 0) {
            rs.updateString(5, this.sourcePath);
            ++count;
        }
        if (!rs.getDate(6).equals(this.renderTime)) {
            rs.updateTimestamp(6, new Timestamp(this.renderTime.getTime()));
            ++count;
        }
        if (rs.getInt(7) != this.renderSize) {
            rs.updateInt(7, this.renderSize);
            ++count;
        }
        if (count != 0) {
            rs.updateRow();
        }
        return count;
    }

    @Override
    public boolean showInInbox() {
        boolean show = false;
        if (RenderState.AVAILABLE.getCode() == this.status || RenderState.COMPLETE.getCode() == this.status || RenderState.ERROR.getCode() == this.status) {
            show = true;
        }
        return show;
    }

    @Override
    public String getDisplayableLabel() {
        return this.burstValue != null ? this.label + " (" + this.burstValue + ")" : this.label;
    }

    @Override
    public IRenderRow setTabInfoList(TabInfoList tabInfo) {
        this.tabInfoList = tabInfo;
        return this;
    }

    @Override
    public TabInfoList getTabInfoList() {
        return this.tabInfoList;
    }

    public static enum RenderField {
        RENDERID,
        OWNER_ID,
        LABEL,
        STOREID,
        CMPATH,
        SOURCEPATH,
        DESCRIPTION,
        RENDERTIME,
        RENDERSIZE,
        SOURCECODE,
        DRILLPARAMS,
        TMP_FILE,
        STATUS,
        PORTALITEM_ID,
        SAVED_NAME,
        PORTALITEM_TYPE,
        BASEDOC,
        SMALL_THUMB,
        MEDIUM_THUMB,
        LARGE_THUMB,
        IS_VIEWED,
        EXCEPTION,
        BURST_VALUE,
        OUTPUT_TYPE_MASK,
        EXECUTION_ID,
        IS_PROMPT_PAGE,
        HAS_MORE_PAGES,
        PASSPORT,
        TAB_INFO;

    }
}

