/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.database;

import java.util.ArrayList;
import java.util.List;

public class RenderState {
    private static final List states = new ArrayList();
    public static final RenderState PENDING = new RenderState(states, "PENDING", 3);
    public static final RenderState CANCELLED = new RenderState(states, "CANCELLED", 9);
    public static final RenderState DELETED = new RenderState(states, "DELETED", 10);
    public static final RenderState INPROGRESS = new RenderState(states, "IN PROGRESS", 1);
    public static final RenderState AVAILABLE = new RenderState(states, "AVAILABLE", 15);
    public static final RenderState PROMPTING = new RenderState(states, "PROMPTING", 16);
    public static final RenderState COMPLETE = new RenderState(states, "COMPLETED", 2);
    public static final RenderState ERROR = new RenderState(states, "ERROR", 99);
    private final String desc;
    private final int code;

    private RenderState(List states, String description, int code) {
        this.desc = description;
        this.code = code;
        states.add(this);
    }

    public int getCode() {
        return this.code;
    }

    public String toString() {
        return this.desc;
    }

    public static RenderState parse(int code) {
        for (int i = 0; i < states.size(); ++i) {
            RenderState s = (RenderState)states.get(i);
            if (s.getCode() != code) continue;
            return s;
        }
        throw new IllegalArgumentException("Not a valid code: " + code);
    }

    public static RenderState parse(String desc) {
        for (int i = 0; i < states.size(); ++i) {
            RenderState s = (RenderState)states.get(i);
            if (!s.desc.equals(desc)) continue;
            return s;
        }
        throw new IllegalArgumentException("Status " + desc + " not valid.");
    }
}

