/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.database;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.configuration.IConfiguration;
import com.cognos.mobile.database.BlobManager;
import com.cognos.mobile.database.IResourceDAO;
import com.cognos.mobile.database.ISQLDatabase;
import com.cognos.mobile.database.ResourceRow;
import com.cognos.mobile.database.SQLResourceDAO;
import com.cognos.mobile.vm.VM;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class ResourceManager {
    private static Class<ResourceManager> CLASS = ResourceManager.class;
    private final IResourceDAO resourceDAO;
    private final BlobManager blobManager;
    private final IConfiguration scconfig;

    public ResourceManager(ISQLDatabase database, BlobManager blobManager, IConfiguration scconfig) {
        this.resourceDAO = new SQLResourceDAO(database);
        this.blobManager = blobManager;
        this.scconfig = scconfig;
    }

    public Connection getTransactionConnection() throws CMException {
        return this.resourceDAO.getTransactionConnection();
    }

    public void releaseTransactionConnection(Connection connection) {
        this.resourceDAO.releaseTransactionConnection(connection);
    }

    public void insertResource(int renderID, String path, String hash, byte[] blob, int format, int height, int width) throws CMException {
        this.resourceDAO.insertResource(renderID, path, hash, format, height, width, null);
        this.blobManager.insertBlob(hash, blob, renderID, null);
    }

    public void insertResource(int renderID, String path, String hash, byte[] blob, int format, int height, int width, int blobID, int objectIndex, int pageIndex) throws CMException {
        String msg;
        Connection connection;
        boolean combinedCommit = this.scconfig.getBoolean("Reports.CombinedResourceBlobCommit", false);
        if (combinedCommit) {
            try {
                connection = this.resourceDAO.getTransactionConnection();
            }
            catch (CMException cme) {
                msg = "failed to obtain connection";
                VM.log(CLASS, 0, msg, cme);
                connection = null;
            }
        } else {
            connection = null;
        }
        this.resourceDAO.insertResource(renderID, path, hash, format, height, width, connection);
        this.blobManager.insertBlob(hash, blob, renderID, connection);
        if (combinedCommit && connection != null) {
            try {
                connection.commit();
            }
            catch (SQLException se) {
                msg = "resource/blob insert failed";
                VM.log(CLASS, 0, msg, se);
                try {
                    connection.rollback();
                }
                catch (Exception e) {
                    VM.log(CLASS, 0, "rollback failed", e);
                }
                VM.log(CLASS, 0, msg, se);
                throw new CMException(1126, msg, (Throwable)se);
            }
            finally {
                try {
                    connection.commit();
                }
                catch (Exception e) {
                    VM.log(CLASS, 0, "final commit failed", e);
                }
                try {
                    this.resourceDAO.releaseTransactionConnection(connection);
                }
                catch (Exception e) {
                    VM.log(CLASS, 0, "connection close failed", e);
                }
            }
        }
    }

    public void insertResource(int renderID, String path, String hash, int format, int height, int width, Connection connection) throws CMException {
        this.resourceDAO.insertResource(renderID, path, hash, format, height, width, connection);
    }

    public void insertResource(int renderID, String path, String hash, int format, int height, int width, int blobID, int objectIndex, int pageIndex) throws CMException {
        this.resourceDAO.insertResource(renderID, path, hash, format, height, width, blobID, objectIndex, pageIndex);
    }

    public void insertExternalResources(List<ResourceRow> rr) throws CMException {
        if (rr.size() > 0) {
            this.resourceDAO.insertExternalResources(rr);
        }
    }

    public boolean resourceHashIsInUsersInbox(String hash, int userID) throws CMException {
        return this.resourceDAO.resourceHashIsInUsersInbox(hash, userID);
    }

    public ResourceRow[] getResourceList(int connectionID, int[] formats) throws CMException {
        return this.resourceDAO.getResourceList(connectionID, formats);
    }

    public ResourceRow getResource(String hash) throws CMException {
        return this.resourceDAO.getResource(hash);
    }

    public ResourceRow getResource(int renderID, int blobID, int format, int objectIndex, int page) throws CMException {
        return this.resourceDAO.getResource(renderID, blobID, format, objectIndex, page);
    }

    public ResourceRow getResource(String path, int renderId) throws CMException {
        return this.resourceDAO.getResource(path, renderId);
    }

    public ResourceRow getResource(int renderId, String path, String hash) throws CMException {
        return this.resourceDAO.getResource(renderId, path, hash);
    }

    public byte[] getResourceBytes(String hash) throws CMException {
        return this.blobManager.getBlob(hash);
    }

    public byte[] getResourceBytes(int renderID, int blobID, int format, int objectIndex, int page) throws CMException {
        ResourceRow resource = this.resourceDAO.getResource(renderID, blobID, format, objectIndex, page);
        if (resource == null) {
            return null;
        }
        return this.blobManager.getBlob(resource.getHash());
    }

    public int getMaxBlobID(int renderID) throws CMException {
        return this.resourceDAO.getMaxBlobID(renderID);
    }

    public void insertResource(String hash, int format) throws CMException {
        this.resourceDAO.insertResource(hash, format);
    }

    public void removeResource(int renderID, int pageIndex) throws CMException {
        this.resourceDAO.removeResource(renderID, pageIndex);
    }

    public boolean isUIThemeResource(String hash) throws CMException {
        return this.resourceDAO.isUIThemeResource(hash);
    }

    public void updateResourceRenderReferences(int oldRenderID, int newRenderID) throws CMException {
        this.resourceDAO.updateResourceRenderReferences(oldRenderID, newRenderID);
    }
}

