/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.database;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.database.IResultSetAccumulator;
import com.cognos.mobile.database.ISQLDatabase;
import com.cognos.mobile.vm.VM;
import java.sql.ResultSet;

public class SQLBaseReportDAO {
    private static final Class CLASS = SQLBaseReportDAO.class;
    private final ISQLDatabase database;

    public SQLBaseReportDAO(ISQLDatabase database) {
        this.database = database;
    }

    public ISQLDatabase getDatabase() {
        return this.database;
    }

    protected final int getCountCommon(String connector, int connectorID, String tableName, String extraClause) throws CMException {
        StringBuffer sql = new StringBuffer();
        sql.append("select count(*)");
        sql.append(" from ");
        sql.append(tableName);
        sql.append(" where " + connector + "=");
        sql.append(connectorID);
        if (extraClause != null) {
            sql.append(" and ");
            sql.append(extraClause);
        }
        final int[] count = new int[1];
        final boolean[] processed = new boolean[]{false};
        IResultSetAccumulator accumulator = new IResultSetAccumulator(){

            @Override
            public IResultSetAccumulator.Action accumulate(ResultSet resultSet) throws Exception {
                count[0] = resultSet.getInt(1);
                processed[0] = true;
                return IResultSetAccumulator.STOP;
            }
        };
        try {
            this.database.executeQuery(sql.toString(), accumulator);
            if (processed[0]) {
                return count[0];
            }
            String details = "failed to get count";
            VM.log(CLASS, 0, details);
            throw new CMException(1120, details);
        }
        catch (Exception ex) {
            String details = "failed to get count";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1120, details, (Throwable)ex);
        }
    }
}

