/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.database;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.common.CompressionHelper;
import com.cognos.mobile.configuration.IConfiguration;
import com.cognos.mobile.database.DefaultPreparedStatementParameterizer;
import com.cognos.mobile.database.IBlobDAO;
import com.cognos.mobile.database.IResultSetAccumulator;
import com.cognos.mobile.database.ISQLDatabase;
import com.cognos.mobile.database.SQLBaseReportDAO;
import com.cognos.mobile.vm.VM;
import java.io.ByteArrayOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class SQLBlobDAO
extends SQLBaseReportDAO
implements IBlobDAO {
    private static final Class<SQLBlobDAO> CLASS = SQLBlobDAO.class;
    private final IConfiguration scconfig;

    public SQLBlobDAO(ISQLDatabase database, IConfiguration scconfig) {
        super(database);
        this.scconfig = scconfig;
    }

    @Override
    public byte[] getBlob(int userID) throws CMException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT BLOB_VALUE, SEQUENCE, TOTAL_BLOB_SIZE FROM MOB_BLOBS WHERE USER_ID=");
        sql.append(userID);
        sql.append(" ORDER BY SEQUENCE");
        return this.getBlobCommon(sql.toString(), CompressAction.noCompress);
    }

    @Override
    public byte[] getBlob(String hash) throws CMException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT BLOB_VALUE, SEQUENCE, TOTAL_BLOB_SIZE FROM MOB_BLOBS WHERE HASH='");
        sql.append(CMStringHelper.replaceAll(hash, "'", "''", true));
        sql.append("'");
        sql.append(" ORDER BY SEQUENCE");
        return this.getBlobCommon(sql.toString(), CompressAction.doDefaultCompress);
    }

    public byte[] getBlobCommon(String sql, CompressAction compress) throws CMException {
        final ByteArrayOutputStream[] bytes = new ByteArrayOutputStream[1];
        final boolean[] found = new boolean[]{false};
        IResultSetAccumulator accumulator = new IResultSetAccumulator(){
            private int lastSequence = -1;
            private boolean first = true;

            @Override
            public IResultSetAccumulator.Action accumulate(ResultSet resultSet) throws Exception {
                if (this.first) {
                    this.first = false;
                    int blobSize = resultSet.getInt(3);
                    blobSize = Math.max(32, blobSize);
                    bytes[0] = new ByteArrayOutputStream(blobSize);
                }
                byte[] b = SQLBlobDAO.this.getDatabase().getBlobBytes(resultSet, 1);
                int currentSequence = resultSet.getInt(2);
                if (b != null && b.length > 0 && currentSequence != this.lastSequence) {
                    bytes[0].write(b);
                }
                found[0] = true;
                this.lastSequence = currentSequence;
                return IResultSetAccumulator.CONTINUE;
            }
        };
        try {
            this.getDatabase().executeQuery(sql, accumulator);
            if (found[0]) {
                if (compress == CompressAction.doDefaultCompress) {
                    return CompressionHelper.decompress(bytes[0].toByteArray());
                }
                return bytes[0].toByteArray();
            }
            return null;
        }
        catch (CMException ex) {
            String details = "failed to read blob";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1127, details, (Throwable)ex);
        }
    }

    @Override
    public int insertBlob(String hash, byte[] blob, int renderID, StringBuilder detailsLog, Connection connection) throws CMException {
        return this.insertBlobCommon(hash, -1, blob, detailsLog, connection);
    }

    @Override
    public void insertBlob(int userID, byte[] blob) throws CMException {
        this.insertBlobCommon(null, userID, blob, null, null);
    }

    private int insertBlobCommon(String hash, int userID, byte[] blob, StringBuilder detailsLog, Connection connection) throws CMException {
        if (blob == null) {
            blob = new byte[]{};
            VM.log(CLASS, 0, "encountered nulled blob hash:" + hash);
        } else if (blob.length == 0) {
            VM.log(CLASS, 0, "encountered empty blob hash:" + hash);
        }
        int recordCount = (int)Math.ceil((double)blob.length / (double)this.getDatabase().getMaxBlobChunkSize());
        StringBuffer sql = new StringBuffer();
        sql.append("insert into MOB_BLOBS");
        if (userID > -1) {
            sql.append(" (USER_ID,SEQUENCE,BLOB_VALUE, TOTAL_BLOB_SIZE)");
            sql.append(" values");
            sql.append(" (");
            sql.append(userID);
        } else {
            sql.append(" (HASH, SEQUENCE, BLOB_VALUE, TOTAL_BLOB_SIZE)");
            sql.append(" values");
            sql.append(" (");
            sql.append(hash == null ? "NULL" : "'" + CMStringHelper.replaceAll(hash, "'", "''", true) + "'");
        }
        sql.append(", ");
        sql.append("?, ?, ?)");
        if (detailsLog != null) {
            detailsLog.append("Blob length:").append(blob.length).append(" Chunk size:").append(this.getDatabase().getMaxBlobChunkSize()).append(" Record count:").append(recordCount).append("\n").append("SQL:").append(sql.toString()).append("\n");
        }
        InsertBlobStatementParameterizer ibsp = new InsertBlobStatementParameterizer(blob, this.getDatabase(), recordCount, detailsLog);
        try {
            int blobBatchSize = 0;
            if (this.scconfig != null) {
                blobBatchSize = this.scconfig.getInt("Reports.BlobBatchSize", 0);
            }
            if (blobBatchSize > 0) {
                this.getDatabase().executeBatchedPreparedStatement(connection, sql.toString(), ibsp, blobBatchSize, detailsLog);
            } else {
                this.getDatabase().executePreparedStatement(connection, sql.toString(), ibsp, detailsLog);
            }
        }
        catch (CMException ex) {
            String msg = "failed to create statement";
            VM.log(CLASS, 0, msg, ex);
            throw new CMException(1125, msg, (Throwable)ex);
        }
        return recordCount;
    }

    @Override
    public String[] getUnusedBlobs() throws CMException {
        final ArrayList hashes = new ArrayList();
        final String[] hash = new String[]{""};
        ISQLDatabase database = null;
        Connection connection = null;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT DISTINCT HASH FROM MOB_BLOBS WHERE HASH NOT IN ( SELECT DISTINCT HASH FROM MOB_RESOURCES )");
        try {
            database = this.getDatabase();
            connection = database.getConnection();
            try {
                connection.setTransactionIsolation(1);
            }
            catch (SQLException se) {
                VM.log(CLASS, 0, "Error setting read uncommitted transaction isolation", se);
            }
            database.executeQuery(connection, sql.toString(), new IResultSetAccumulator(){

                @Override
                public IResultSetAccumulator.Action accumulate(ResultSet rs) throws Exception {
                    hash[0] = rs.getString(1);
                    hashes.add(hash[0]);
                    return IResultSetAccumulator.CONTINUE;
                }
            });
            String[] se = hashes.toArray(new String[hashes.size()]);
            return se;
        }
        catch (CMException ex) {
            String details = "Error deleting unused blob hash:" + hash[0];
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1121, details, (Throwable)ex);
        }
        finally {
            if (database != null && connection != null) {
                database.quietlyReleaseConnection(connection);
            }
        }
    }

    @Override
    public void deleteUnusedBlobs() throws CMException {
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("DELETE FROM MOB_BLOBS WHERE HASH NOT IN ( SELECT DISTINCT HASH FROM MOB_RESOURCES )");
            this.getDatabase().executeUpdate(sql.toString(), new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    return false;
                }
            }, null, null);
        }
        catch (CMException ex) {
            String details = "Error deleting unused blobs";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1121, details, (Throwable)ex);
        }
    }

    @Override
    public void deleteBlob(final int userID) throws CMException {
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("DELETE FROM MOB_BLOBS WHERE (USER_ID = ?)");
            this.getDatabase().executeUpdate(sql.toString(), new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setInt(i++, userID);
                    return false;
                }
            }, null, null);
        }
        catch (CMException ex) {
            String details = "Error deleting cookie blob";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1121, details, (Throwable)ex);
        }
    }

    @Override
    public void deleteBlob(final String hash, StringBuilder detailsLog) throws CMException {
        try {
            VM.log(CLASS, 0, "deleting blob hash:" + hash);
            StringBuffer sql = new StringBuffer();
            sql.append("DELETE FROM MOB_BLOBS WHERE (HASH = ?)");
            if (detailsLog != null) {
                detailsLog.append("deleteBlob hash:").append(hash).append(" SQL:").append(sql.toString()).append("\n");
            }
            this.getDatabase().executeUpdate(sql.toString(), new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setString(i++, hash);
                    return false;
                }
            }, null, null);
        }
        catch (CMException ex) {
            String msg = "Error deleting blob hash: " + hash;
            VM.log(CLASS, 0, msg, ex);
            throw new CMException(1121, msg, (Throwable)ex);
        }
    }

    @Override
    public boolean blobExists(String hash) throws CMException {
        final boolean[] found = new boolean[]{false};
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT HASH FROM MOB_BLOBS WHERE HASH='");
        sql.append(CMStringHelper.replaceAll(hash, "'", "''", true));
        sql.append("'");
        try {
            this.getDatabase().executeQuery(sql.toString(), new IResultSetAccumulator(){

                @Override
                public IResultSetAccumulator.Action accumulate(ResultSet rs) throws Exception {
                    found[0] = true;
                    return IResultSetAccumulator.STOP;
                }
            });
            return found[0];
        }
        catch (CMException ex) {
            String details = "Error querying for blob existance: " + hash + "";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1127, details, (Throwable)ex);
        }
    }

    @Override
    public int blobRecordCount(String hash, int userID, StringBuilder detailsLog) throws CMException {
        final int[] count = new int[]{0};
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT COUNT(*) FROM MOB_BLOBS WHERE ");
        if (userID > -1) {
            sql.append("USER_ID=");
            sql.append(userID);
        } else {
            sql.append("HASH='");
            sql.append(CMStringHelper.replaceAll(hash, "'", "''", true));
            sql.append("'");
        }
        if (detailsLog != null) {
            detailsLog.append("blobRecordCount SQL:").append(sql.toString()).append("\n");
        }
        try {
            this.getDatabase().executeQuery(sql.toString(), new IResultSetAccumulator(){

                @Override
                public IResultSetAccumulator.Action accumulate(ResultSet rs) throws Exception {
                    count[0] = rs.getInt(1);
                    return IResultSetAccumulator.STOP;
                }
            });
            return count[0];
        }
        catch (CMException ex) {
            String msg = "Error querying for blob record count: " + hash + "";
            VM.log(CLASS, 0, msg, ex);
            throw new CMException(1127, msg, (Throwable)ex);
        }
    }

    private static class InsertBlobStatementParameterizer
    extends DefaultPreparedStatementParameterizer {
        private int currentRecord = 0;
        private byte[] blob;
        private final ISQLDatabase database;
        private int recordCount = 0;
        private boolean first = true;
        StringBuilder detailsLog;

        public InsertBlobStatementParameterizer(byte[] blob, ISQLDatabase database, int recordCount, StringBuilder detailsLog) {
            this.blob = blob;
            this.database = database;
            this.recordCount = recordCount;
            this.detailsLog = detailsLog;
        }

        @Override
        public boolean parameterize(PreparedStatement statement) throws CMException {
            if (this.currentRecord >= this.recordCount) {
                if (this.detailsLog != null) {
                    this.detailsLog.append("FINISHED currentRecord:").append(this.currentRecord).append("\n");
                }
                return false;
            }
            int startByte = this.currentRecord * this.database.getMaxBlobChunkSize();
            int stopByte = Math.min(this.blob.length, (this.currentRecord + 1) * this.database.getMaxBlobChunkSize());
            int length = stopByte - startByte;
            if (this.detailsLog != null) {
                this.detailsLog.append("currentRecord:").append(this.currentRecord).append(" startByte:").append(startByte).append(" stopByte:").append(stopByte).append(" length:").append(length).append("\n");
            }
            try {
                statement.setInt(1, this.currentRecord);
                this.database.setBlobSpecial(statement, 2, this.blob, startByte, length, this.detailsLog);
                if (this.first) {
                    this.first = false;
                    statement.setInt(3, this.blob.length);
                } else {
                    statement.setNull(3, 4);
                }
                ++this.currentRecord;
                return true;
            }
            catch (SQLException ex) {
                String details = "failed to insert blob! max blob chunk size used: " + this.database.getMaxBlobChunkSize();
                VM.log(CLASS, 0, details, ex);
                throw new CMException(1126, details, (Throwable)ex);
            }
        }
    }

    static enum CompressAction {
        doDefaultCompress,
        noCompress;

    }
}

