/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.database;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.configuration.IConfiguration;
import com.cognos.mobile.database.DBDB2Database;
import com.cognos.mobile.database.DBDerbyNetworkedDatabase;
import com.cognos.mobile.database.DBInformixDatabase;
import com.cognos.mobile.database.DBOracleDatabase;
import com.cognos.mobile.database.DBSqlDatabase;
import com.cognos.mobile.database.DBSqlServerDatabase;
import com.cognos.mobile.database.IConnectionPool;
import com.cognos.mobile.database.ISQLDatabase;
import com.cognos.mobile.database.SQLDatabaseFactory;
import java.util.Properties;

public class SQLDatabaseFactoryImpl
implements SQLDatabaseFactory {
    private static final Class<SQLDatabaseFactoryImpl> CLASS = SQLDatabaseFactoryImpl.class;
    private static final String LITERAL_MICROSOFT = "Microsoft";
    private static final String LITERAL_ORACLE = "Oracle";
    private static final String LITERAL_ORACLE_ADVANCED = "OracleAdvanced";
    private static final String LITERAL_DERBY = "Derby";
    private static final String LITERAL_DB2 = "DB2";
    private static final String LITERAL_INFORMIX = "Informix";
    private static final String LITERAL_MICROSOFT_WIN_AUTH = "MicrosoftWinAuth";

    @Override
    public ISQLDatabase createFromBus(String c8Setting, IConfiguration configuration, IConnectionPool connectionPool, String databaseName, String hostPort, String username, String password, String serviceName, String specifier, Properties props, boolean SSLEnabled) throws CMException {
        DBSqlDatabase sqlDatabase;
        if (c8Setting.equalsIgnoreCase(LITERAL_MICROSOFT)) {
            if (hostPort == null || databaseName == null) {
                throw new CMException(1146, "Microsoft SQL Server databases requires 'server', 'user' and 'name' elements in DB config");
            }
            String driverClass = configuration.getString("JSQL_DRIVER_CLASS", "com.microsoft.sqlserver.jdbc.SQLServerDriver");
            StringBuilder connectionUrl = new StringBuilder(configuration.getString("JSQL_CONNECTION_URL", "jdbc:sqlserver://{1};databaseName={2}"));
            if (SSLEnabled) {
                connectionUrl.append(configuration.getString("CONNECTION_OPTION_SSL", ";encrypt=true;trustServerCertificate=false"));
            }
            sqlDatabase = new DBSqlServerDatabase(connectionPool, driverClass, connectionUrl.toString(), hostPort, databaseName, username, password, props, configuration);
        } else if (c8Setting.equalsIgnoreCase(LITERAL_ORACLE_ADVANCED)) {
            if (specifier == null) {
                throw new CMException(1146, "Oracle Advanced database requires 'server', 'user', and 'specifier' elements in DB config");
            }
            String driverClass = configuration.getString("ORACLE_ADVANCED_DRIVER_CLASS", "oracle.jdbc.driver.OracleDriver");
            String connectionUrl = configuration.getString("ORACLE_ADVANCED_CONNECTION_URL", "jdbc:oracle:thin:@{1}");
            sqlDatabase = new DBOracleDatabase(connectionPool, driverClass, connectionUrl, hostPort, serviceName, username, password, specifier, configuration);
        } else if (c8Setting.equalsIgnoreCase(LITERAL_ORACLE)) {
            if (hostPort == null || serviceName == null) {
                throw new CMException(1146, "Oracle database requires 'server', 'user', and 'servicename' elements in DB config");
            }
            String driverClass = configuration.getString("ORACLE_DRIVER_CLASS", "oracle.jdbc.driver.OracleDriver");
            String connectionUrl = configuration.getString("ORACLE_CONNECTION_URL", "jdbc:oracle:thin:@{1}:{2}");
            sqlDatabase = new DBOracleDatabase(connectionPool, driverClass, connectionUrl, hostPort, serviceName, username, password, configuration);
        } else if (c8Setting.equalsIgnoreCase(LITERAL_DB2)) {
            if (databaseName == null) {
                throw new CMException(1146, "DB2 database requires 'user', and 'name' elements in DB config");
            }
            String driverClass = configuration.getString("DB2_DRIVER_CLASS", "com.ibm.db2.jcc.DB2Driver");
            if (hostPort == null || hostPort.length() == 0) {
                StringBuilder connectionUrl = new StringBuilder(configuration.getString("DB2_CONNECTION_URL_TYPE2", "jdbc:db2:{1}:retrieveMessagesFromServerOnGetMessage=true;fullyMaterializeLobData=true;"));
                if (SSLEnabled) {
                    connectionUrl.append("sslConnection=true;");
                }
                sqlDatabase = new DBDB2Database(connectionPool, driverClass, connectionUrl.toString(), databaseName, username, password);
            } else {
                StringBuilder connectionUrl = new StringBuilder(configuration.getString("DB2_CONNECTION_URL_TYPE4", "jdbc:db2://{1}/{2}:retrieveMessagesFromServerOnGetMessage=true;fullyMaterializeLobData=true;"));
                if (SSLEnabled) {
                    connectionUrl.append("sslConnection=true;");
                }
                sqlDatabase = new DBDB2Database(connectionPool, driverClass, connectionUrl.toString(), hostPort, databaseName, username, password, configuration);
            }
        } else if (c8Setting.equalsIgnoreCase(LITERAL_DERBY)) {
            if (hostPort == null || databaseName == null) {
                throw new CMException(1146, "Derby databases requires 'server', 'user' and 'name' elements in DB config");
            }
            sqlDatabase = new DBDerbyNetworkedDatabase(connectionPool, hostPort, databaseName, username, password, configuration);
        } else if (c8Setting.equalsIgnoreCase(LITERAL_MICROSOFT_WIN_AUTH)) {
            if (hostPort == null) {
                throw new CMException(1146, "Microsoft SQL Server databases with Windows authentication requires 'server' element in DB config");
            }
            String driverClass = configuration.getString("JSQL_DRIVER_CLASS", "com.microsoft.sqlserver.jdbc.SQLServerDriver");
            StringBuilder connectionUrl = new StringBuilder(configuration.getString("JSQL_TRUSTED_CONNECTION_URL", "jdbc:sqlserver://{1};databaseName={2};integratedSecurity=true"));
            if (SSLEnabled) {
                connectionUrl.append(configuration.getString("CONNECTION_OPTION_SSL", ";encrypt=true;trustServerCertificate=false"));
            }
            sqlDatabase = new DBSqlServerDatabase(connectionPool, driverClass, connectionUrl.toString(), hostPort, databaseName, null, null, null, configuration);
        } else if (c8Setting.equalsIgnoreCase(LITERAL_INFORMIX)) {
            if (hostPort == null || databaseName == null) {
                throw new CMException(1146, "Informix database requires 'server', 'user', and 'name' elements in DB config");
            }
            String driverClass = configuration.getString("INFORMIX_DRIVER_CLASS", "com.ibm.db2.jcc.DB2Driver");
            StringBuilder connectionUrl = new StringBuilder(configuration.getString("INFORMIX_CONNECTION_URL", "jdbc:ids://{1}/{2}:retrieveMessagesFromServerOnGetMessage=true;fullyMaterializeLobData=true;"));
            if (SSLEnabled) {
                connectionUrl.append("sslConnection=true;");
            }
            sqlDatabase = new DBInformixDatabase(connectionPool, driverClass, connectionUrl.toString(), hostPort, databaseName, username, password, configuration);
        } else {
            throw new CMException(1146, "Invalid database type '" + c8Setting + "'; only SQL Server, Oracle, DB2 and Informix are supported");
        }
        return sqlDatabase;
    }
}

