/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.database;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.database.DefaultPreparedStatementParameterizer;
import com.cognos.mobile.database.IDeviceDAO;
import com.cognos.mobile.database.IResultSetAccumulator;
import com.cognos.mobile.database.ISQLDatabase;
import com.cognos.mobile.database.SQLUserDAO;
import com.cognos.mobile.model.data.Device;
import com.cognos.mobile.vm.VM;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SQLDeviceDAO
implements IDeviceDAO {
    private static final String SQL_INSERT_DEVICE = "INSERT INTO MOB_DEVICES(DEVICE_ID, USER_ID, PUSH_ID, REGISTERED, KEY_BYTES, SYNC_METHOD) VALUES( ?, ?, ?, ?, ?, ? )";
    private static final String SQL_UPDATE_DEVICE = "UPDATE MOB_DEVICES SET SYNC_METHOD=?, PUSH_ID=?, REGISTERED=? WHERE USER_ID=? AND DEVICE_ID=?";
    private static final String SQL_UPDATE_KEY = "UPDATE MOB_DEVICES SET KEY_TYPE=?, KEY_BYTES=? WHERE USER_ID=? AND DEVICE_ID=?";
    private static final String SQL_UPDATE_SYNC_METHOD = "UPDATE MOB_DEVICES SET SYNC_METHOD=? WHERE USER_ID=? AND DEVICE_ID=?";
    private static final String SQL_UPDATE_LAST_SYNCED_TIME = "UPDATE MOB_DEVICES SET LAST_SYNCED=? WHERE USER_ID=? AND DEVICE_ID=?";
    private static final String SQL_GET_LAST_SYNCED_TIME = "SELECT LAST_SYNCED FROM MOB_DEVICES WHERE USER_ID=? AND DEVICE_ID=?";
    private static final String SQL_GET_DEVICE = "SELECT DEVICE_PROFILE, KEY_TYPE, KEY_BYTES, SYNC_METHOD, PUSH_ID, REGISTERED, LAST_SYNCED FROM MOB_DEVICES WHERE USER_ID=? AND DEVICE_ID=?";
    private static final String SQL_GET_DEVICES_BY_CAM = "SELECT d.DEVICE_ID, d.USER_ID, d.DEVICE_PROFILE, d.KEY_TYPE, d.KEY_BYTES, d.SYNC_METHOD, d.PUSH_ID, d.REGISTERED, d.LAST_SYNCED FROM MOB_USERS u INNER JOIN MOB_DEVICES d ON d.USER_ID = u.USER_ID WHERE u.CAM_ID=?";
    private static final String SQL_DELETE_REGISTERED_BEFORE = "DELETE FROM MOB_DEVICES WHERE PUSH_ID=? AND (REGISTERED < ? OR REGISTERED IS NULL)";
    private static final String SQL_UPDATE_PUSHID = "UPDATE MOB_DEVICES SET PUSH_ID=?, REGISTERED=? WHERE USER_ID=? AND DEVICE_ID=?";
    private static final String SQL_DELETE_DEVICES_NOT_SYNCED_SINCE = "DELETE FROM MOB_DEVICES WHERE LAST_SYNCED < ?";
    private static final String SQL_RESET_PUSHID_FOR_DEVICE = "UPDATE MOB_DEVICES SET PUSH_ID=NULL WHERE DEVICE_ID=?";
    private static final Class CLASS = SQLUserDAO.class;
    private final ISQLDatabase database;

    public SQLDeviceDAO(ISQLDatabase database) {
        this.database = database;
    }

    @Override
    public void setKey(final String deviceID, final int userID, final String keyType, final byte[] key) throws CMException {
        try {
            this.database.executeUpdate(SQL_UPDATE_KEY, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setString(i++, keyType);
                    SQLDeviceDAO.this.database.setBlobSpecial(statement, i++, key, 0, key.length, null);
                    statement.setInt(i++, userID);
                    statement.setString(i++, deviceID);
                    return false;
                }
            }, null, null);
        }
        catch (Exception ex) {
            String details = "error updating key";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1121, details, (Throwable)ex);
        }
    }

    @Override
    public Device addDevice(final String deviceID, final int userID, final String pushID, final String syncMethod) throws CMException {
        try {
            final Date now = new Date();
            this.database.executeUpdate(SQL_INSERT_DEVICE, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setString(i++, deviceID);
                    statement.setInt(i++, userID);
                    statement.setString(i++, pushID);
                    statement.setTimestamp(i++, new Timestamp(now.getTime()));
                    SQLDeviceDAO.this.database.setBlobSpecial(statement, i++, new byte[0], 0, 0, null);
                    statement.setString(i++, syncMethod);
                    return false;
                }
            }, null, null);
            return new Device(deviceID, userID, "", "", new byte[0], syncMethod, pushID, now, null);
        }
        catch (Exception ex) {
            String details = "error updating deviceID";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1121, details, (Throwable)ex);
        }
    }

    @Override
    public void updateDevice(final String deviceID, final int userID, final String syncMethod, final String pushID) throws CMException {
        try {
            final Date now = new Date();
            this.database.executeUpdate(SQL_UPDATE_DEVICE, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setString(i++, syncMethod);
                    statement.setString(i++, pushID);
                    statement.setTimestamp(i++, new Timestamp(now.getTime()));
                    statement.setInt(i++, userID);
                    statement.setString(i++, deviceID);
                    return false;
                }
            }, null, null);
        }
        catch (Exception ex) {
            String details = "error updating updateDevice";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1121, details, (Throwable)ex);
        }
    }

    @Override
    public void resetPushIdsForDevice(final String deviceID) throws CMException {
        try {
            this.database.executeUpdate(SQL_RESET_PUSHID_FOR_DEVICE, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setString(i++, deviceID);
                    return false;
                }
            }, null, null);
        }
        catch (Exception ex) {
            String details = "error updating resetPushIdsForDevice";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1121, details, (Throwable)ex);
        }
    }

    @Override
    public void setSyncMethod(final String deviceID, final int userID, final String syncMethod) throws CMException {
        try {
            this.database.executeUpdate(SQL_UPDATE_SYNC_METHOD, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setString(i++, syncMethod);
                    statement.setInt(i++, userID);
                    statement.setString(i++, deviceID);
                    return false;
                }
            }, null, null);
        }
        catch (Exception ex) {
            String details = "error updating syncMethod";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1121, details, (Throwable)ex);
        }
    }

    @Override
    public void setLastSynced(final String deviceID, final int userID, final Date updateTime) throws CMException {
        try {
            this.database.executeUpdate(SQL_UPDATE_LAST_SYNCED_TIME, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setTimestamp(i++, new Timestamp(updateTime.getTime()));
                    statement.setInt(i++, userID);
                    statement.setString(i++, deviceID);
                    return false;
                }
            }, null, null);
        }
        catch (Exception ex) {
            String details = "error updating sycronization time";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1121, details, (Throwable)ex);
        }
    }

    @Override
    public Date getLastSynced(final String deviceID, final int userID) throws CMException {
        final ArrayList l = new ArrayList(1);
        try {
            this.database.executeQuery(SQL_GET_LAST_SYNCED_TIME, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setInt(i++, userID);
                    statement.setString(i++, deviceID);
                    return false;
                }
            }, new IResultSetAccumulator(){

                @Override
                public IResultSetAccumulator.Action accumulate(ResultSet resultSet) throws Exception {
                    l.add(resultSet.getTimestamp(1));
                    return IResultSetAccumulator.STOP;
                }
            });
            if (l.size() == 0) {
                return null;
            }
            return new Date(((Timestamp)l.get(0)).getTime());
        }
        catch (Exception ex) {
            String details = "error loading sync time record";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1120, details, (Throwable)ex);
        }
    }

    @Override
    public Device getDevice(final String deviceID, final int userID) throws CMException {
        final ArrayList l = new ArrayList(1);
        try {
            this.database.executeQuery(SQL_GET_DEVICE, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setInt(i++, userID);
                    statement.setString(i++, deviceID);
                    return false;
                }
            }, new IResultSetAccumulator(){

                @Override
                public IResultSetAccumulator.Action accumulate(ResultSet resultSet) throws Exception {
                    int i = 1;
                    l.add(new Device(deviceID, userID, resultSet.getString(i++), resultSet.getString(i++), SQLDeviceDAO.this.database.getBlobBytes(resultSet, i++), resultSet.getString(i++), resultSet.getString(i++), resultSet.getTimestamp(i++), resultSet.getTimestamp(i++)));
                    return IResultSetAccumulator.STOP;
                }
            });
            if (l.size() == 0) {
                return null;
            }
            return (Device)l.get(0);
        }
        catch (Exception ex) {
            String details = "error loading user record";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1174, details, (Throwable)ex);
        }
    }

    @Override
    public List<Device> getDevicesByCamID(final String camID) throws CMException {
        final ArrayList<Device> l = new ArrayList<Device>();
        try {
            this.database.executeQuery(SQL_GET_DEVICES_BY_CAM, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setString(i++, camID);
                    return false;
                }
            }, new IResultSetAccumulator(){

                @Override
                public IResultSetAccumulator.Action accumulate(ResultSet resultSet) throws Exception {
                    int i = 1;
                    l.add(new Device(resultSet.getString(i++), resultSet.getInt(i++), resultSet.getString(i++), resultSet.getString(i++), SQLDeviceDAO.this.database.getBlobBytes(resultSet, i++), resultSet.getString(i++), resultSet.getString(i++), resultSet.getTimestamp(i++), resultSet.getTimestamp(i++)));
                    return IResultSetAccumulator.CONTINUE;
                }
            });
            return l;
        }
        catch (Exception ex) {
            String details = "error loading user record";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1174, details, (Throwable)ex);
        }
    }

    @Override
    public void removeDeviceRegisteredBefore(final String pushID, final Date date) throws CMException {
        try {
            this.database.executeUpdate(SQL_DELETE_REGISTERED_BEFORE, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setString(i++, pushID);
                    statement.setTimestamp(i++, new Timestamp(date.getTime()));
                    return false;
                }
            }, null, null);
        }
        catch (Exception ex) {
            String details = "error deleting record for pushID before date";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1121, details, (Throwable)ex);
        }
    }

    @Override
    public void setPushID(final String deviceID, final int userID, final String pushID) throws CMException {
        try {
            this.database.executeUpdate(SQL_UPDATE_PUSHID, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setString(i++, pushID);
                    statement.setTimestamp(i++, new Timestamp(new Date().getTime()));
                    statement.setInt(i++, userID);
                    statement.setString(i++, deviceID);
                    return false;
                }
            }, null, null);
        }
        catch (Exception ex) {
            String details = "error updating pushID";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1121, details, (Throwable)ex);
        }
    }

    @Override
    public void deleteExpiredDevices(long expiryAgeInDays) throws CMException {
        long millisecondsPerDay = 86400000L;
        final Long expiryTime = System.currentTimeMillis() - expiryAgeInDays * millisecondsPerDay;
        try {
            this.database.executeUpdate(SQL_DELETE_DEVICES_NOT_SYNCED_SINCE, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setTimestamp(i++, new Timestamp(expiryTime));
                    return false;
                }
            }, null, null);
        }
        catch (Exception ex) {
            String details = "error deleting expired devices";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1121, details, (Throwable)ex);
        }
    }
}

