/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.database;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.database.DefaultPreparedStatementParameterizer;
import com.cognos.mobile.database.DrillRow;
import com.cognos.mobile.database.IDrillDAO;
import com.cognos.mobile.database.IResultSetAccumulator;
import com.cognos.mobile.database.ISQLDatabase;
import com.cognos.mobile.vm.VM;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;

public class SQLDrillDAO
implements IDrillDAO {
    private static final Class CLASS = SQLDrillDAO.class;
    private static final String SQL_INSERT_DRILL = "INSERT INTO MOB_DRILLS (SOURCE_RENDER_ID, TARGET_RENDER_ID, DRILL_CONTEXT, DRILL_TYPE) VALUES (?, ?, ?, ?)";
    private static final String SQL_GET_DRILLS = "SELECT SOURCE_RENDER_ID, TARGET_RENDER_ID, DRILL_CONTEXT, DRILL_TYPE FROM MOB_DRILLS WHERE SOURCE_RENDER_ID=? AND DRILL_TYPE=?";
    private final ISQLDatabase database;

    public SQLDrillDAO(ISQLDatabase database) {
        this.database = database;
    }

    @Override
    public void insertDrill(final int sourceRenderID, final int targetRenderID, final String drillContext, final int drillType) throws CMException {
        try {
            this.database.executeUpdate(SQL_INSERT_DRILL, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setInt(i++, sourceRenderID);
                    statement.setInt(i++, targetRenderID);
                    statement.setString(i++, CMStringHelper.replaceAll(drillContext, "'", "''", true));
                    statement.setInt(i++, drillType);
                    return false;
                }
            }, null, null);
        }
        catch (Exception ex) {
            String details = "error inserting drill";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1123, details, (Throwable)ex);
        }
    }

    @Override
    public DrillRow getDrills(final int sourceRenderID, final int drillType) throws CMException {
        try {
            final ArrayList drills = new ArrayList(1);
            this.database.executeQuery(SQL_GET_DRILLS, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setInt(i++, sourceRenderID);
                    statement.setInt(i++, drillType);
                    return false;
                }
            }, new IResultSetAccumulator(){

                @Override
                public IResultSetAccumulator.Action accumulate(ResultSet rs) throws Exception {
                    DrillRow pi = new DrillRow(rs);
                    drills.add(pi);
                    return IResultSetAccumulator.CONTINUE;
                }
            });
            if (drills.size() == 0) {
                return null;
            }
            return (DrillRow)drills.get(0);
        }
        catch (Exception ex) {
            String details = "error loading drills for render " + sourceRenderID;
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1128, details, (Throwable)ex);
        }
    }
}

