/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.database;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.database.DefaultPreparedStatementParameterizer;
import com.cognos.mobile.database.HistoryObject;
import com.cognos.mobile.database.IHistoryDAO;
import com.cognos.mobile.database.IResultSetAccumulator;
import com.cognos.mobile.database.ISQLDatabase;
import com.cognos.mobile.vm.VM;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;

public class SQLHistoryDAO
implements IHistoryDAO {
    private static final Class CLASS = SQLHistoryDAO.class;
    private static final String TABLE = "MOB_HISTORY";
    private static final String INSERT = "INSERT INTO MOB_HISTORY( EVENT_TIME,EVENT_CODE,ARGUMENTS) VALUES(?, ?, ?)";
    private static final String DELETE_EXPIRED_HISTORY = "DELETE FROM MOB_HISTORY WHERE EVENT_TIME <= ?";
    private static final String GET_HISTORY_BY_USER = "SELECT DISTINCT uh.USER_ID, h.HISTORY_ID, h.EVENT_TIME, h.EVENT_CODE, h.ARGUMENTS, rh.RENDER_ID, pi.LABEL, pi.STORE_ID FROM MOB_RENDERS r INNER JOIN MOB_RENDER_HISTORY rh ON r.RENDER_ID = rh.RENDER_ID INNER JOIN MOB_PORTALITEMS pi ON r.PORTALITEM_ID = pi.PORTALITEM_ID RIGHT OUTER JOIN MOB_USER_HISTORY uh INNER JOIN MOB_HISTORY h ON uh.HISTORY_ID = h.HISTORY_ID ON rh.HISTORY_ID = h.HISTORY_ID WHERE uh.USER_ID = ? AND ";
    private static final String ORDER_BY_HISTORY_ID_DESC = " ORDER BY h.HISTORY_ID DESC";
    private final ISQLDatabase database;

    public SQLHistoryDAO(ISQLDatabase database) {
        this.database = database;
    }

    @Override
    public HistoryObject createHistory(int[] userIDs, final int eventID, final Date timeStamp, final String details, int[] renderIDs) throws CMException {
        try {
            int id = this.database.executeUpdate(INSERT, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setTimestamp(i++, new Timestamp(timeStamp.getTime()));
                    statement.setInt(i++, eventID);
                    statement.setString(i++, details);
                    return false;
                }
            }, TABLE, "HISTORY_ID");
            HistoryObject obj = new HistoryObject(id, eventID, timeStamp, details);
            obj.setRenderIDs(renderIDs);
            obj.setUserIDs(userIDs);
            VM.log(CLASS, 0, "created new history object " + obj);
            return obj;
        }
        catch (Exception ex) {
            String errMsg = "error inserting history object";
            VM.log(CLASS, 0, errMsg, ex);
            throw new CMException(1120, errMsg, (Throwable)ex);
        }
    }

    @Override
    public void removeHistoryBefore(final Date date) throws CMException {
        VM.log(CLASS, 0, "removing all history objects modified before " + date);
        try {
            this.database.executeUpdate(DELETE_EXPIRED_HISTORY, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setTimestamp(i++, new Timestamp(date.getTime()));
                    return false;
                }
            }, null, null);
        }
        catch (Exception ex) {
            String details = "Error removing records";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1121, details, (Throwable)ex);
        }
    }

    @Override
    public HistoryObject[] queryHistoryByUser(final int userID, int[] eventID, int start, final int end) throws CMException {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        for (int i = 0; i < eventID.length; ++i) {
            sb.append(" h.EVENT_CODE = " + eventID[i]);
            if (i == eventID.length - 1) continue;
            sb.append(" OR ");
        }
        sb.append(")");
        String query = GET_HISTORY_BY_USER + sb.toString() + ORDER_BY_HISTORY_ID_DESC;
        final ArrayList histories = new ArrayList();
        try {
            this.database.executeQuery(query, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setInt(i++, userID);
                    return false;
                }
            }, new IResultSetAccumulator(){

                @Override
                public IResultSetAccumulator.Action accumulate(ResultSet rs) throws Exception {
                    int i = 1;
                    int userID = rs.getInt(i++);
                    int historyID = rs.getInt(i++);
                    Timestamp eventTime = rs.getTimestamp(i++);
                    int eventCode = rs.getInt(i++);
                    String arguments = rs.getString(i++);
                    int renderID = rs.getInt(i++);
                    String renderLabel = rs.getString(i++);
                    String storeID = rs.getString(i++);
                    HistoryObject history = new HistoryObject(renderLabel, userID, historyID, eventCode, eventTime, arguments, renderID, storeID);
                    histories.add(history);
                    if (end != -1) {
                        if (histories.size() <= end) {
                            return IResultSetAccumulator.CONTINUE;
                        }
                        return IResultSetAccumulator.STOP;
                    }
                    return IResultSetAccumulator.CONTINUE;
                }
            });
        }
        catch (Exception ex) {
            String details = "Error querying records";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1121, details, (Throwable)ex);
        }
        int actualEnd = end;
        if (actualEnd == -1 || actualEnd > histories.size() - 1) {
            actualEnd = histories.size() - 1;
        }
        if (actualEnd < start) {
            return new HistoryObject[0];
        }
        HistoryObject[] actual = new HistoryObject[actualEnd - start + 1];
        System.arraycopy(histories.toArray(new HistoryObject[0]), start, actual, 0, actual.length);
        return actual;
    }

    @Override
    public HistoryObject[] getMostRecentViewedByUser(final int userID, final int number) throws CMException {
        StringBuffer sb = new StringBuffer();
        sb.append("( h.EVENT_CODE = 7 )");
        String query = GET_HISTORY_BY_USER + sb.toString() + ORDER_BY_HISTORY_ID_DESC;
        final Hashtable histories = new Hashtable();
        final ArrayList results = new ArrayList();
        try {
            this.database.executeQuery(query, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setInt(i++, userID);
                    return false;
                }
            }, new IResultSetAccumulator(){

                @Override
                public IResultSetAccumulator.Action accumulate(ResultSet rs) throws Exception {
                    int i = 1;
                    int userID = rs.getInt(i++);
                    int historyID = rs.getInt(i++);
                    Timestamp eventTime = rs.getTimestamp(i++);
                    int eventCode = rs.getInt(i++);
                    String arguments = rs.getString(i++);
                    int renderID = rs.getInt(i++);
                    String renderLabel = rs.getString(i++);
                    String storeID = rs.getString(i++);
                    HistoryObject history = new HistoryObject(renderLabel, userID, historyID, eventCode, eventTime, arguments, renderID, storeID);
                    if (!histories.containsKey(storeID)) {
                        histories.put(storeID, storeID);
                        results.add(history);
                    }
                    if (results.size() < number) {
                        return IResultSetAccumulator.CONTINUE;
                    }
                    return IResultSetAccumulator.STOP;
                }
            });
        }
        catch (Exception ex) {
            String details = "Error querying records";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1121, details, (Throwable)ex);
        }
        HistoryObject[] hobjs = new HistoryObject[results.size()];
        System.arraycopy(results.toArray(new HistoryObject[0]), 0, hobjs, 0, results.size());
        return hobjs;
    }
}

