/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.database;

import com.cognos.mobile.common.C8;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMStringHelper2;
import com.cognos.mobile.database.DefaultPreparedStatementParameterizer;
import com.cognos.mobile.database.IPortalItemDAO;
import com.cognos.mobile.database.IResultSetAccumulator;
import com.cognos.mobile.database.ISQLDatabase;
import com.cognos.mobile.database.PortalItemRow;
import com.cognos.mobile.vm.VM;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;

public class SQLPortalItemDAO
implements IPortalItemDAO {
    private static final Class CLASS = SQLPortalItemDAO.class;
    private static final int MAX_DESCRIPTION_SIZE = 500;
    private static final String SQL_INSERT_PORTALITEM = "INSERT INTO MOB_PORTALITEMS (LABEL, STORE_ID, CM_PATH, SOURCE_PATH, DESCRIPTION, PORTALITEM_TYPE) VALUES(?, ?, ?, ?, ?, ?)";
    private static final String SQL_DELETE_PORTALITEM = "DELETE FROM MOB_PORTALITEMS WHERE PORTALITEM_ID=?";
    private static final String SQL_GET_PORTALITEM_BY_ID = "SELECT PORTALITEM_ID, LABEL, STORE_ID, CM_PATH, SOURCE_PATH, DESCRIPTION, PORTALITEM_TYPE FROM MOB_PORTALITEMS WHERE (PORTALITEM_ID = ?)";
    private static final String SQL_GET_PORTALITEM_BY_STOREID = "SELECT PORTALITEM_ID, LABEL, STORE_ID, CM_PATH, SOURCE_PATH, DESCRIPTION, PORTALITEM_TYPE FROM MOB_PORTALITEMS WHERE ";
    private static final String SQL_PORTALITEM_LABEL = "SELECT LABEL FROM MOB_PORTALITEMS WHERE (STORE_ID = ?)";
    private static final String SQL_GETUSERPORTALITEMS = "SELECT r.PORTALITEM_ID, r.LABEL, r.STORE_ID, r.CM_PATH, r.SOURCE_PATH, r.DESCRIPTION, r.PORTALITEM_TYPE FROM MOB_PORTALITEMS r, MOB_USER_PORTALITEM ur WHERE (ur.PORTALITEM_ID=r.PORTALITEM_ID) AND (ur.USER_ID=?) AND (ur.USER_PORTALITEM_TYPE=?) ";
    private static final String SQL_GETUSERPORTALITEMS_ORDER_CLAUSE = "ORDER BY r.PORTALITEM_ID DESC";
    private final ISQLDatabase database;

    public SQLPortalItemDAO(ISQLDatabase database) {
        this.database = database;
    }

    @Override
    public PortalItemRow addFavourite(int userId, C8.PortalItem item) throws CMException {
        if (item.itemType != 51 && item.itemType != 57 && item.itemType != 56) {
            throw new IllegalArgumentException("The item to be set as a favourite must be a report.");
        }
        int portalItemID = this.insertPortalItem(item.defaultName, item.storeID, item.cmPath, item.sourcePath, item.defaultDescription, item.itemType);
        PortalItemRow portalItem = new PortalItemRow(portalItemID, item.defaultName, item.storeID, item.cmPath, item.sourcePath, item.defaultDescription, item.itemType);
        return portalItem;
    }

    @Override
    public void deleteFavourites(int userId) throws CMException {
        PortalItemRow[] pi = this.listFavourites(userId);
        for (int i = 0; i < pi.length; ++i) {
            this.deleteFavourite(userId, pi[i]);
        }
    }

    @Override
    public void deleteFavourite(int userId, PortalItemRow pi) throws CMException {
        this.deletePortalItem(pi.getPortalItemID());
    }

    @Override
    public void deletePortalItem(final int id) throws CMException {
        try {
            this.database.executeCommittedUpdate(SQL_DELETE_PORTALITEM, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setInt(i++, id);
                    return false;
                }
            }, null, null);
        }
        catch (Exception ex) {
            String details = "Error deleting";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1121, details, (Throwable)ex);
        }
    }

    @Override
    public PortalItemRow[] listFavourites(final int userId) throws CMException {
        final ArrayList favs = new ArrayList();
        this.database.executeQuery("SELECT r.PORTALITEM_ID, r.LABEL, r.STORE_ID, r.CM_PATH, r.SOURCE_PATH, r.DESCRIPTION, r.PORTALITEM_TYPE FROM MOB_PORTALITEMS r, MOB_USER_PORTALITEM ur WHERE (ur.PORTALITEM_ID=r.PORTALITEM_ID) AND (ur.USER_ID=?) AND (ur.USER_PORTALITEM_TYPE=?) ORDER BY r.PORTALITEM_ID DESC", new DefaultPreparedStatementParameterizer(){

            @Override
            public boolean parameterize(PreparedStatement statement) throws Exception {
                int i = 1;
                statement.setInt(i++, userId);
                statement.setInt(i++, 1);
                return false;
            }
        }, new IResultSetAccumulator(){

            @Override
            public IResultSetAccumulator.Action accumulate(ResultSet rs) throws Exception {
                PortalItemRow pi = new PortalItemRow(rs);
                favs.add(pi);
                return IResultSetAccumulator.CONTINUE;
            }
        });
        return favs.toArray(new PortalItemRow[favs.size()]);
    }

    @Override
    public int insertPortalItem(final String label, final String storeID, final String cmPath, final String sourcePath, final String description, final int portalItemType) throws CMException {
        try {
            int id = this.database.executeUpdate(SQL_INSERT_PORTALITEM, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    String desc = description != null ? CMStringHelper2.utf8Truncate(description, 500) : "";
                    statement.setString(i++, label);
                    statement.setString(i++, storeID);
                    statement.setString(i++, cmPath);
                    statement.setString(i++, sourcePath);
                    statement.setString(i++, desc);
                    statement.setInt(i++, portalItemType);
                    return false;
                }
            }, "MOB_PORTALITEMS", "PORTALITEM_ID");
            return id;
        }
        catch (Exception ex) {
            String details = "error inserting portal item";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1123, details, (Throwable)ex);
        }
    }

    @Override
    public PortalItemRow getPortalItem(final int portalItemID) throws CMException {
        try {
            final ArrayList portalItems = new ArrayList(1);
            this.database.executeQuery(SQL_GET_PORTALITEM_BY_ID, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setInt(i++, portalItemID);
                    return false;
                }
            }, new IResultSetAccumulator(){

                @Override
                public IResultSetAccumulator.Action accumulate(ResultSet rs) throws Exception {
                    PortalItemRow pi = new PortalItemRow(rs);
                    portalItems.add(pi);
                    return IResultSetAccumulator.STOP;
                }
            });
            if (portalItems.size() == 0) {
                return null;
            }
            return (PortalItemRow)portalItems.get(0);
        }
        catch (Exception ex) {
            String details = "error loading portal item";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1128, details, (Throwable)ex);
        }
    }

    @Override
    public PortalItemRow getPortalItem(String storeID, String cmPath, String sourcePath) throws CMException {
        try {
            String whereValue;
            String whereClause;
            final ArrayList portalItems = new ArrayList(1);
            if (storeID != null && !storeID.equals("")) {
                whereClause = "STORE_ID = ?";
                whereValue = storeID;
            } else if (cmPath != null && !cmPath.equals("")) {
                whereClause = "CM_PATH = ?";
                whereValue = cmPath;
            } else if (sourcePath != null && !sourcePath.equals("")) {
                whereClause = "SOURCE_PATH = ?";
                whereValue = sourcePath;
            } else {
                return null;
            }
            this.database.executeQuery(SQL_GET_PORTALITEM_BY_STOREID + whereClause, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setString(i++, whereValue);
                    return false;
                }
            }, new IResultSetAccumulator(){

                @Override
                public IResultSetAccumulator.Action accumulate(ResultSet rs) throws Exception {
                    PortalItemRow pi = new PortalItemRow(rs);
                    portalItems.add(pi);
                    return IResultSetAccumulator.STOP;
                }
            });
            if (portalItems.size() == 0) {
                return null;
            }
            return (PortalItemRow)portalItems.get(0);
        }
        catch (Exception ex) {
            String details = "error loading portal item";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1128, details, (Throwable)ex);
        }
    }

    @Override
    public String getPortalItemLabel(final String storeID) throws CMException {
        try {
            final String[] label = new String[]{""};
            this.database.executeQuery(SQL_PORTALITEM_LABEL, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setString(i++, storeID);
                    return false;
                }
            }, new IResultSetAccumulator(){

                @Override
                public IResultSetAccumulator.Action accumulate(ResultSet rs) throws Exception {
                    label[0] = rs.getString(1);
                    return IResultSetAccumulator.STOP;
                }
            });
            return label[0];
        }
        catch (Exception ex) {
            String details = "Error querying for portal item label";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1128, details, (Throwable)ex);
        }
    }

    @Override
    public void insertUserPortalItem(int userID, int portalItemID, int portalItemType) throws CMException {
    }

    public void removeUserPortalItem(int userID, int portalItemID, int portalItemType) throws CMException {
    }

    public void updateUserPortalItem(int userID, int portalItemID, int portalItemType) throws CMException {
    }
}

