/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.database;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.database.DefaultPreparedStatementParameterizer;
import com.cognos.mobile.database.IRenderDAO;
import com.cognos.mobile.database.IRenderRow;
import com.cognos.mobile.database.IResultSetAccumulator;
import com.cognos.mobile.database.ISQLDatabase;
import com.cognos.mobile.database.IUserRenderDAO;
import com.cognos.mobile.database.RenderRow;
import com.cognos.mobile.database.RenderState;
import com.cognos.mobile.database.RenderStatus;
import com.cognos.mobile.database.SQLUserRenderDAO;
import com.cognos.mobile.model.data.SavedOutputType;
import com.cognos.mobile.server.tabs.TabInfoHelper;
import com.cognos.mobile.vm.VM;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SQLRenderDAO
implements IRenderDAO {
    private static final Class CLASS = SQLRenderDAO.class;
    private static final String SQL_REPORT_RENDERS = "SELECT r.RENDER_ID, ur.USER_ID, pi.LABEL, pi.STORE_ID, pi.CM_PATH, pi.SOURCE_PATH, pi.DESCRIPTION, r.RENDER_TIME, r.RENDER_SIZE, r.STATUS_CODE, r.DRILL_PARAMS, r.PORTALITEM_ID, r.SOURCE_CODE, r.BASE_DOC, r.SMALL_THUMB, r.MEDIUM_THUMB, r.LARGE_THUMB, ur.LAST_VIEWED, pi.PORTALITEM_TYPE, ur.NAME, r.SAVED_OUTPUT_TYPE, r.CREATION_TIME, r.BURST_VALUE, r.EXECUTION_ID, r.OUTPUT_TYPE_MASK, r.HAS_MORE_PAGES, r.PASSPORT, r.TABS FROM MOB_USER_RENDER ur INNER JOIN MOB_RENDERS r ON ur.RENDER_ID = r.RENDER_ID INNER JOIN MOB_PORTALITEMS pi ON r.PORTALITEM_ID = pi.PORTALITEM_ID WHERE (ur.USER_ID = ?) AND ((r.STATUS_CODE = " + RenderState.AVAILABLE.getCode() + ") OR (r.STATUS_CODE = " + RenderState.COMPLETE.getCode() + ") OR (r.STATUS_CODE = " + RenderState.ERROR.getCode() + ")) ";
    private static final String SQL_REPORT_RENDERS_STOREID_CLAUSE = "AND (pi.STORE_ID = ?) ";
    private static final String SQL_REPORT_RENDERS_ORDER_CLAUSE = "ORDER BY r.RENDER_TIME DESC";
    private static final String SQL_LOAD_RENDER = "SELECT MOB_RENDERS.RENDER_ID, MOB_PORTALITEMS.LABEL, MOB_PORTALITEMS.STORE_ID, MOB_PORTALITEMS.CM_PATH, MOB_PORTALITEMS.SOURCE_PATH, MOB_PORTALITEMS.DESCRIPTION, MOB_RENDERS.RENDER_TIME, MOB_RENDERS.RENDER_SIZE, MOB_RENDERS.SOURCE_CODE, MOB_RENDERS.DRILL_PARAMS, MOB_RENDERS.STATUS_CODE, MOB_RENDERS.PORTALITEM_ID, MOB_RENDERS.BASE_DOC, MOB_RENDERS.SMALL_THUMB, MOB_RENDERS.MEDIUM_THUMB, MOB_RENDERS.LARGE_THUMB, MOB_RENDERS.SAVED_OUTPUT_TYPE, MOB_RENDERS.CREATION_TIME, MOB_RENDERS.BURST_VALUE, MOB_RENDERS.HAS_MORE_PAGES, MOB_RENDERS.PASSPORT, MOB_PORTALITEMS.PORTALITEM_TYPE, MOB_RENDERS.OUTPUT_TYPE_MASK, MOB_RENDERS.TABS FROM MOB_RENDERS INNER JOIN MOB_PORTALITEMS ON MOB_RENDERS.PORTALITEM_ID = MOB_PORTALITEMS.PORTALITEM_ID WHERE (MOB_RENDERS.RENDER_ID = ?)";
    private static final String SQL_GET_EXPIRED_RENDERS = "SELECT MOB_RENDERS.RENDER_ID FROM MOB_RENDERS LEFT JOIN MOB_RENDERS_BY_GROUP ON MOB_RENDERS.RENDER_ID = MOB_RENDERS_BY_GROUP.RENDER_ID WHERE (MOB_RENDERS_BY_GROUP.RENDER_ID IS NULL) AND (MOB_RENDERS.RENDER_TIME <= ?) AND (MOB_RENDERS.SOURCE_CODE <> 6)";
    private static final String SQL_DELETE_RENDER_BY_ID = "DELETE FROM MOB_RENDERS WHERE RENDER_ID=?";
    private static final String SQL_SELECT_ASSOCIATED_DRILL_RENDERS = "SELECT RENDER_ID FROM MOB_RENDERS WHERE RENDER_ID IN ( SELECT TARGET_RENDER_ID FROM MOB_DRILLS WHERE DRILL_TYPE = 0 AND SOURCE_RENDER_ID = ? )";
    private static final String SQL_DELETE_ASSOCIATED_DRILL_RENDERS = "DELETE FROM MOB_RENDERS WHERE RENDER_ID IN ( SELECT TARGET_RENDER_ID FROM MOB_DRILLS WHERE DRILL_TYPE = 0 AND SOURCE_RENDER_ID = ? )";
    private static final String SQL_GET_PREVIOUS_RENDERS = "SELECT MOB_RENDERS.RENDER_ID, MOB_RENDERS.OUTPUT_TYPE_MASK FROM MOB_RENDERS INNER JOIN      MOB_PORTALITEMS ON MOB_RENDERS.PORTALITEM_ID = MOB_PORTALITEMS.PORTALITEM_ID INNER JOIN      MOB_USER_RENDER ON MOB_RENDERS.RENDER_ID = MOB_USER_RENDER.RENDER_ID WHERE     (MOB_PORTALITEMS.CM_PATH = ?) AND (MOB_USER_RENDER.USER_ID = ?) AND (MOB_RENDERS.SAVED_OUTPUT_TYPE = ?) AND (MOB_RENDERS.STATUS_CODE <> " + RenderState.DELETED.getCode() + ")";
    private static final String SQL_RENDER_IS_IN_USERS_INBOX = "SELECT 1 FROM MOB_RENDERS INNER JOIN MOB_USER_RENDER ON MOB_RENDERS.RENDER_ID = MOB_USER_RENDER.RENDER_ID WHERE (MOB_USER_RENDER.USER_ID = ?) AND (MOB_RENDERS.RENDER_ID = ?)";
    public static final String SQL_INSERT_RENDER = "INSERT INTO MOB_RENDERS (RENDER_TIME, RENDER_SIZE, STATUS_CODE, SOURCE_CODE, DRILL_PARAMS, PORTALITEM_ID, BASE_DOC, SMALL_THUMB, MEDIUM_THUMB, LARGE_THUMB, SAVED_OUTPUT_TYPE, CREATION_TIME, BURST_VALUE, EXECUTION_ID, OUTPUT_TYPE_MASK, PASSPORT) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String SQL_DRILLTARGET_RENDERS = "SELECT r.RENDER_ID, ur.USER_ID, pi.LABEL, pi.STORE_ID, pi.CM_PATH, pi.SOURCE_PATH, pi.DESCRIPTION, r.RENDER_TIME, r.RENDER_SIZE, r.STATUS_CODE, r.DRILL_PARAMS, r.PORTALITEM_ID, r.SOURCE_CODE, r.BASE_DOC, r.SMALL_THUMB, r.MEDIUM_THUMB, r.LARGE_THUMB, ur.LAST_VIEWED, pi.PORTALITEM_TYPE, ur.NAME, r.SAVED_OUTPUT_TYPE, r.CREATION_TIME, r.BURST_VALUE, r.EXECUTION_ID, r.OUTPUT_TYPE_MASK, r.HAS_MORE_PAGES, r.PASSPORT, r.TABS FROM MOB_USER_RENDER ur INNER JOIN MOB_RENDERS r ON ur.RENDER_ID = r.RENDER_ID INNER JOIN MOB_PORTALITEMS pi ON r.PORTALITEM_ID = pi.PORTALITEM_ID WHERE (ur.USER_ID = ?) AND (pi.STORE_ID = ?) AND (r.DRILL_PARAMS = ?)AND ((r.STATUS_CODE = " + RenderState.COMPLETE.getCode() + ") ) ";
    private static final String SQL_REPORT_RENDERS_CLAUSE = " AND (ur.NAME IS NULL) ";
    private static final String SQL_REPORT_SAVED_RENDERS_CLAUSE = " AND (ur.NAME IS NOT NULL) ";
    private static final String SQL_BROWSE_DASHBOARDS = "SELECT r.RENDER_ID, urs.USER_ID, pi.LABEL, pi.STORE_ID, pi.CM_PATH, pi.SOURCE_PATH, pi.DESCRIPTION, r.RENDER_TIME, r.RENDER_SIZE, r.STATUS_CODE, r.DRILL_PARAMS, r.PORTALITEM_ID, r.SOURCE_CODE, r.BASE_DOC, r.SMALL_THUMB, r.MEDIUM_THUMB, r.LARGE_THUMB, ur.LAST_VIEWED, pi.PORTALITEM_TYPE, ur.NAME, r.SAVED_OUTPUT_TYPE,  r.CREATION_TIME, r.BURST_VALUE, r.EXECUTION_ID, r.OUTPUT_TYPE_MASK, r.HAS_MORE_PAGES, r.PASSPORT, r.TABS FROM MOB_USER_PORTALITEM urs INNER JOIN MOB_PORTALITEMS pi ON urs.PORTALITEM_ID = pi.PORTALITEM_ID INNER JOIN MOB_RENDERS r ON r.PORTALITEM_ID = pi.PORTALITEM_ID LEFT JOIN MOB_USER_RENDER ur ON ur.RENDER_ID = r.RENDER_ID WHERE (urs.USER_ID = ?) AND ((r.STATUS_CODE = " + RenderState.COMPLETE.getCode() + ") OR (r.STATUS_CODE = " + RenderState.ERROR.getCode() + ")) " + "AND (urs.USER_PORTALITEM_TYPE = 0) AND (r.SOURCE_CODE <> " + 4 + ") ";
    private static final String SQL_RENDER_SIZE = "SELECT RENDER_SIZE FROM MOB_RENDERS WHERE RENDER_ID=?";
    private static final String SQL_RENDERS_BY_SOURCE = "SELECT MOB_RENDERS.RENDER_ID, MOB_PORTALITEMS.LABEL FROM  MOB_RENDERS INNER JOIN MOB_PORTALITEMS ON MOB_RENDERS.PORTALITEM_ID = MOB_PORTALITEMS.PORTALITEM_ID WHERE (MOB_RENDERS.SOURCE_CODE = ?) AND (MOB_RENDERS.STATUS_CODE = " + RenderState.COMPLETE.getCode() + ")";
    private final ISQLDatabase database;
    private IUserRenderDAO userRenderDAO;

    public SQLRenderDAO(ISQLDatabase database) {
        this.database = database;
        this.userRenderDAO = new SQLUserRenderDAO(database);
    }

    @Override
    public IRenderRow[] browseRenders(final int userID, boolean latestVersionsOnly, final List<Integer> supportedOutputFormats) throws CMException {
        final ArrayList renders = new ArrayList();
        this.database.executeQuery(SQL_REPORT_RENDERS + SQL_REPORT_RENDERS_ORDER_CLAUSE, new DefaultPreparedStatementParameterizer(){

            @Override
            public boolean parameterize(PreparedStatement statement) throws Exception {
                int i = 1;
                statement.setInt(i++, userID);
                return false;
            }
        }, new IResultSetAccumulator(){

            @Override
            public IResultSetAccumulator.Action accumulate(ResultSet rs) throws Exception {
                RenderRow render = new RenderRow(rs);
                boolean canAdd = false;
                if (supportedOutputFormats != null) {
                    for (Integer format : supportedOutputFormats) {
                        if ((render.getIntField(RenderRow.RenderField.OUTPUT_TYPE_MASK) & format) != format) continue;
                        canAdd = true;
                        break;
                    }
                } else {
                    canAdd = true;
                }
                if (canAdd) {
                    renders.add(render);
                }
                return IResultSetAccumulator.CONTINUE;
            }
        });
        try {
            return renders.toArray(new IRenderRow[0]);
        }
        catch (Exception ex) {
            String details = "error listing renders";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1128, details, (Throwable)ex);
        }
    }

    @Override
    public IRenderRow getDashboard(final int userID) throws CMException {
        final ArrayList renders = new ArrayList(1);
        this.database.executeQuery(SQL_BROWSE_DASHBOARDS + SQL_REPORT_RENDERS_ORDER_CLAUSE, new DefaultPreparedStatementParameterizer(){

            @Override
            public boolean parameterize(PreparedStatement statement) throws Exception {
                int i = 1;
                statement.setInt(i++, userID);
                return false;
            }
        }, new IResultSetAccumulator(){

            @Override
            public IResultSetAccumulator.Action accumulate(ResultSet rs) throws Exception {
                RenderRow render = new RenderRow(rs);
                renders.add(render);
                return IResultSetAccumulator.STOP;
            }
        });
        try {
            if (renders.size() != 0) {
                return (IRenderRow)renders.get(0);
            }
            return null;
        }
        catch (Exception ex) {
            String details = "error listing renders";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1128, details, (Throwable)ex);
        }
    }

    @Override
    public Integer[] getExpiredRenders(int maxAgeDays) throws CMException {
        final ArrayList renders = new ArrayList();
        if (maxAgeDays < 0) {
            return renders.toArray(new Integer[0]);
        }
        final long ageMilis = (long)maxAgeDays * 24L * 3600L * 1000L;
        this.database.executeQuery(SQL_GET_EXPIRED_RENDERS, new DefaultPreparedStatementParameterizer(){

            @Override
            public boolean parameterize(PreparedStatement statement) throws Exception {
                int i = 1;
                statement.setTimestamp(i++, new Timestamp(System.currentTimeMillis() - ageMilis));
                return false;
            }
        }, new IResultSetAccumulator(){

            @Override
            public IResultSetAccumulator.Action accumulate(ResultSet rs) throws Exception {
                Integer renderID = new Integer(rs.getInt(1));
                renders.add(renderID);
                return IResultSetAccumulator.CONTINUE;
            }
        });
        try {
            return renders.toArray(new Integer[0]);
        }
        catch (Exception ex) {
            String details = "error listing renders";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1128, details, (Throwable)ex);
        }
    }

    @Override
    public void deleteRender(final int renderId, int userID) throws CMException {
        try {
            DefaultPreparedStatementParameterizer associatedDrllRenderersParameters = new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setInt(i++, renderId);
                    return false;
                }
            };
            if (VM.wouldLog(CLASS, 0)) {
                final StringBuilder renderIds = new StringBuilder();
                IResultSetAccumulator accumulator = new IResultSetAccumulator(){

                    @Override
                    public IResultSetAccumulator.Action accumulate(ResultSet resultSet) throws Exception {
                        renderIds.append(resultSet.getInt(1));
                        return IResultSetAccumulator.CONTINUE;
                    }
                };
                this.database.executeQuery(SQL_SELECT_ASSOCIATED_DRILL_RENDERS, associatedDrllRenderersParameters, accumulator);
                VM.log(CLASS, 0, "Will delete associated renders: " + renderIds.toString());
            }
            this.database.executeCommittedUpdate(SQL_DELETE_ASSOCIATED_DRILL_RENDERS, associatedDrllRenderersParameters, null, null);
            this.database.executeCommittedUpdate(SQL_DELETE_RENDER_BY_ID, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setInt(i++, renderId);
                    return false;
                }
            }, null, null);
        }
        catch (Exception ex) {
            String details = "Error deleting render";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1121, details, (Throwable)ex);
        }
    }

    @Override
    public List<IRenderRow> getPreviousRenders(final String cmPath, final int userId, final int sourceCode, final String drillParams, final String burstValue, final SavedOutputType savedOutputType, List<Integer> withOutputFormats) throws CMException {
        final ArrayList<IRenderRow> previousRenders = new ArrayList<IRenderRow>();
        String query = SQL_GET_PREVIOUS_RENDERS;
        if (sourceCode != -1) {
            query = query + "AND (MOB_RENDERS.SOURCE_CODE = ?)";
        }
        query = drillParams == null ? query + " AND (MOB_RENDERS.DRILL_PARAMS IS NULL)" : query + " AND (MOB_RENDERS.DRILL_PARAMS = ?)";
        query = burstValue == null ? query + " AND (MOB_RENDERS.BURST_VALUE IS NULL)" : query + " AND (MOB_RENDERS.BURST_VALUE = ?)";
        this.database.executeQuery(query, new DefaultPreparedStatementParameterizer(){

            @Override
            public boolean parameterize(PreparedStatement statement) throws Exception {
                int i = 1;
                statement.setString(i++, cmPath);
                statement.setInt(i++, userId);
                statement.setInt(i++, savedOutputType.getType());
                if (sourceCode != -1) {
                    statement.setInt(i++, sourceCode);
                }
                if (drillParams != null) {
                    statement.setString(i++, drillParams);
                }
                if (burstValue != null) {
                    statement.setString(i++, burstValue);
                }
                return false;
            }
        }, new IResultSetAccumulator(){

            @Override
            public IResultSetAccumulator.Action accumulate(ResultSet rs) throws Exception {
                Integer renderID = new Integer(rs.getInt(1));
                int outputTypeMask = rs.getInt(2);
                previousRenders.add(new RenderRow().setField(RenderRow.RenderField.RENDERID, renderID).setField(RenderRow.RenderField.OUTPUT_TYPE_MASK, outputTypeMask));
                return IResultSetAccumulator.CONTINUE;
            }
        });
        try {
            return previousRenders;
        }
        catch (Exception ex) {
            String details = "error listing renders";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1128, details, (Throwable)ex);
        }
    }

    @Override
    public IRenderRow insertRender(final IRenderRow row) throws CMException {
        try {
            final Date now = new Date();
            int id = this.database.executeCommittedUpdate(SQL_INSERT_RENDER, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    Timestamp nowTimeStamp = new Timestamp(now.getTime());
                    statement.setTimestamp(i++, nowTimeStamp);
                    statement.setInt(i++, row.getIntField(RenderRow.RenderField.RENDERSIZE));
                    statement.setInt(i++, RenderState.PENDING.getCode());
                    statement.setInt(i++, row.getIntField(RenderRow.RenderField.SOURCECODE));
                    statement.setString(i++, row.getStringField(RenderRow.RenderField.DRILLPARAMS));
                    statement.setInt(i++, row.getIntField(RenderRow.RenderField.PORTALITEM_ID));
                    statement.setString(i++, row.getStringField(RenderRow.RenderField.BASEDOC));
                    statement.setString(i++, row.getStringField(RenderRow.RenderField.SMALL_THUMB));
                    statement.setString(i++, row.getStringField(RenderRow.RenderField.MEDIUM_THUMB));
                    statement.setString(i++, row.getStringField(RenderRow.RenderField.LARGE_THUMB));
                    statement.setInt(i++, row.getSavedOutputType());
                    if (row.getCreationTime() != null) {
                        statement.setTimestamp(i++, new Timestamp(row.getCreationTime().getTime()));
                    } else {
                        statement.setTimestamp(i++, nowTimeStamp);
                    }
                    statement.setString(i++, row.getStringField(RenderRow.RenderField.BURST_VALUE));
                    statement.setString(i++, row.getStringField(RenderRow.RenderField.EXECUTION_ID));
                    statement.setInt(i++, row.getIntField(RenderRow.RenderField.OUTPUT_TYPE_MASK));
                    statement.setString(i++, row.getStringField(RenderRow.RenderField.PASSPORT));
                    return false;
                }
            }, "MOB_RENDERS", "RENDER_ID");
            row.setRenderTime(now);
            row.setField(RenderRow.RenderField.STATUS, RenderState.PENDING.getCode());
            row.setField(RenderRow.RenderField.RENDERID, id);
            return row;
        }
        catch (Exception ex) {
            String details = "error inserting render";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1123, details, (Throwable)ex);
        }
    }

    @Override
    public IRenderRow insertRender(int outputTypeMask, int ownerID, int sourceCode, String drillParams, String burstValue, int portalItemID, String baseDoc, String smallThumb, String mediumThumb, String largeThumb, SavedOutputType savedOutputType, Date creationTime, String execId) throws CMException {
        IRenderRow row = new RenderRow().setField(RenderRow.RenderField.OWNER_ID, ownerID).setField(RenderRow.RenderField.RENDERSIZE, 0).setField(RenderRow.RenderField.SOURCECODE, sourceCode).setField(RenderRow.RenderField.DRILLPARAMS, drillParams).setField(RenderRow.RenderField.PORTALITEM_ID, portalItemID).setField(RenderRow.RenderField.BASEDOC, baseDoc).setField(RenderRow.RenderField.SMALL_THUMB, smallThumb).setField(RenderRow.RenderField.MEDIUM_THUMB, mediumThumb).setField(RenderRow.RenderField.LARGE_THUMB, largeThumb).setCreationTime(creationTime).setField(RenderRow.RenderField.BURST_VALUE, burstValue).setField(RenderRow.RenderField.EXECUTION_ID, execId).setField(RenderRow.RenderField.OUTPUT_TYPE_MASK, outputTypeMask);
        if (savedOutputType != null) {
            row.setSavedOutputType(savedOutputType.getType());
        }
        return this.insertRender(row);
    }

    @Override
    public IRenderRow loadRender(final int renderID) throws CMException {
        try {
            final ArrayList renders = new ArrayList(1);
            this.database.executeQuery(SQL_LOAD_RENDER, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setInt(i++, renderID);
                    return false;
                }
            }, new IResultSetAccumulator(){

                @Override
                public IResultSetAccumulator.Action accumulate(ResultSet rs) throws Exception {
                    int i = 1;
                    RenderRow render = new RenderRow(rs.getInt(i++), -1, rs.getString(i++), rs.getString(i++), rs.getString(i++), rs.getString(i++), rs.getString(i++), rs.getTimestamp(i++), rs.getInt(i++), rs.getInt(i++), rs.getString(i++), rs.getInt(i++), rs.getInt(i++), rs.getString(i++), rs.getString(i++), rs.getString(i++), rs.getString(i++), rs.getInt(i++), rs.getTimestamp(i++), rs.getString(i++), rs.getInt(i++), rs.getString(i++), rs.getInt(i++), rs.getInt(i++), rs.getString(i++));
                    renders.add(render);
                    return IResultSetAccumulator.STOP;
                }
            });
            if (renders.size() == 0) {
                return null;
            }
            return (IRenderRow)renders.get(0);
        }
        catch (Exception ex) {
            String details = "error loading render";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1128, details, (Throwable)ex);
        }
    }

    private boolean addCondition(boolean previous, StringBuilder builder, List<Object> params, String condition, Object value) {
        if (previous) {
            builder.append(", ");
        }
        builder.append(condition);
        params.add(value);
        return true;
    }

    @Override
    public void updateRenderRow(final IRenderRow render) throws CMException {
        final ArrayList<Object> params = new ArrayList<Object>();
        StringBuilder builder = new StringBuilder();
        builder.append("UPDATE MOB_RENDERS SET ");
        boolean previous = false;
        if (render.isSet(RenderRow.RenderField.BASEDOC)) {
            previous = this.addCondition(previous, builder, params, "BASE_DOC = ? ", render.getStringField(RenderRow.RenderField.BASEDOC));
        }
        if (render.isSet(RenderRow.RenderField.BURST_VALUE)) {
            previous = this.addCondition(previous, builder, params, "BURST_VALUE = ? ", render.getStringField(RenderRow.RenderField.BURST_VALUE));
        }
        if (render.getCreationTime() != null) {
            previous = this.addCondition(previous, builder, params, "CREATION_TIME = ? ", new Timestamp(render.getCreationTime().getTime()));
        }
        if (render.isSet(RenderRow.RenderField.DRILLPARAMS)) {
            previous = this.addCondition(previous, builder, params, "DRILL_PARAMS = ? ", render.getStringField(RenderRow.RenderField.DRILLPARAMS));
        }
        if (render.isSet(RenderRow.RenderField.EXECUTION_ID)) {
            previous = this.addCondition(previous, builder, params, "EXECUTION_ID = ? ", render.getStringField(RenderRow.RenderField.EXECUTION_ID));
        }
        if (render.isSet(RenderRow.RenderField.STATUS)) {
            previous = this.addCondition(previous, builder, params, "STATUS_CODE = ? ", render.getIntField(RenderRow.RenderField.STATUS));
        }
        if (render.isSet(RenderRow.RenderField.LARGE_THUMB)) {
            previous = this.addCondition(previous, builder, params, "LARGE_THUMB = ? ", render.getStringField(RenderRow.RenderField.LARGE_THUMB));
        }
        if (render.isSet(RenderRow.RenderField.MEDIUM_THUMB)) {
            previous = this.addCondition(previous, builder, params, "MEDIUM_THUMB = ? ", render.getStringField(RenderRow.RenderField.MEDIUM_THUMB));
        }
        if (render.isSet(RenderRow.RenderField.SMALL_THUMB)) {
            previous = this.addCondition(previous, builder, params, "SMALL_THUMB = ? ", render.getStringField(RenderRow.RenderField.SMALL_THUMB));
        }
        if (render.isSet(RenderRow.RenderField.OUTPUT_TYPE_MASK)) {
            previous = this.addCondition(previous, builder, params, "OUTPUT_TYPE_MASK = ? ", render.getIntField(RenderRow.RenderField.OUTPUT_TYPE_MASK));
        }
        if (render.isSet(RenderRow.RenderField.HAS_MORE_PAGES)) {
            previous = this.addCondition(previous, builder, params, "HAS_MORE_PAGES = ? ", render.getBooleanField(RenderRow.RenderField.HAS_MORE_PAGES) ? 1 : 0);
        }
        if (render.isSet(RenderRow.RenderField.PASSPORT)) {
            previous = this.addCondition(previous, builder, params, "PASSPORT = ? ", render.getStringField(RenderRow.RenderField.PASSPORT));
        }
        if (render.isSet(RenderRow.RenderField.PORTALITEM_ID)) {
            previous = this.addCondition(previous, builder, params, "PORTALITEM_ID = ? ", render.getIntField(RenderRow.RenderField.PORTALITEM_ID));
        }
        if (render.isSet(RenderRow.RenderField.RENDERSIZE)) {
            previous = this.addCondition(previous, builder, params, "RENDER_SIZE = ? ", render.getIntField(RenderRow.RenderField.RENDERSIZE));
        }
        if (render.isSet(RenderRow.RenderField.SOURCECODE)) {
            previous = this.addCondition(previous, builder, params, "SOURCE_CODE = ? ", render.getIntField(RenderRow.RenderField.SOURCECODE));
        }
        if (render.getSavedOutputType() != -1) {
            previous = this.addCondition(previous, builder, params, "SAVED_OUTPUT_TYPE = ? ", render.getSavedOutputType());
        }
        if (render.isSet(RenderRow.RenderField.TAB_INFO)) {
            try {
                String tabJson = TabInfoHelper.getTabInfoAsJson(render.getTabInfoList());
                previous = this.addCondition(previous, builder, params, "TABS = ? ", tabJson);
            }
            catch (Exception ex) {
                throw new RuntimeException("problem generating tab info json - " + ex.getMessage());
            }
        }
        builder.append("WHERE RENDER_ID=?");
        try {
            this.database.executeUpdate(builder.toString(), new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    for (Object param : params) {
                        if (param instanceof String) {
                            statement.setString(i++, (String)param);
                            continue;
                        }
                        if (param instanceof Integer) {
                            statement.setInt(i++, (Integer)param);
                            continue;
                        }
                        if (param instanceof Timestamp) {
                            statement.setTimestamp(i++, (Timestamp)param);
                            continue;
                        }
                        throw new RuntimeException("Unsupported parameter type: " + param.getClass());
                    }
                    statement.setInt(i++, render.getIntField(RenderRow.RenderField.RENDERID));
                    return false;
                }
            }, null, null);
        }
        catch (Exception ex) {
            String details = "error updating render - SQL:" + builder.toString();
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1121, details, (Throwable)ex);
        }
    }

    @Override
    public boolean renderIsInUsersInbox(final int renderID, final int userID) throws CMException {
        try {
            final boolean[] found = new boolean[]{false};
            this.database.executeQuery(SQL_RENDER_IS_IN_USERS_INBOX, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setInt(i++, userID);
                    statement.setInt(i++, renderID);
                    return false;
                }
            }, new IResultSetAccumulator(){

                @Override
                public IResultSetAccumulator.Action accumulate(ResultSet rs) throws Exception {
                    found[0] = true;
                    return IResultSetAccumulator.STOP;
                }
            });
            return found[0];
        }
        catch (Exception ex) {
            String details = "Error querying for render ownership";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1128, details, (Throwable)ex);
        }
    }

    @Override
    public List<RenderStatus> findRenderStatusByRenderId(int renderId) throws CMException {
        ArrayList<RenderStatus> l = new ArrayList<RenderStatus>();
        try {
            IRenderRow render = this.loadRender(renderId);
            if (null != render) {
                RenderState state = RenderState.parse(render.getIntField(RenderRow.RenderField.STATUS));
                RenderStatus status = new RenderStatus(renderId, state, render.getRenderTime(), render.getDisplayableLabel());
                l.add(status);
            }
            return l;
        }
        catch (Exception ex) {
            String details = "Error loading record";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1120, details, (Throwable)ex);
        }
    }

    @Override
    public void setRenderLastViewed(int renderID, int userID) throws CMException {
        this.userRenderDAO.setLastViewed(userID, renderID);
    }

    @Override
    public IRenderRow[] getReportRecentRenders(int userID, String storeID) throws CMException {
        String sql = SQL_REPORT_RENDERS + SQL_REPORT_RENDERS_STOREID_CLAUSE + SQL_REPORT_RENDERS_CLAUSE + SQL_REPORT_RENDERS_ORDER_CLAUSE;
        return this.getReportRenders(sql, userID, storeID);
    }

    @Override
    public IRenderRow getLatestDrillTargetRender(final int userID, final String storeID, final String drillParams) throws CMException {
        String sql = SQL_DRILLTARGET_RENDERS + SQL_REPORT_RENDERS_CLAUSE + SQL_REPORT_RENDERS_ORDER_CLAUSE;
        final ArrayList renders = new ArrayList(1);
        this.database.executeQuery(sql, new DefaultPreparedStatementParameterizer(){

            @Override
            public boolean parameterize(PreparedStatement statement) throws Exception {
                int i = 1;
                statement.setInt(i++, userID);
                statement.setString(i++, storeID);
                statement.setString(i++, drillParams);
                return false;
            }
        }, new IResultSetAccumulator(){

            @Override
            public IResultSetAccumulator.Action accumulate(ResultSet rs) throws Exception {
                RenderRow render = new RenderRow(rs);
                renders.add(render);
                return IResultSetAccumulator.STOP;
            }
        });
        try {
            if (renders.size() == 1) {
                return (RenderRow)renders.get(0);
            }
            return null;
        }
        catch (Exception ex) {
            String details = "error listing renders";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1128, details, (Throwable)ex);
        }
    }

    @Override
    public IRenderRow[] getReportSavedRenders(int userID, String storeID) throws CMException {
        String sql = SQL_REPORT_RENDERS + SQL_REPORT_RENDERS_STOREID_CLAUSE + SQL_REPORT_SAVED_RENDERS_CLAUSE + SQL_REPORT_RENDERS_ORDER_CLAUSE;
        return this.getReportRenders(sql, userID, storeID);
    }

    private IRenderRow[] getReportRenders(String sql, final int userID, final String storeID) throws CMException {
        final ArrayList renders = new ArrayList();
        this.database.executeQuery(sql, new DefaultPreparedStatementParameterizer(){

            @Override
            public boolean parameterize(PreparedStatement statement) throws Exception {
                int i = 1;
                statement.setInt(i++, userID);
                statement.setString(i++, storeID);
                return false;
            }
        }, new IResultSetAccumulator(){

            @Override
            public IResultSetAccumulator.Action accumulate(ResultSet rs) throws Exception {
                RenderRow render = new RenderRow(rs);
                renders.add(render);
                return IResultSetAccumulator.CONTINUE;
            }
        });
        try {
            return (RenderRow[])renders.toArray(new IRenderRow[0]);
        }
        catch (Exception ex) {
            String details = "error listing renders";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1128, details, (Throwable)ex);
        }
    }

    @Override
    public int getRenderSize(final int renderID) throws CMException {
        try {
            final ArrayList l = new ArrayList(1);
            this.database.executeQuery(SQL_RENDER_SIZE, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setInt(i++, renderID);
                    return false;
                }
            }, new IResultSetAccumulator(){

                @Override
                public IResultSetAccumulator.Action accumulate(ResultSet resultSet) throws Exception {
                    int i = 1;
                    l.add(new Integer(resultSet.getInt(i++)));
                    return IResultSetAccumulator.STOP;
                }
            });
            if (l.size() == 0) {
                return -1;
            }
            return (Integer)l.get(0);
        }
        catch (Exception ex) {
            throw new CMException(1120, "Problem getting render size for renderID: " + renderID, (Throwable)ex);
        }
    }

    @Override
    public IRenderRow[] getRendersBySource(final int sourceID) throws CMException {
        final ArrayList renders = new ArrayList();
        this.database.executeQuery(SQL_RENDERS_BY_SOURCE, new DefaultPreparedStatementParameterizer(){

            @Override
            public boolean parameterize(PreparedStatement statement) throws Exception {
                int i = 1;
                statement.setInt(i++, sourceID);
                return false;
            }
        }, new IResultSetAccumulator(){

            @Override
            public IResultSetAccumulator.Action accumulate(ResultSet rs) throws Exception {
                int i = 1;
                IRenderRow render = new RenderRow().setField(RenderRow.RenderField.RENDERID, rs.getInt(i++)).setField(RenderRow.RenderField.LABEL, rs.getString(i++));
                renders.add(render);
                return IResultSetAccumulator.CONTINUE;
            }
        });
        try {
            return renders.toArray(new IRenderRow[0]);
        }
        catch (Exception ex) {
            String details = "error retrieving renders by source";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1128, details, (Throwable)ex);
        }
    }
}

