/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.database;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.database.DefaultPreparedStatementParameterizer;
import com.cognos.mobile.database.IRenderGroupDAO;
import com.cognos.mobile.database.IRenderRow;
import com.cognos.mobile.database.IResultSetAccumulator;
import com.cognos.mobile.database.ISQLDatabase;
import com.cognos.mobile.database.RenderRow;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class SQLRenderGroupDAO
implements IRenderGroupDAO {
    private ISQLDatabase m_database;

    public SQLRenderGroupDAO(ISQLDatabase database) {
        this.m_database = database;
    }

    @Override
    public List<IRenderRow> getRendersForGroup(final List<String> groups) throws CMException {
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT DISTINCT MOB_RENDERS_BY_GROUP.RENDER_ID, MOB_RENDERS.PORTALITEM_ID, MOB_PORTALITEMS.LABEL FROM MOB_RENDERS_BY_GROUP");
        builder.append(" INNER JOIN MOB_RENDERS ON MOB_RENDERS_BY_GROUP.RENDER_ID = MOB_RENDERS.RENDER_ID");
        builder.append(" INNER JOIN MOB_PORTALITEMS ON MOB_RENDERS.PORTALITEM_ID =  MOB_PORTALITEMS.PORTALITEM_ID");
        builder.append(" WHERE GROUP_ID in (");
        for (int i = 0; i < groups.size(); ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append("?");
        }
        builder.append(")");
        final ArrayList<IRenderRow> res = new ArrayList<IRenderRow>();
        this.m_database.executeQuery(builder.toString(), new DefaultPreparedStatementParameterizer(){

            @Override
            public boolean parameterize(PreparedStatement statement) throws Exception {
                int param = 1;
                for (int i = 0; i < groups.size(); ++i) {
                    statement.setString(param, (String)groups.get(i));
                    ++param;
                }
                return false;
            }
        }, new IResultSetAccumulator(){

            @Override
            public IResultSetAccumulator.Action accumulate(ResultSet resultSet) throws Exception {
                RenderRow row = new RenderRow();
                row.setField(RenderRow.RenderField.RENDERID, resultSet.getInt(1));
                row.setField(RenderRow.RenderField.PORTALITEM_ID, resultSet.getInt(2));
                row.setField(RenderRow.RenderField.LABEL, resultSet.getString(3));
                res.add(row);
                return CONTINUE;
            }
        });
        return res;
    }

    @Override
    public void deleteRenderGrouping(final int[] renderID) throws CMException {
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM MOB_RENDERS_BY_GROUP WHERE RENDER_ID IN (");
        for (int i = 0; i < renderID.length; ++i) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append("?");
        }
        sql.append(")");
        this.m_database.executeCommittedUpdate(sql.toString(), new DefaultPreparedStatementParameterizer(){

            @Override
            public boolean parameterize(PreparedStatement statement) throws Exception {
                for (int i = 0; i < renderID.length; ++i) {
                    statement.setInt(i + 1, renderID[i]);
                }
                return false;
            }
        }, null, null);
    }

    @Override
    public void deleteRendersForGroups(final List<String> groups) throws CMException {
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM MOB_RENDERS_BY_GROUP WHERE GROUP_ID IN (");
        for (int i = 0; i < groups.size(); ++i) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append("?");
        }
        sql.append(")");
        this.m_database.executeCommittedUpdate(sql.toString(), new DefaultPreparedStatementParameterizer(){

            @Override
            public boolean parameterize(PreparedStatement statement) throws Exception {
                int param = 1;
                for (int i = 0; i < groups.size(); ++i) {
                    statement.setString(param, (String)groups.get(i));
                    ++param;
                }
                return false;
            }
        }, null, null);
    }

    @Override
    public void insertRenderToGroupMapping(final int renderID, final List<String> groups) throws CMException {
        this.deleteRendersForGroups(groups);
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO MOB_RENDERS_BY_GROUP (RENDER_ID, GROUP_ID");
        sql.append(") VALUES (?, ?");
        sql.append(")");
        this.m_database.executeCommittedInsert(sql.toString(), new DefaultPreparedStatementParameterizer(){
            private int current = 0;

            @Override
            public boolean parameterize(PreparedStatement statement) throws Exception {
                int i = 1;
                statement.setInt(i++, renderID);
                statement.setString(i++, (String)groups.get(this.current));
                ++this.current;
                return this.current != groups.size();
            }

            @Override
            public boolean useBatch() {
                return true;
            }
        });
    }

    @Override
    public LinkedHashMap<String, IRenderRow> getGroupToRenders() throws CMException {
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT MOB_RENDERS_BY_GROUP.GROUP_ID, MOB_RENDERS_BY_GROUP.RENDER_ID, MOB_RENDERS.PORTALITEM_ID, MOB_PORTALITEMS.LABEL FROM MOB_RENDERS_BY_GROUP");
        builder.append(" INNER JOIN MOB_RENDERS ON MOB_RENDERS_BY_GROUP.RENDER_ID = MOB_RENDERS.RENDER_ID");
        builder.append(" INNER JOIN MOB_PORTALITEMS ON MOB_RENDERS.PORTALITEM_ID =  MOB_PORTALITEMS.PORTALITEM_ID");
        final LinkedHashMap<String, IRenderRow> res = new LinkedHashMap<String, IRenderRow>();
        this.m_database.executeQuery(builder.toString(), new IResultSetAccumulator(){

            @Override
            public IResultSetAccumulator.Action accumulate(ResultSet resultSet) throws Exception {
                String groupID = resultSet.getString(1);
                RenderRow row = new RenderRow();
                row.setField(RenderRow.RenderField.RENDERID, resultSet.getInt(2));
                row.setField(RenderRow.RenderField.PORTALITEM_ID, resultSet.getInt(3));
                row.setField(RenderRow.RenderField.LABEL, resultSet.getString(4));
                res.put(groupID, row);
                return CONTINUE;
            }
        });
        return res;
    }
}

