/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.database;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.database.DefaultPreparedStatementParameterizer;
import com.cognos.mobile.database.IRenderHistoryDAO;
import com.cognos.mobile.database.ISQLDatabase;
import com.cognos.mobile.database.SQLHistoryDAO;
import com.cognos.mobile.vm.VM;
import java.sql.PreparedStatement;

public class SQLRenderHistoryDAO
implements IRenderHistoryDAO {
    private static final Class CLASS = SQLHistoryDAO.class;
    private final ISQLDatabase database;
    private static final String TABLE = "MOB_RENDER_HISTORY";
    private static final String INSERT = "INSERT INTO MOB_RENDER_HISTORY( RENDER_ID,HISTORY_ID) VALUES(?, ?)";
    private static final String DELETE = "DELETE FROM MOB_RENDER_HISTORY WHERE HISTORY_ID = ?";

    public SQLRenderHistoryDAO(ISQLDatabase database) {
        this.database = database;
    }

    @Override
    public void insertRenderHistory(final int renderID, final int historyID) throws CMException {
        try {
            this.database.executeUpdate(INSERT, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setInt(i++, renderID);
                    statement.setInt(i++, historyID);
                    return false;
                }
            }, null, null);
        }
        catch (Exception ex) {
            String errMsg = "error inserting render history object";
            VM.log(CLASS, 0, errMsg, ex);
            throw new CMException(1120, errMsg, (Throwable)ex);
        }
    }

    @Override
    public void removeRenderHistory(final int historyID) throws CMException {
        try {
            this.database.executeUpdate(DELETE, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setInt(i++, historyID);
                    return false;
                }
            }, null, null);
        }
        catch (Exception ex) {
            String errMsg = "error removing render history object";
            VM.log(CLASS, 0, errMsg, ex);
            throw new CMException(1120, errMsg, (Throwable)ex);
        }
    }

    @Override
    public void insertHistoryRenders(int[] renderIDs, int historyID) throws CMException {
        for (int i = 0; i < renderIDs.length; ++i) {
            if (renderIDs[i] == -1) continue;
            this.insertRenderHistory(renderIDs[i], historyID);
        }
    }
}

