/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.database;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.database.DefaultPreparedStatementParameterizer;
import com.cognos.mobile.database.IResourceDAO;
import com.cognos.mobile.database.IResultSetAccumulator;
import com.cognos.mobile.database.ISQLDatabase;
import com.cognos.mobile.database.ResourceRow;
import com.cognos.mobile.database.SQLBaseReportDAO;
import com.cognos.mobile.vm.VM;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class SQLResourceDAO
extends SQLBaseReportDAO
implements IResourceDAO {
    private static final Class<SQLResourceDAO> CLASS = SQLResourceDAO.class;
    private static final String SQL_DELETE_RESOURCE_BY_RENDERID = "DELETE FROM MOB_RESOURCES WHERE RENDER_ID=? AND PAGE_INDEX =?";
    private static final String SQL_DELETE_RESOURCE = "DELETE FROM MOB_RESOURCES WHERE RESOURCE_ID=?";
    private static final String SQL_GET_RESOURCE_BY_ID_PATH_HASH = "SELECT RESOURCE_ID, RENDER_ID, PATH, HASH, FORMAT, HEIGHT, WIDTH, BLOB_ID, OBJECT_INDEX, PAGE_INDEX, DOWNLOAD_URL FROM MOB_RESOURCES WHERE RENDER_ID = ? AND PATH = ? AND HASH = ?";
    private static final String SQL_GET_RESOURCE_BY_HASH = "SELECT RESOURCE_ID, RENDER_ID, PATH, HASH, FORMAT, HEIGHT, WIDTH, BLOB_ID, OBJECT_INDEX, PAGE_INDEX, DOWNLOAD_URL FROM MOB_RESOURCES WHERE HASH = ?";
    private static final String SQL_GET_RESOURCE_BY_BLOB_INFO = "SELECT RESOURCE_ID, RENDER_ID, PATH, HASH, FORMAT, HEIGHT, WIDTH, BLOB_ID, OBJECT_INDEX, PAGE_INDEX, DOWNLOAD_URL FROM MOB_RESOURCES WHERE RENDER_ID=?";
    private static final String SQL_GET_RESOURCE_LIST = "SELECT MOB_RESOURCES.RESOURCE_ID, MOB_RESOURCES.RENDER_ID, MOB_RESOURCES.PATH, MOB_RESOURCES.HASH, MOB_RESOURCES.FORMAT, MOB_RESOURCES.HEIGHT, MOB_RESOURCES.WIDTH, MOB_RESOURCES.BLOB_ID, MOB_RESOURCES.OBJECT_INDEX, MOB_RESOURCES.PAGE_INDEX, MOB_RESOURCES.DOWNLOAD_URL FROM MOB_RESOURCES INNER JOIN MOB_RENDERS ON MOB_RESOURCES.RENDER_ID = MOB_RENDERS.RENDER_ID WHERE ((MOB_RESOURCES.PAGE_INDEX IS NULL) OR (MOB_RESOURCES.PAGE_INDEX BETWEEN 0 AND (MOB_RENDERS.RENDER_SIZE - 1))) AND MOB_RESOURCES.RENDER_ID = ?";
    private static final String SQL_RESOURCE_HASH_IS_IN_USERS_INBOX = "SELECT MOB_RESOURCES.RENDER_ID, MOB_RESOURCES.PATH, MOB_RESOURCES.FORMAT, MOB_RESOURCES.HEIGHT, MOB_RESOURCES.WIDTH, MOB_RESOURCES.BLOB_ID, MOB_RESOURCES.OBJECT_INDEX, MOB_RESOURCES.PAGE_INDEX FROM MOB_RENDERS INNER JOIN MOB_USER_RENDER ON MOB_RENDERS.RENDER_ID = MOB_USER_RENDER.RENDER_ID INNER JOIN MOB_RESOURCES ON MOB_RENDERS.RENDER_ID = MOB_RESOURCES.RENDER_ID WHERE (MOB_USER_RENDER.USER_ID = ?) AND (MOB_RESOURCES.HASH = ?)";
    private static final String SQL_MAX_BLOB_ID = "SELECT MAX(BLOB_ID) FROM MOB_RESOURCES WHERE RENDER_ID=?";
    private static final String SQL_INSERT_RESOURCE_NO_RENDER = "INSERT INTO MOB_RESOURCES (HASH, FORMAT) VALUES (?, ?)";
    private static final String SQL_GET_RESOURCE_BY_PATH_AND_RENDER = "SELECT RESOURCE_ID, RENDER_ID, PATH, HASH, FORMAT, HEIGHT, WIDTH, BLOB_ID, OBJECT_INDEX, PAGE_INDEX, DOWNLOAD_URL FROM MOB_RESOURCES WHERE PATH = ? AND RENDER_ID = ?";
    private static final String SQL_RESOURCE_IS_UITHEME_RESOURCE = "SELECT MOB_RESOURCES.RESOURCE_ID from MOB_RESOURCES INNER JOIN MOB_RENDERS_BY_GROUP ON MOB_RESOURCES.RENDER_ID = MOB_RENDERS_BY_GROUP.RENDER_ID AND (MOB_RESOURCES.HASH = ?)";

    public SQLResourceDAO(ISQLDatabase database) {
        super(database);
    }

    @Override
    public Connection getTransactionConnection() throws CMException {
        ISQLDatabase database = this.getDatabase();
        try {
            return database.getTransactionConnection();
        }
        catch (Exception e) {
            String details = "problem obtaining connection";
            VM.log(CLASS, 0, details, e);
            throw new CMException(1147, details, (Throwable)e);
        }
    }

    @Override
    public void releaseTransactionConnection(Connection connection) {
        this.getDatabase().releaseTransactionConnection(connection);
    }

    @Override
    public void insertResource(final int renderID, final String path, final String hash, final int format, int height, int width, Connection connection) throws CMException {
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("INSERT INTO MOB_RESOURCES (RENDER_ID, PATH, HASH, FORMAT");
            if (height != -1) {
                sql.append(", HEIGHT");
            }
            if (width != -1) {
                sql.append(", WIDTH");
            }
            sql.append(") VALUES (?, ?, ?, ?");
            if (height != -1) {
                sql.append(", ").append(height);
            }
            if (width != -1) {
                sql.append(", ").append(width);
            }
            sql.append(")");
            DefaultPreparedStatementParameterizer ipsp = new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setInt(i++, renderID);
                    statement.setString(i++, CMStringHelper.replaceAll(path, "'", "''", true));
                    statement.setString(i++, CMStringHelper.replaceAll(hash, "'", "''", true));
                    statement.setInt(i++, format);
                    return false;
                }
            };
            if (connection == null) {
                this.getDatabase().executeCommittedUpdate(sql.toString(), ipsp, "MOB_RESOURCES", "RESOURCE_ID");
            } else {
                this.getDatabase().executeUpdate(connection, sql.toString(), ipsp, "MOB_RESOURCES", "RESOURCE_ID");
            }
        }
        catch (CMException ex) {
            String details = "error inserting resource";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1126, details, (Throwable)ex);
        }
    }

    @Override
    public void insertExternalResources(final List<ResourceRow> rr) throws CMException {
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("INSERT INTO MOB_RESOURCES (RENDER_ID, PATH, HASH, FORMAT, DOWNLOAD_URL");
            sql.append(") VALUES (?, ?, ?, ?, ?");
            sql.append(")");
            this.getDatabase().executeCommittedInsert(sql.toString(), new DefaultPreparedStatementParameterizer(){
                private int current = 0;

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    ResourceRow row = (ResourceRow)rr.get(this.current);
                    int i = 1;
                    statement.setInt(i++, row.getRenderID());
                    statement.setString(i++, CMStringHelper.replaceAll(URLDecoder.decode(row.getPath(), "UTF-8"), "'", "''", true));
                    statement.setString(i++, CMStringHelper.replaceAll(row.getHash(), "'", "''", true));
                    statement.setInt(i++, row.getFormat());
                    statement.setString(i++, row.getDownloadURL());
                    ++this.current;
                    return this.current != rr.size();
                }

                @Override
                public boolean useBatch() {
                    return true;
                }
            });
        }
        catch (CMException ex) {
            String details = "error inserting resource";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1126, details, (Throwable)ex);
        }
    }

    @Override
    public void insertResource(final int renderID, String path, final String hash, final int format, int height, int width, int blobID, int objectIndex, int pageIndex) throws CMException {
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("INSERT INTO MOB_RESOURCES (RENDER_ID");
            if (path != null) {
                sql.append(", PATH");
            }
            sql.append(", HASH, FORMAT");
            if (height != -1) {
                sql.append(", HEIGHT");
            }
            if (width != -1) {
                sql.append(", WIDTH");
            }
            if (blobID != -1) {
                sql.append(", BLOB_ID");
            }
            if (objectIndex != -1) {
                sql.append(", OBJECT_INDEX");
            }
            if (pageIndex != -1) {
                sql.append(", PAGE_INDEX");
            }
            sql.append(") VALUES (?");
            if (path != null) {
                sql.append(", '").append(CMStringHelper.replaceAll(path, "'", "''", true)).append("'");
            }
            sql.append(", ?, ?");
            if (height != -1) {
                sql.append(", ").append(height);
            }
            if (width != -1) {
                sql.append(", ").append(width);
            }
            if (blobID != -1) {
                sql.append(", ").append(blobID);
            }
            if (objectIndex != -1) {
                sql.append(", ").append(objectIndex);
            }
            if (pageIndex != -1) {
                sql.append(", ").append(pageIndex);
            }
            sql.append(")");
            this.getDatabase().executeCommittedUpdate(sql.toString(), new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setInt(i++, renderID);
                    statement.setString(i++, CMStringHelper.replaceAll(hash, "'", "''", true));
                    statement.setInt(i++, format);
                    return false;
                }
            }, "MOB_RESOURCES", "RESOURCE_ID");
        }
        catch (CMException ex) {
            String details = "error inserting resource";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1126, details, (Throwable)ex);
        }
    }

    @Override
    public void insertResource(final String hash, final int format) throws CMException {
        try {
            this.getDatabase().executeCommittedUpdate(SQL_INSERT_RESOURCE_NO_RENDER, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setString(i++, CMStringHelper.replaceAll(hash, "'", "''", true));
                    statement.setInt(i++, format);
                    return false;
                }
            }, "MOB_RESOURCES", "RESOURCE_ID");
        }
        catch (CMException ex) {
            String details = "error inserting resource";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1126, details, (Throwable)ex);
        }
    }

    public void deleteResource(final int id) throws CMException {
        try {
            this.getDatabase().executeUpdate(SQL_DELETE_RESOURCE, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setInt(i++, id);
                    return false;
                }
            }, null, null);
        }
        catch (CMException ex) {
            String details = "Error deleting resource";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1121, details, (Throwable)ex);
        }
    }

    @Override
    public ResourceRow getResource(final int renderId, final String path, final String hash) throws CMException {
        try {
            final ArrayList resources = new ArrayList(1);
            this.getDatabase().executeQuery(SQL_GET_RESOURCE_BY_ID_PATH_HASH, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setInt(i++, renderId);
                    statement.setString(i++, path);
                    statement.setString(i++, hash);
                    return false;
                }
            }, new IResultSetAccumulator(){

                @Override
                public IResultSetAccumulator.Action accumulate(ResultSet rs) throws Exception {
                    ResourceRow ro = new ResourceRow(rs);
                    resources.add(ro);
                    return IResultSetAccumulator.STOP;
                }
            });
            if (resources.size() == 0) {
                return null;
            }
            return (ResourceRow)resources.get(0);
        }
        catch (CMException ex) {
            String details = "error loading resource";
            VM.log(CLASS, 0, details, ex);
            throw ex;
        }
    }

    @Override
    public ResourceRow getResource(final String hash) throws CMException {
        try {
            final ArrayList resources = new ArrayList(1);
            this.getDatabase().executeQuery(SQL_GET_RESOURCE_BY_HASH, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setString(i++, hash);
                    return false;
                }
            }, new IResultSetAccumulator(){

                @Override
                public IResultSetAccumulator.Action accumulate(ResultSet rs) throws Exception {
                    ResourceRow ro = new ResourceRow(rs);
                    resources.add(ro);
                    return IResultSetAccumulator.STOP;
                }
            });
            if (resources.size() == 0) {
                return null;
            }
            return (ResourceRow)resources.get(0);
        }
        catch (CMException ex) {
            String details = "error loading resource";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1128, details, (Throwable)ex);
        }
    }

    @Override
    public ResourceRow getResource(final String path, final int renderId) throws CMException {
        StringBuilder sql = new StringBuilder(SQL_GET_RESOURCE_BY_PATH_AND_RENDER);
        final ArrayList resources = new ArrayList(1);
        this.getDatabase().executeQuery(sql.toString(), new DefaultPreparedStatementParameterizer(){

            @Override
            public boolean parameterize(PreparedStatement statement) throws Exception {
                int i = 1;
                statement.setString(i++, path);
                statement.setInt(i++, renderId);
                return false;
            }
        }, new IResultSetAccumulator(){

            @Override
            public IResultSetAccumulator.Action accumulate(ResultSet rs) throws Exception {
                ResourceRow ro = new ResourceRow(rs);
                resources.add(ro);
                return IResultSetAccumulator.STOP;
            }
        });
        if (resources.size() == 0) {
            return null;
        }
        return (ResourceRow)resources.get(0);
    }

    @Override
    public ResourceRow getResource(final int renderID, int blobID, int format, int objectIndex, int page) throws CMException {
        StringBuilder sql = new StringBuilder(SQL_GET_RESOURCE_BY_BLOB_INFO);
        if (blobID != -1) {
            sql.append(" AND BLOB_ID=");
            sql.append(blobID);
        }
        if (format != -1) {
            sql.append(" AND FORMAT=");
            sql.append(format);
        }
        if (objectIndex != -1) {
            sql.append(" AND OBJECT_INDEX=");
            sql.append(objectIndex);
        }
        if (page != -1) {
            sql.append(" AND PAGE_INDEX=");
            sql.append(page);
        }
        try {
            final ArrayList resources = new ArrayList(1);
            this.getDatabase().executeQuery(sql.toString(), new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setInt(i++, renderID);
                    return false;
                }
            }, new IResultSetAccumulator(){

                @Override
                public IResultSetAccumulator.Action accumulate(ResultSet rs) throws Exception {
                    ResourceRow ro = new ResourceRow(rs);
                    resources.add(ro);
                    return IResultSetAccumulator.STOP;
                }
            });
            if (resources.size() == 0) {
                return null;
            }
            return (ResourceRow)resources.get(0);
        }
        catch (CMException ex) {
            String details = "error loading resource";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1128, details, (Throwable)ex);
        }
    }

    @Override
    public ResourceRow[] getResourceList(final int renderID, int[] formats) throws CMException {
        final ArrayList resources = new ArrayList();
        StringBuffer sql = new StringBuffer(SQL_GET_RESOURCE_LIST);
        if (formats.length > 0) {
            sql.append(" AND FORMAT IN (");
            for (int i = 0; i < formats.length; ++i) {
                sql.append(formats[i]);
                if (i == formats.length - 1) continue;
                sql.append(", ");
            }
            sql.append(")");
        }
        this.getDatabase().executeQuery(sql.toString(), new DefaultPreparedStatementParameterizer(){

            @Override
            public boolean parameterize(PreparedStatement statement) throws Exception {
                int i = 1;
                statement.setInt(i++, renderID);
                return false;
            }
        }, new IResultSetAccumulator(){

            @Override
            public IResultSetAccumulator.Action accumulate(ResultSet rs) throws Exception {
                ResourceRow ro = new ResourceRow(rs);
                resources.add(ro);
                return IResultSetAccumulator.CONTINUE;
            }
        });
        return resources.toArray(new ResourceRow[resources.size()]);
    }

    @Override
    public boolean resourceHashIsInUsersInbox(final String hash, final int userID) throws CMException {
        try {
            final boolean[] found = new boolean[]{false};
            this.getDatabase().executeQuery(SQL_RESOURCE_HASH_IS_IN_USERS_INBOX, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setInt(i++, userID);
                    statement.setString(i++, CMStringHelper.replaceAll(hash, "'", "''", true));
                    return false;
                }
            }, new IResultSetAccumulator(){

                @Override
                public IResultSetAccumulator.Action accumulate(ResultSet rs) throws Exception {
                    found[0] = true;
                    return IResultSetAccumulator.STOP;
                }
            });
            return found[0];
        }
        catch (CMException ex) {
            String details = String.format("Error querying for resource hash ownership for hash %s and user %d", hash, userID);
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1127, details, (Throwable)ex);
        }
    }

    @Override
    public int getMaxBlobID(final int renderID) throws CMException {
        try {
            final int[] blobID = new int[1];
            final boolean[] processed = new boolean[]{false};
            this.getDatabase().executeQuery(SQL_MAX_BLOB_ID, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setInt(i++, renderID);
                    return false;
                }
            }, new IResultSetAccumulator(){

                @Override
                public IResultSetAccumulator.Action accumulate(ResultSet rs) throws Exception {
                    blobID[0] = rs.getInt(1);
                    processed[0] = true;
                    return IResultSetAccumulator.STOP;
                }
            });
            if (processed[0]) {
                return blobID[0];
            }
            String details = "failed to get max blob id of resource";
            VM.log(CLASS, 0, details);
            throw new CMException(1120, details);
        }
        catch (CMException ex) {
            String details = "failed to get max blob id of resource";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1120, details, (Throwable)ex);
        }
    }

    @Override
    public void removeResource(final int renderID, final int pageIndex) throws CMException {
        try {
            this.getDatabase().executeUpdate(SQL_DELETE_RESOURCE_BY_RENDERID, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setInt(i++, renderID);
                    statement.setInt(i++, pageIndex);
                    return false;
                }
            }, null, null);
        }
        catch (CMException ex) {
            String details = "Error deleting resource";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1121, details, (Throwable)ex);
        }
    }

    @Override
    public boolean isUIThemeResource(final String hash) throws CMException {
        final boolean[] found = new boolean[]{false};
        this.getDatabase().executeQuery(SQL_RESOURCE_IS_UITHEME_RESOURCE, new DefaultPreparedStatementParameterizer(){

            @Override
            public boolean parameterize(PreparedStatement statement) throws Exception {
                statement.setString(1, hash);
                return false;
            }
        }, new IResultSetAccumulator(){

            @Override
            public IResultSetAccumulator.Action accumulate(ResultSet resultSet) throws Exception {
                found[0] = true;
                return IResultSetAccumulator.STOP;
            }
        });
        return found[0];
    }

    @Override
    public void updateResourceRenderReferences(final int oldRenderID, final int newRenderID) throws CMException {
        StringBuilder builder = new StringBuilder();
        builder.append("UPDATE MOB_RESOURCES SET RENDER_ID=? WHERE RENDER_ID = ?");
        LinkedHashMap res = new LinkedHashMap();
        this.getDatabase().executeCommittedUpdate(builder.toString(), new DefaultPreparedStatementParameterizer(){

            @Override
            public boolean parameterize(PreparedStatement statement) throws Exception {
                statement.setInt(1, newRenderID);
                statement.setInt(2, oldRenderID);
                return false;
            }
        }, null, null);
    }
}

