/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.database;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.database.DefaultPreparedStatementParameterizer;
import com.cognos.mobile.database.IRenderRow;
import com.cognos.mobile.database.IResultSetAccumulator;
import com.cognos.mobile.database.ISQLDatabase;
import com.cognos.mobile.database.ISyncDatabase;
import com.cognos.mobile.database.RenderRow;
import com.cognos.mobile.vm.VM;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Vector;

public class SQLSyncDatabase
implements ISyncDatabase {
    private final Class CLASS = SQLSyncDatabase.class;
    private static final String SQL_COUNT_PENDING_REPORTS = "SELECT COUNT(MOB_RENDERS.RENDER_SIZE) FROM MOB_RENDERS INNER JOIN MOB_USER_RENDER ON MOB_RENDERS.RENDER_ID = MOB_USER_RENDER.RENDER_ID WHERE (MOB_USER_RENDER.USER_ID = ?) AND (MOB_RENDERS.RENDER_SIZE = 0)";
    private final ISQLDatabase database;

    public SQLSyncDatabase(ISQLDatabase database) {
        this.database = database;
    }

    public boolean userHasPendingRenders(final int userID) throws CMException {
        final int[] count = new int[]{-1};
        final boolean[] processed = new boolean[]{false};
        IResultSetAccumulator accumulator = new IResultSetAccumulator(){

            @Override
            public IResultSetAccumulator.Action accumulate(ResultSet resultSet) throws Exception {
                count[0] = resultSet.getInt(1);
                processed[0] = true;
                return IResultSetAccumulator.STOP;
            }
        };
        try {
            this.database.executeQuery(SQL_COUNT_PENDING_REPORTS, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setInt(i++, userID);
                    return false;
                }
            }, accumulator);
            if (!processed[0]) {
                String details = "failed to read count of pending renders";
                VM.log(this.CLASS, 0, details);
                throw new CMException(1120, details);
            }
            if (count[0] > 0) {
                VM.log(this.CLASS, 2, "user " + userID + " still has " + count[0] + " pending reports");
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            String details = "failed to read pending renders count";
            VM.log(this.CLASS, 0, details, ex);
            throw new CMException(1120, details, (Throwable)ex);
        }
    }

    @Override
    public ISyncDatabase.SyncResultSet getAddedRenders(Connection connection, int userID, int beginRenderID, int endRenderID) throws CMException {
        return this.getRendersResultSetCommon(connection, userID, beginRenderID, endRenderID, false);
    }

    @Override
    public ISyncDatabase.SyncRecentRenders getRecentRenders(Connection connection, int userID, int beginRenderID, int endRenderID, int maxVersions) throws CMException {
        ISyncDatabase.SyncResultSet rs = this.getRendersResultSetCommon(connection, userID, beginRenderID, endRenderID, false);
        Vector<RenderRow> renders = new Vector<RenderRow>();
        try {
            while (rs.resultSet.next()) {
                RenderRow renderRow = new RenderRow(rs.resultSet);
                renders.addElement(renderRow);
            }
        }
        catch (SQLException ex) {
            throw new CMException(1120, "failed to determine recent renders", (Throwable)ex);
        }
        finally {
            try {
                rs.resultSet.close();
            }
            catch (SQLException sQLException) {}
            try {
                rs.statement.close();
            }
            catch (SQLException sQLException) {}
            rs = null;
        }
        HashMap<String, Integer> reportCounts = new HashMap<String, Integer>();
        Vector<IRenderRow> newRenders = new Vector<IRenderRow>();
        Vector<IRenderRow> oldRenders = new Vector<IRenderRow>();
        for (int i = renders.size() - 1; i >= 0; --i) {
            IRenderRow renderRow = (IRenderRow)renders.elementAt(i);
            String storeID = renderRow.getStringField(RenderRow.RenderField.STOREID);
            int count = reportCounts.containsKey(storeID) ? (Integer)reportCounts.get(storeID) : 0;
            reportCounts.put(storeID, new Integer(++count));
            if (count <= maxVersions) {
                newRenders.insertElementAt(renderRow, 0);
                continue;
            }
            oldRenders.insertElementAt(renderRow, 0);
        }
        ISyncDatabase.SyncRecentRenders rc = new ISyncDatabase.SyncRecentRenders();
        rc.newRenders = newRenders.toArray(new IRenderRow[0]);
        rc.oldRenders = oldRenders.toArray(new IRenderRow[0]);
        return rc;
    }

    @Override
    public byte[] getBlobBytes(ResultSet rs, int column) throws SQLException {
        return this.database.getBlobBytes(rs, column);
    }

    private ISyncDatabase.SyncResultSet getRendersResultSetCommon(Connection connection, int userID, int beginRenderID, int endRenderID, boolean isDeleted) throws CMException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT MOB_RENDERS.RENDER_ID, MOB_USER_RENDER.USER_ID, MOB_PORTALITEMS.LABEL, MOB_PORTALITEMS.STORE_ID, ");
        sql.append("MOB_PORTALITEMS.CM_PATH, MOB_PORTALITEMS.SOURCE_PATH, MOB_PORTALITEMS.DESCRIPTION, MOB_RENDERS.RENDER_TIME, ");
        sql.append("MOB_RENDERS.RENDER_SIZE, MOB_RENDERS.STATUS_CODE, MOB_RENDERS.DRILL_PARAMS, MOB_RENDERS.PORTALITEM_ID, ");
        sql.append("MOB_RENDERS.SOURCE_CODE, MOB_RENDERS.BASE_DOC, MOB_RENDERS.SMALL_THUMB, MOB_RENDERS.MEDIUM_THUMB, ");
        sql.append("MOB_RENDERS.LARGE_THUMB, MOB_USER_RENDER.LAST_VIEWED, MOB_PORTALITEMS.PORTALITEM_TYPE, MOB_USER_RENDER.NAME,");
        sql.append("MOB_RENDERS.SAVED_OUTPUT_TYPE, MOB_RENDERS.CREATION_TIME, MOB_RENDERS.BURST_VALUE, MOB_RENDERS.EXECUTION_ID,  MOB_RENDERS.OUTPUT_TYPE_MASK, MOB_RENDERS.HAS_MORE_PAGES, MOB_RENDERS.PASSPORT, MOB_RENDERS.TABS ");
        sql.append("FROM MOB_RENDERS INNER JOIN ");
        sql.append("MOB_USER_RENDER ON MOB_RENDERS.RENDER_ID = MOB_USER_RENDER.RENDER_ID INNER JOIN ");
        sql.append("MOB_PORTALITEMS ON MOB_RENDERS.PORTALITEM_ID = MOB_PORTALITEMS.PORTALITEM_ID");
        sql.append(" where");
        sql.append(" MOB_USER_RENDER.USER_ID=" + userID);
        sql.append(" and ");
        sql.append(this.buildRenderWhereClause("", beginRenderID, endRenderID));
        sql.append(" order by MOB_RENDERS.RENDER_ID");
        ISyncDatabase.SyncResultSet rc = this.database.createScrollableResultSet(connection, sql.toString());
        return rc;
    }

    private String buildRenderWhereClause(String tableNamePrefix, int beginRenderID, int endRenderID) throws CMException {
        String sql = beginRenderID < 0 && endRenderID < 0 ? "" : (beginRenderID < 0 ? CMStringHelper.formatString("{1}MOB_RENDERS.RENDER_ID < {2}", new String[]{tableNamePrefix, Integer.toString(endRenderID)}) : (endRenderID < 0 ? CMStringHelper.formatString("{1}MOB_RENDERS.RENDER_ID >= {2}", new String[]{tableNamePrefix, Integer.toString(beginRenderID)}) : CMStringHelper.formatString("({1}MOB_RENDERS.RENDER_ID >= {2} AND {1}MOB_RENDERS.RENDER_ID < {3})", new String[]{tableNamePrefix, Integer.toString(beginRenderID), Integer.toString(endRenderID)})));
        return sql;
    }
}

