/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.database;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.database.DefaultPreparedStatementParameterizer;
import com.cognos.mobile.database.IResultSetAccumulator;
import com.cognos.mobile.database.ISQLDatabase;
import com.cognos.mobile.database.ITempStorageDAO;
import com.cognos.mobile.database.InsertBlobStatementParameterizer;
import com.cognos.mobile.database.TempStorageObject;
import com.cognos.mobile.vm.VM;
import java.io.ByteArrayOutputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;

public class SQLTempStorageDAO
implements ITempStorageDAO {
    private static final Class CLASS = SQLTempStorageDAO.class;
    private static final String TABLE = "MOB_TEMPSTORAGE";
    private static final String BLOBTABLE = "MOB_TEMPSTOREBLOBS";
    private static final String DELETE_BLOB = "DELETE FROM MOB_TEMPSTOREBLOBS WHERE TS_ID=?";
    private static final String DELETE = "DELETE FROM MOB_TEMPSTORAGE WHERE TS_ID=?";
    private static final String DELETE_ALL_BLOBS = "DELETE FROM MOB_TEMPSTOREBLOBS";
    private static final String DELETE_ALL = "DELETE FROM MOB_TEMPSTORAGE";
    private static final String INSERT = "INSERT INTO MOB_TEMPSTORAGE(CREATED, MODIFIED) VALUES(?, ?)";
    private static final String INSERT_BLOB = "INSERT INTO MOB_TEMPSTOREBLOBS(TS_ID, SEQUENCE, BLOB_VALUE) VALUES(?, ?, ?)";
    private static final String DELETE_TEMPSTORE_BEFORE = "DELETE FROM MOB_TEMPSTORAGE WHERE MODIFIED <=?";
    private static final String FIND_BY_ID = "SELECT CREATED, MODIFIED, TS_ID FROM MOB_TEMPSTORAGE WHERE TS_ID=?";
    private static final String FIND_BY_PATH = "SELECT CREATED, MODIFIED, TS_ID FROM MOB_TEMPSTORAGE WHERE PATH LIKE ?";
    private static final String FIND_ALL_ITEMS = "SELECT TS_ID FROM MOB_TEMPSTORAGE";
    private static final String FIND_BLOB = "SELECT BLOB_VALUE FROM MOB_TEMPSTOREBLOBS WHERE TS_ID=? ORDER BY SEQUENCE";
    private static final String FIND_MODIFIED_BEFORE = "SELECT TS_ID FROM MOB_TEMPSTORAGE WHERE MODIFIED <=?";
    private static final String UPDATE = "UPDATE MOB_TEMPSTORAGE SET PATH=?, MODIFIED=? WHERE TS_ID=?";
    private final ISQLDatabase db;

    public SQLTempStorageDAO(ISQLDatabase database) {
        this.db = database;
    }

    @Override
    public boolean tempStoragePathExists(final int path) throws CMException {
        VM.log(CLASS, 0, "checking if path exists in temp storage: " + path);
        final ArrayList l = new ArrayList();
        try {
            this.db.executeQuery(FIND_BY_ID, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setInt(i++, path);
                    return false;
                }
            }, new IResultSetAccumulator(){

                @Override
                public IResultSetAccumulator.Action accumulate(ResultSet resultSet) throws Exception {
                    l.add(SQLTempStorageDAO.this.create(resultSet));
                    return IResultSetAccumulator.STOP;
                }
            });
            return l.size() != 0;
        }
        catch (Exception ex) {
            String details = "Error loading record";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1120, details, (Throwable)ex);
        }
    }

    public boolean tempStoragePathExists(final String path) throws CMException {
        VM.log(CLASS, 0, "checking if path exists in temp storage: " + path);
        final ArrayList l = new ArrayList();
        try {
            this.db.executeQuery(FIND_BY_ID, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setString(i++, path);
                    return false;
                }
            }, new IResultSetAccumulator(){

                @Override
                public IResultSetAccumulator.Action accumulate(ResultSet resultSet) throws Exception {
                    l.add(SQLTempStorageDAO.this.create(resultSet));
                    return IResultSetAccumulator.STOP;
                }
            });
            return l.size() != 0;
        }
        catch (Exception ex) {
            String details = "Error loading record";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1120, details, (Throwable)ex);
        }
    }

    @Override
    public TempStorageObject createTempStorage() throws CMException {
        VM.log(CLASS, 0, "creating tso");
        try {
            final Date now = new Date();
            int newId = this.db.executeUpdate(INSERT, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setTimestamp(i++, new Timestamp(now.getTime()));
                    statement.setTimestamp(i++, new Timestamp(now.getTime()));
                    return false;
                }
            }, TABLE, "TS_ID");
            TempStorageObject _tso = new TempStorageObject(now, now, newId, null);
            this.updateTempStorage(_tso);
            VM.log(CLASS, 0, "created new tso " + _tso + " with id" + _tso.getId());
            return _tso;
        }
        catch (Exception ex) {
            String details = "error inserting temp storage object";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1120, details, (Throwable)ex);
        }
    }

    @Override
    public TempStorageObject createTempStorage(String path, boolean overwrite) throws CMException {
        VM.log(CLASS, 0, "creating tso with path: " + path + " overwrite: " + overwrite);
        TempStorageObject tso = this.findTempStorageByPath(path);
        if (tso != null) {
            if (overwrite) {
                VM.log(CLASS, 0, "overwriting tso: " + tso);
                this.removeBlob(tso.getId());
            } else {
                return tso;
            }
        }
        try {
            final Date now = new Date();
            int newId = this.db.executeUpdate(INSERT, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setTimestamp(i++, new Timestamp(now.getTime()));
                    statement.setTimestamp(i++, new Timestamp(now.getTime()));
                    return false;
                }
            }, TABLE, "TS_ID");
            TempStorageObject _tso = new TempStorageObject(now, now, newId, null);
            _tso.setTempName(path);
            this.updateTempStorage(_tso);
            VM.log(CLASS, 0, "created new tso " + _tso);
            return _tso;
        }
        catch (Exception ex) {
            String details = "error inserting temp storage object";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1120, details, (Throwable)ex);
        }
    }

    private TempStorageObject create(ResultSet rs) throws SQLException, CMException {
        int i = 1;
        TempStorageObject tso = new TempStorageObject(rs.getTimestamp(i++), rs.getTimestamp(i++), rs.getInt(i++), null);
        return tso;
    }

    @Override
    public void removeTempStorageModifiedBefore(final Date modified) throws CMException {
        VM.log(CLASS, 0, "removing all temp storage objects modified before " + modified);
        ArrayList l = new ArrayList();
        try {
            this.db.executeUpdate(DELETE_TEMPSTORE_BEFORE, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setTimestamp(i++, new Timestamp(modified.getTime()));
                    return false;
                }
            }, null, null);
        }
        catch (Exception ex) {
            String details = "Error loading record";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1120, details, (Throwable)ex);
        }
    }

    @Override
    public TempStorageObject findTempStorageById(final int id) throws CMException {
        final ArrayList l = new ArrayList();
        try {
            this.db.executeQuery(FIND_BY_ID, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setInt(i++, id);
                    return false;
                }
            }, new IResultSetAccumulator(){

                @Override
                public IResultSetAccumulator.Action accumulate(ResultSet resultSet) throws Exception {
                    l.add(SQLTempStorageDAO.this.create(resultSet));
                    return IResultSetAccumulator.STOP;
                }
            });
            if (l.size() == 0) {
                return null;
            }
            TempStorageObject tso = (TempStorageObject)l.get(0);
            byte[] b = this.findBlobValue(tso);
            tso.setContent(b);
            return tso;
        }
        catch (Exception ex) {
            String details = "Error loading record";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1120, details, (Throwable)ex);
        }
    }

    @Override
    public TempStorageObject findTempStorageByPath(final String path) throws CMException {
        VM.log(CLASS, 0, "finding by path: " + path);
        final ArrayList l = new ArrayList();
        try {
            this.db.executeQuery(FIND_BY_PATH, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setString(i++, path);
                    return false;
                }
            }, new IResultSetAccumulator(){

                @Override
                public IResultSetAccumulator.Action accumulate(ResultSet resultSet) throws Exception {
                    l.add(SQLTempStorageDAO.this.create(resultSet));
                    return IResultSetAccumulator.STOP;
                }
            });
            if (l.size() == 0) {
                return null;
            }
            TempStorageObject tso = (TempStorageObject)l.get(0);
            VM.log(CLASS, 0, "found " + tso);
            byte[] b = this.findBlobValue(tso);
            tso.setContent(b);
            return (TempStorageObject)l.get(0);
        }
        catch (Exception ex) {
            String details = "Error loading record";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1120, details, (Throwable)ex);
        }
    }

    @Override
    public String[] findAllTempStoragePaths() throws CMException {
        final ArrayList l = new ArrayList();
        try {
            this.db.executeQuery(FIND_ALL_ITEMS, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    return false;
                }
            }, new IResultSetAccumulator(){

                @Override
                public IResultSetAccumulator.Action accumulate(ResultSet resultSet) throws Exception {
                    l.add(resultSet.getString(1));
                    return IResultSetAccumulator.CONTINUE;
                }
            });
            return l.toArray(new String[l.size()]);
        }
        catch (Exception ex) {
            String details = "Error loading record";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1120, details, (Throwable)ex);
        }
    }

    @Override
    public void removeTempStorage(TempStorageObject o) throws CMException {
        try {
            this.remove(o.getId());
        }
        catch (Exception ex) {
            String details = "Error deleting";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1121, details, (Throwable)ex);
        }
    }

    private void remove(final int id) throws CMException {
        VM.log(CLASS, 0, "removing tso.id = " + id);
        try {
            this.removeBlob(id);
            this.db.executeUpdate(DELETE, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setInt(i++, id);
                    return false;
                }
            }, null, null);
        }
        catch (Exception ex) {
            String details = "Error deleting";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1121, details, (Throwable)ex);
        }
    }

    private void removeBlob(final int id) throws CMException {
        VM.log(CLASS, 0, "removing blobs for tso id = " + id);
        try {
            this.db.executeUpdate(DELETE_BLOB, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setInt(i++, id);
                    return false;
                }
            }, null, null);
        }
        catch (Exception ex) {
            String details = "Error deleting";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1121, details, (Throwable)ex);
        }
    }

    private void insertBlob(TempStorageObject o) throws CMException {
        try {
            InsertBlobStatementParameterizer ps = new InsertBlobStatementParameterizer(o.getId(), o.getContent(), this.db);
            this.db.executePreparedStatement(INSERT_BLOB, ps, null);
        }
        catch (Exception ex) {
            String details = "error updating MOB_TEMPSTOREBLOBS";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1121, details, (Throwable)ex);
        }
    }

    private byte[] findBlobValue(final TempStorageObject o) throws CMException {
        VM.log(CLASS, 0, "finding blob content for tso: " + o);
        try {
            final ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            this.db.executeQuery(FIND_BLOB, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setInt(i++, o.getId());
                    return false;
                }
            }, new IResultSetAccumulator(){

                @Override
                public IResultSetAccumulator.Action accumulate(ResultSet resultSet) throws Exception {
                    bytes.write(SQLTempStorageDAO.this.db.getBlobBytes(resultSet, 1));
                    return IResultSetAccumulator.CONTINUE;
                }
            });
            byte[] b = bytes.toByteArray();
            VM.log(CLASS, 0, "found " + b.length + "bytes for tso: " + o);
            return b;
        }
        catch (Exception ex) {
            String details = "Error loading record";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1127, details, (Throwable)ex);
        }
    }

    @Override
    public void removeAllTempStorage() throws CMException {
        VM.log(CLASS, 0, "removing all temp storage.");
        try {
            this.db.executeUpdate(DELETE_ALL, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    return false;
                }
            }, null, null);
            this.db.executeUpdate(DELETE_ALL_BLOBS, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    return false;
                }
            }, null, null);
        }
        catch (Exception ex) {
            String details = "Error deleting";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1121, details, (Throwable)ex);
        }
    }

    @Override
    public void updateTempStorage(final TempStorageObject o) throws CMException {
        VM.log(CLASS, 0, "updating " + o);
        try {
            this.db.executeUpdate(UPDATE, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setString(i++, o.getTempName());
                    statement.setTimestamp(i++, new Timestamp(o.getModified().getTime()));
                    statement.setInt(i++, o.getId());
                    return false;
                }
            }, null, null);
            this.removeBlob(o.getId());
            this.insertBlob(o);
        }
        catch (Exception ex) {
            String details = "error updating MOB_TEMPSTORAGE";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1121, details, (Throwable)ex);
        }
    }
}

