/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.database;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMStringHelper2;
import com.cognos.mobile.database.DefaultPreparedStatementParameterizer;
import com.cognos.mobile.database.IResultSetAccumulator;
import com.cognos.mobile.database.ISQLDatabase;
import com.cognos.mobile.database.IUserDAO;
import com.cognos.mobile.model.data.User;
import com.cognos.mobile.vm.VM;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SQLUserDAO
implements IUserDAO {
    private static final String SQL_LIST_ALL_USERS = "SELECT CAM_ID, USER_ID, UNIQUE_USER_ID FROM MOB_USERS";
    private static final String SQL_GET_USER = "SELECT USER_ID, UNIQUE_USER_ID FROM MOB_USERS WHERE CAM_ID=? ORDER BY USER_ID";
    private static final String SQL_GET_USER_BY_ID = "SELECT CAM_ID, UNIQUE_USER_ID FROM MOB_USERS WHERE USER_ID=?";
    private static final String SQL_INSERT_USER = "INSERT INTO MOB_USERS(CAM_ID, DEVICE_ID, UNIQUE_USER_ID) VALUES( ?, ?, ? )";
    private static final String SQL_GET_LASTUPDATED_TIME = "SELECT LAST_UPDATED FROM MOB_USERS WHERE USER_ID=?";
    private static final String SQL_UPDATE_UNIQUE_USER_ID = "UPDATE MOB_USERS SET UNIQUE_USER_ID=? WHERE USER_ID=?";
    private static final Class CLASS = SQLUserDAO.class;
    private final ISQLDatabase database;

    public SQLUserDAO(ISQLDatabase database) {
        this.database = database;
    }

    @Override
    public User addUser(String searchPath) throws CMException {
        return this.addUser(searchPath, null);
    }

    @Override
    public User addUser(final String searchPath, final String uniqueUserId) throws CMException {
        try {
            int id = this.database.executeUpdate(SQL_INSERT_USER, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setString(i++, searchPath);
                    statement.setString(i++, "");
                    statement.setString(i++, uniqueUserId);
                    return false;
                }
            }, "MOB_USERS", "USER_ID");
            return new User(searchPath, id, uniqueUserId);
        }
        catch (Exception ex) {
            String details = "error inserting user";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1141, details, (Throwable)ex);
        }
    }

    @Override
    public User getUser(final String searchPath) throws CMException {
        final ArrayList l = new ArrayList(1);
        try {
            this.database.executeQuery(SQL_GET_USER, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setString(i++, searchPath);
                    return false;
                }
            }, new IResultSetAccumulator(){

                @Override
                public IResultSetAccumulator.Action accumulate(ResultSet resultSet) throws Exception {
                    int i = 1;
                    l.add(new User(searchPath, resultSet.getInt(i++), resultSet.getString(i++)));
                    return IResultSetAccumulator.STOP;
                }
            });
            if (l.size() == 0) {
                return null;
            }
            return (User)l.get(0);
        }
        catch (Exception ex) {
            String details = "error loading user record";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1139, details, (Throwable)ex);
        }
    }

    @Override
    public User getUser(final int id) throws CMException {
        final ArrayList l = new ArrayList(1);
        try {
            this.database.executeQuery(SQL_GET_USER_BY_ID, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setInt(i++, id);
                    return false;
                }
            }, new IResultSetAccumulator(){

                @Override
                public IResultSetAccumulator.Action accumulate(ResultSet resultSet) throws Exception {
                    int i = 1;
                    l.add(new User(resultSet.getString(i++), id, resultSet.getString(i++)));
                    return IResultSetAccumulator.STOP;
                }
            });
            if (l.size() == 0) {
                return null;
            }
            return (User)l.get(0);
        }
        catch (Exception ex) {
            String details = "error loading user record";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1139, details, (Throwable)ex);
        }
    }

    @Override
    public List listAllUsers() throws CMException {
        final ArrayList l = new ArrayList();
        IResultSetAccumulator accumulator = new IResultSetAccumulator(){

            @Override
            public IResultSetAccumulator.Action accumulate(ResultSet resultSet) throws Exception {
                int i = 1;
                l.add(new User(resultSet.getString(i++), resultSet.getInt(i++), resultSet.getString(i++)));
                return IResultSetAccumulator.CONTINUE;
            }
        };
        try {
            this.database.executeQuery(SQL_LIST_ALL_USERS, accumulator);
            return l;
        }
        catch (Exception ex) {
            String details = "error loading user record";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1139, details, (Throwable)ex);
        }
    }

    @Override
    public String getLastUpdated(final int userID) throws CMException {
        final ArrayList l = new ArrayList(1);
        try {
            this.database.executeQuery(SQL_GET_LASTUPDATED_TIME, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setInt(i++, userID);
                    return false;
                }
            }, new IResultSetAccumulator(){

                @Override
                public IResultSetAccumulator.Action accumulate(ResultSet resultSet) throws Exception {
                    l.add(resultSet.getTimestamp(1));
                    return IResultSetAccumulator.STOP;
                }
            });
            if (l.size() == 0) {
                return null;
            }
            return CMStringHelper2.formatDateTimeWithMiliSeconds((Date)l.get(0));
        }
        catch (Exception ex) {
            String details = "error loading sync time record";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1120, details, (Throwable)ex);
        }
    }

    @Override
    public void setUniqueUserId(final int userID, final String uniqueUserId) throws CMException {
        try {
            this.database.executeUpdate(SQL_UPDATE_UNIQUE_USER_ID, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setString(i++, uniqueUserId);
                    statement.setInt(i++, userID);
                    return false;
                }
            }, null, null);
        }
        catch (Exception ex) {
            String details = "error updating unique user id";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1121, details, (Throwable)ex);
        }
    }
}

