/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.database;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.database.DefaultPreparedStatementParameterizer;
import com.cognos.mobile.database.ISQLDatabase;
import com.cognos.mobile.database.IUserHistoryDAO;
import com.cognos.mobile.database.SQLHistoryDAO;
import com.cognos.mobile.vm.VM;
import java.sql.PreparedStatement;

public class SQLUserHistoryDAO
implements IUserHistoryDAO {
    private static final Class CLASS = SQLHistoryDAO.class;
    private static final String TABLE = "MOB_USER_HISTORY";
    private static final String INSERT = "INSERT INTO MOB_USER_HISTORY( USER_ID, HISTORY_ID) VALUES(?, ?)";
    private static final String DELETE = "DELETE FROM MOB_USER_HISTORY WHERE HISTORY_ID = ?";
    final ISQLDatabase database;

    public SQLUserHistoryDAO(ISQLDatabase database) {
        this.database = database;
    }

    @Override
    public void insertUserHistory(final int userID, final int historyID) throws CMException {
        try {
            this.database.executeUpdate(INSERT, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setInt(i++, userID);
                    statement.setInt(i++, historyID);
                    return false;
                }
            }, null, null);
        }
        catch (Exception ex) {
            String errMsg = "error inserting user history object";
            VM.log(CLASS, 0, errMsg, ex);
            throw new CMException(1120, errMsg, (Throwable)ex);
        }
    }

    @Override
    public void removeUserHistory(final int historyID) throws CMException {
        try {
            this.database.executeUpdate(DELETE, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setInt(i++, historyID);
                    return false;
                }
            }, null, null);
        }
        catch (Exception ex) {
            String errMsg = "error removing user history object";
            VM.log(CLASS, 0, errMsg, ex);
            throw new CMException(1120, errMsg, (Throwable)ex);
        }
    }

    @Override
    public void insertHistoryUsers(int[] userIDs, int historyID) throws CMException {
        for (int i = 0; i < userIDs.length; ++i) {
            this.insertUserHistory(userIDs[i], historyID);
        }
    }
}

