/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.database;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.database.DefaultPreparedStatementParameterizer;
import com.cognos.mobile.database.IResultSetAccumulator;
import com.cognos.mobile.database.ISQLDatabase;
import com.cognos.mobile.database.IUserPortalItemDAO;
import com.cognos.mobile.vm.VM;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;

public class SQLUserPortalItemDAO
implements IUserPortalItemDAO {
    private static final Class CLASS = SQLUserPortalItemDAO.class;
    private final ISQLDatabase database;
    private static final String SQL_INSERT = "INSERT INTO MOB_USER_PORTALITEM (USER_ID, PORTALITEM_ID, USER_PORTALITEM_TYPE) VALUES(?, ?, ?)";
    private static final String SQL_DELETE = "DELETE FROM MOB_USER_PORTALITEM WHERE USER_ID=? AND PORTALITEM_ID=? AND USER_PORTALITEM_TYPE=?";
    private static final String SQL_SELECT_PORTALITEM_ID = "SELECT PORTALITEM_ID from MOB_USER_PORTALITEM WHERE USER_ID=? AND USER_PORTALITEM_TYPE=?";
    private static final String SQL_UPDATE_PORTALITEM_ID = "UPDATE MOB_USER_PORTALITEM SET PORTALITEM_ID=? WHERE USER_ID=? AND USER_PORTALITEM_TYPE=?";

    public SQLUserPortalItemDAO(ISQLDatabase database) {
        this.database = database;
    }

    @Override
    public void insert(final int userId, final int portalItemId, final int userPortalItemType) throws CMException {
        try {
            this.database.executeUpdate(SQL_INSERT, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setInt(i++, userId);
                    statement.setInt(i++, portalItemId);
                    statement.setInt(i++, userPortalItemType);
                    return false;
                }
            }, null, null);
        }
        catch (Exception ex) {
            String details = "Error inserting";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1121, details, (Throwable)ex);
        }
    }

    @Override
    public void update(final int userId, final int portalItemId, final int userPortalItemType) throws CMException {
        try {
            this.database.executeUpdate(SQL_UPDATE_PORTALITEM_ID, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setInt(i++, portalItemId);
                    statement.setInt(i++, userId);
                    statement.setInt(i++, userPortalItemType);
                    return false;
                }
            }, null, null);
        }
        catch (Exception ex) {
            String details = "Error inserting";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1121, details, (Throwable)ex);
        }
    }

    @Override
    public void delete(final int userId, final int portalItemId, final int userPortalItemType) throws CMException {
        try {
            this.database.executeUpdate(SQL_DELETE, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setInt(i++, userId);
                    statement.setInt(i++, portalItemId);
                    statement.setInt(i++, userPortalItemType);
                    return false;
                }
            }, null, null);
        }
        catch (Exception ex) {
            String details = "Error deleting";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1121, details, (Throwable)ex);
        }
    }

    @Override
    public int getPortalItemID(final int userId, final int userPortalItemType) throws CMException {
        try {
            final ArrayList l = new ArrayList(1);
            this.database.executeQuery(SQL_SELECT_PORTALITEM_ID, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setInt(i++, userId);
                    statement.setInt(i++, userPortalItemType);
                    return false;
                }
            }, new IResultSetAccumulator(){

                @Override
                public IResultSetAccumulator.Action accumulate(ResultSet resultSet) throws Exception {
                    int i = 1;
                    l.add(new Integer(resultSet.getInt(i++)));
                    return IResultSetAccumulator.STOP;
                }
            });
            if (l.size() == 0) {
                return -1;
            }
            Integer portalItemID = (Integer)l.get(0);
            return portalItemID;
        }
        catch (Exception ex) {
            String details = "Error deleting";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1121, details, (Throwable)ex);
        }
    }
}

