/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.database;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.database.DefaultPreparedStatementParameterizer;
import com.cognos.mobile.database.IResultSetAccumulator;
import com.cognos.mobile.database.ISQLDatabase;
import com.cognos.mobile.database.IUserRenderDAO;
import com.cognos.mobile.vm.VM;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Date;

public class SQLUserRenderDAO
implements IUserRenderDAO {
    private static final Class CLASS = SQLUserRenderDAO.class;
    private final ISQLDatabase database;
    private static final String SQL_ADD_NAME = "UPDATE MOB_USER_RENDER SET NAME=? WHERE USER_ID=? AND RENDER_ID=?";
    private static final String SQL_SET_LAST_VIEWED_TIME = "UPDATE MOB_USER_RENDER SET LAST_VIEWED=? WHERE USER_ID=? AND RENDER_ID=?";
    private static final String SQL_INSERT = "INSERT INTO MOB_USER_RENDER (USER_ID, RENDER_ID) VALUES(?, ?)";
    private static final String SQL_DELETE = "DELETE FROM MOB_USER_RENDER WHERE USER_ID=? AND RENDER_ID=?";
    private static final String SQL_USER_COUNT = "SELECT COUNT(USER_ID) FROM MOB_USER_RENDER WHERE RENDER_ID=?";

    public SQLUserRenderDAO(ISQLDatabase database) {
        this.database = database;
    }

    @Override
    public void insert(final int userId, final int renderId) throws CMException {
        try {
            this.database.executeUpdate(SQL_INSERT, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setInt(i++, userId);
                    statement.setInt(i++, renderId);
                    return false;
                }
            }, null, null);
        }
        catch (Exception ex) {
            String details = "Error inserting";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1121, details, (Throwable)ex);
        }
    }

    @Override
    public void addName(final String saveName, final int userId, final int renderId) throws CMException {
        try {
            this.database.executeUpdate(SQL_ADD_NAME, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setString(i++, saveName);
                    statement.setInt(i++, userId);
                    statement.setInt(i++, renderId);
                    return false;
                }
            }, null, null);
        }
        catch (Exception ex) {
            String details = "Error adding save name";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1121, details, (Throwable)ex);
        }
    }

    @Override
    public void setLastViewed(final int userId, final int renderId) throws CMException {
        try {
            this.database.executeUpdate(SQL_SET_LAST_VIEWED_TIME, new DefaultPreparedStatementParameterizer(){
                Date timeStamp = new Date();

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setTimestamp(i++, new Timestamp(this.timeStamp.getTime()));
                    statement.setInt(i++, userId);
                    statement.setInt(i++, renderId);
                    return false;
                }
            }, null, null);
        }
        catch (Exception ex) {
            String details = "Error setting viewed time";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1121, details, (Throwable)ex);
        }
    }

    @Override
    public void delete(final int userId, final int renderId) throws CMException {
        try {
            this.database.executeCommittedUpdate(SQL_DELETE, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setInt(i++, userId);
                    statement.setInt(i++, renderId);
                    return false;
                }
            }, null, null);
        }
        catch (Exception ex) {
            String details = "Error deleting";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1121, details, (Throwable)ex);
        }
    }

    @Override
    public int getUserCount(final int renderId) throws CMException {
        final int[] count = new int[]{-1};
        final boolean[] processed = new boolean[]{false};
        IResultSetAccumulator accumulator = new IResultSetAccumulator(){

            @Override
            public IResultSetAccumulator.Action accumulate(ResultSet resultSet) throws Exception {
                count[0] = resultSet.getInt(1);
                processed[0] = true;
                return IResultSetAccumulator.STOP;
            }
        };
        try {
            this.database.executeQuery(SQL_USER_COUNT, new DefaultPreparedStatementParameterizer(){

                @Override
                public boolean parameterize(PreparedStatement statement) throws Exception {
                    int i = 1;
                    statement.setInt(i++, renderId);
                    return false;
                }
            }, accumulator);
            if (!processed[0]) {
                String details = "failed to read count of users for render:" + renderId;
                VM.log(CLASS, 0, details);
                throw new CMException(1120, details);
            }
            return count[0];
        }
        catch (Exception ex) {
            String details = "failed to read user count for render:" + renderId;
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1120, details, (Throwable)ex);
        }
    }
}

