/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.database;

import com.cognos.mobile.common.CMStringHelper;

public class SchemaVersion {
    private int major;
    private int minor;
    private String subminor;
    public static final String NEW = "NEW";

    public SchemaVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
        this.subminor = "";
    }

    public SchemaVersion(int major, int minor, String subminor) {
        this.major = major;
        this.minor = minor;
        this.subminor = subminor == null ? "" : subminor;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public String getSubminor() {
        return this.subminor;
    }

    public int compareTo(Object o) {
        if (o instanceof SchemaVersion) {
            SchemaVersion rhs = (SchemaVersion)o;
            if (this.major < rhs.major) {
                return -1;
            }
            if (this.major == rhs.major) {
                if (this.minor < rhs.minor) {
                    return -1;
                }
                if (this.minor == rhs.minor) {
                    if (this.subminor.equals(NEW)) {
                        return -1;
                    }
                    if (this.subminor.compareTo(rhs.subminor) < 0) {
                        return -1;
                    }
                    if (this.subminor.compareTo(rhs.subminor) == 0) {
                        return 0;
                    }
                    return 1;
                }
                return 1;
            }
            return 1;
        }
        return -1;
    }

    public boolean equals(Object rhs) {
        if (rhs instanceof SchemaVersion) {
            SchemaVersion rhsSV = (SchemaVersion)rhs;
            return this.major == rhsSV.major && this.minor == rhsSV.minor && this.subminor.equals(rhsSV.subminor);
        }
        return false;
    }

    public String toString() {
        char[] rep = new char[]{'x', 'x', '-', 'x', 'x', 'x'};
        CMStringHelper.formatZeroPadNumber(this.major, rep, 0, 2);
        CMStringHelper.formatZeroPadNumber(this.minor, rep, 3, 3);
        return new String(rep) + this.subminor;
    }

    public static SchemaVersion parse(String rep) {
        if (rep != null && rep.length() == 6) {
            if (Character.isDigit(rep.charAt(0)) && Character.isDigit(rep.charAt(1)) && rep.charAt(2) == '-' && Character.isDigit(rep.charAt(3)) && Character.isDigit(rep.charAt(4)) && Character.isDigit(rep.charAt(5))) {
                int major = (rep.charAt(0) - 48) * 10 + rep.charAt(1) - 48;
                int minor = (rep.charAt(3) - 48) * 100 + (rep.charAt(4) - 48) * 10 + rep.charAt(5) - 48;
                return new SchemaVersion(major, minor);
            }
        } else if (rep != null && rep.length() == 7 && Character.isDigit(rep.charAt(0)) && Character.isDigit(rep.charAt(1)) && rep.charAt(2) == '-' && Character.isDigit(rep.charAt(3)) && Character.isDigit(rep.charAt(4)) && Character.isDigit(rep.charAt(5)) && Character.isLetter(rep.charAt(6))) {
            int major = (rep.charAt(0) - 48) * 10 + rep.charAt(1) - 48;
            int minor = (rep.charAt(3) - 48) * 100 + (rep.charAt(4) - 48) * 10 + rep.charAt(5) - 48;
            String subminor = rep.charAt(6) + "";
            return new SchemaVersion(major, minor, subminor);
        }
        return null;
    }
}

