/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.database.internal.schemaupgraders;

import com.cognos.mobile.database.SchemaVersion;
import com.cognos.mobile.database.internal.schemaupgraders.UpgraderStep;
import java.util.ArrayList;
import java.util.ListIterator;

class SchemaUpgradeStepSelector {
    private ArrayList<UpgraderStep> steps;

    public SchemaUpgradeStepSelector(ArrayList<UpgraderStep> upgraderSteps) {
        this.steps = upgraderSteps;
    }

    public UpgraderStep getNextUpgradeScript(SchemaVersion currentVersion) {
        UpgraderStep nextScript = null;
        ListIterator<UpgraderStep> scriptIterator = this.steps.listIterator();
        ArrayList<UpgraderStep> fromMatches = new ArrayList<UpgraderStep>();
        while (scriptIterator.hasNext()) {
            UpgraderStep candidate = scriptIterator.next();
            if (!currentVersion.equals(candidate.getFromSchemaVersion())) continue;
            fromMatches.add(candidate);
        }
        scriptIterator = fromMatches.listIterator();
        while (scriptIterator.hasNext()) {
            UpgraderStep nextCandidate = scriptIterator.next();
            if (nextScript == null) {
                nextScript = nextCandidate;
                continue;
            }
            if (nextScript.getToSchemaVersion().getMajor() < nextCandidate.getToSchemaVersion().getMajor()) {
                nextScript = nextCandidate;
                continue;
            }
            if (nextScript.getToSchemaVersion().compareTo(nextCandidate.getToSchemaVersion()) != 1) continue;
            nextScript = nextCandidate;
        }
        return nextScript;
    }
}

