/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.database.internal.schemaupgraders;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.database.DBSqlServerDatabase;
import com.cognos.mobile.database.ISQLDatabase;
import com.cognos.mobile.database.SchemaVersion;
import com.cognos.mobile.database.internal.schemaupgraders.DatabaseType;
import com.cognos.mobile.database.internal.schemaupgraders.SchemaUpgradeStepSelector;
import com.cognos.mobile.database.internal.schemaupgraders.ScriptEntry;
import com.cognos.mobile.database.internal.schemaupgraders.UpgraderStep;
import com.cognos.mobile.vm.VM;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SchemaUpgrader {
    private static final SchemaUpgrader instance = new SchemaUpgrader();
    private static final Class<SchemaUpgrader> CLASS = SchemaUpgrader.class;
    private static final String SCHEMA_VERSION_TABLE_INIT_FILENAME = "initialize-schema-version-table.sql";
    private static final String SCHEMA_VERSION_TABLE_UPDATE_FILENAME = "update-schema-version-table.sql";
    public static final SchemaVersion CURRENT_SCHEMA_VERSION = new SchemaVersion(7, 0);
    private Exception execException = null;

    public static void singletonUpgradeIfNecessary(ISQLDatabase database, String scriptDir, Connection cxn) throws CMException {
        instance.upgradeIfNecessary(database, scriptDir, cxn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void upgradeIfNecessary(ISQLDatabase database, String scriptDir, Connection lockConnection) throws CMException {
        String msg;
        ResultSet lockResultSet;
        Statement lockStatement;
        int compareSchemaVersion;
        SchemaVersion databaseVersion;
        String username;
        Connection outerLockConnection;
        block60: {
            int retry;
            boolean locked;
            block64: {
                block61: {
                    outerLockConnection = null;
                    username = database.getUsername();
                    databaseVersion = database.getSchemaVersion(username);
                    compareSchemaVersion = databaseVersion.compareTo(CURRENT_SCHEMA_VERSION);
                    lockStatement = null;
                    lockResultSet = null;
                    if (compareSchemaVersion != -1) break block60;
                    locked = false;
                    retry = 0;
                    if (databaseVersion.getMajor() == 0 && databaseVersion.getMinor() == 0) {
                        this.createSchemaVersionTable(database, scriptDir);
                    } else if (databaseVersion.getSubminor().equals("NEW")) {
                        this.updateSchemaVersionTable(database, scriptDir);
                    }
                    if (!this.isDB2zOS(database)) break block64;
                    this.createDB2zLockObjects(database, scriptDir);
                    outerLockConnection = database.getTransactionConnection();
                    outerLockConnection.createStatement().execute("LOCK TABLE LOCK_FOR_UPGRADE IN EXCLUSIVE MODE");
                    lockConnection.setAutoCommit(false);
                    databaseVersion = database.getSchemaVersion(lockConnection, username);
                    compareSchemaVersion = databaseVersion.compareTo(CURRENT_SCHEMA_VERSION);
                    lockConnection.createStatement().execute("LOCK TABLE MOB_SCHEMA_VERSION IN EXCLUSIVE MODE");
                    if (compareSchemaVersion == -1) break block60;
                    if (lockConnection == null) break block61;
                    try {
                        lockConnection.commit();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.closeLockResources(lockResultSet, lockStatement, lockConnection);
                if (outerLockConnection != null) {
                    try {
                        outerLockConnection.commit();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    database.releaseTransactionConnection(outerLockConnection);
                }
                break block60;
                catch (Exception se) {
                    try {
                        String msg2 = "execution of LOCK TABLE MOB_SCHEMA_VERSION IN EXCLUSIVE MODE failed; aborting";
                        VM.log(CLASS, 3, msg2, se);
                        throw new CMException(1148, msg2, (Throwable)se);
                    }
                    catch (Throwable throwable) {
                        if (compareSchemaVersion != -1) {
                            if (lockConnection != null) {
                                try {
                                    lockConnection.commit();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            this.closeLockResources(lockResultSet, lockStatement, lockConnection);
                            if (outerLockConnection != null) {
                                try {
                                    outerLockConnection.commit();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                database.releaseTransactionConnection(outerLockConnection);
                            }
                        }
                        throw throwable;
                    }
                }
            }
            while (!locked) {
                block62: {
                    lockConnection.setAutoCommit(false);
                    if (lockConnection.getMetaData().supportsTransactionIsolationLevel(8) && database.getDatabaseType() != 2) {
                        lockConnection.setTransactionIsolation(8);
                    } else if (lockConnection.getMetaData().supportsTransactionIsolationLevel(4)) {
                        lockConnection.setTransactionIsolation(4);
                    } else if (lockConnection.getMetaData().supportsTransactionIsolationLevel(2)) {
                        lockConnection.setTransactionIsolation(2);
                    }
                    if (database.getDatabaseType() != 2) {
                        lockConnection.setHoldability(2);
                    }
                    int resultSetType2333333332 = 1005;
                    if (database.getDatabaseType() == 10) {
                        resultSetType2333333332 = 1003;
                    }
                    lockStatement = lockConnection.createStatement(resultSetType2333333332, 1008);
                    String sql = "SELECT MAJOR, MINOR, SUBMINOR FROM MOB_SCHEMA_VERSION";
                    sql = database instanceof DBSqlServerDatabase ? sql + " WITH (XLOCK)" : sql + " FOR UPDATE";
                    lockResultSet = lockStatement.executeQuery(sql);
                    if (lockResultSet.next()) {
                        int major = lockResultSet.getInt(1);
                        int minor = lockResultSet.getInt(2);
                        String subminor = lockResultSet.getString(3);
                        databaseVersion = new SchemaVersion(major, minor, subminor);
                        compareSchemaVersion = databaseVersion.compareTo(CURRENT_SCHEMA_VERSION);
                        locked = true;
                    }
                    if (compareSchemaVersion == -1) continue;
                    if (lockConnection == null) break block62;
                    try {
                        lockConnection.commit();
                    }
                    catch (Exception resultSetType2333333332) {
                        // empty catch block
                    }
                }
                this.closeLockResources(lockResultSet, lockStatement, lockConnection);
                continue;
                catch (Exception se222222222) {
                    block63: {
                        try {
                            this.closeLockResources(lockResultSet, lockStatement, lockConnection);
                            if (++retry >= 3) {
                                msg = "execution of select for update query to lock version table failed after 3 attempts; aborting";
                                VM.log(CLASS, 3, msg, se222222222);
                                throw new CMException(1148, msg, (Throwable)se222222222);
                            }
                            msg = "execution of select for update query to lock version table failed; retry again in 5 seconds";
                            VM.log(CLASS, 2, msg, se222222222);
                            try {
                                Thread.sleep(5000L);
                            }
                            catch (InterruptedException major) {
                                // empty catch block
                            }
                            if (compareSchemaVersion == -1) continue;
                            if (lockConnection == null) break block63;
                        }
                        catch (Throwable throwable) {
                            if (compareSchemaVersion != -1) {
                                if (lockConnection != null) {
                                    try {
                                        lockConnection.commit();
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                this.closeLockResources(lockResultSet, lockStatement, lockConnection);
                            }
                            throw throwable;
                        }
                        try {
                            lockConnection.commit();
                        }
                        catch (Exception se222222222) {
                            // empty catch block
                        }
                    }
                    this.closeLockResources(lockResultSet, lockStatement, lockConnection);
                }
            }
        }
        switch (compareSchemaVersion) {
            case -1: {
                ArrayList<UpgraderStep> scripts = this.getUpgradeScriptsList(scriptDir);
                SchemaUpgradeStepSelector scriptSelector = new SchemaUpgradeStepSelector(scripts);
                UpgraderStep upgraderStep = null;
                databaseVersion = database.getSchemaVersion(lockConnection, username);
                while (!databaseVersion.equals(CURRENT_SCHEMA_VERSION)) {
                    try {
                        upgraderStep = this.getNextUpgradeStep(scriptDir, databaseVersion, scriptSelector);
                        upgraderStep.execute(database, lockConnection);
                        database.updateSchemaVersion(lockConnection, upgraderStep.getToSchemaVersion());
                        if (this.isDB2zOS(database)) {
                            lockConnection.commit();
                            lockConnection.createStatement().execute("LOCK TABLE MOB_SCHEMA_VERSION IN EXCLUSIVE MODE");
                        }
                        databaseVersion = database.getSchemaVersion(lockConnection, username);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new CMException(1148, "Failed to upgrade " + upgraderStep.toString(), (Throwable)e);
                    }
                }
                try {
                    lockConnection.commit();
                    if (this.isDB2zOS(database)) {
                        outerLockConnection.commit();
                    }
                    msg = "updated MOB_SCHEMA_VERSION table to " + upgraderStep.getToSchemaVersion().toString();
                    if (upgraderStep.getToSchemaVersion().getMajor() != CURRENT_SCHEMA_VERSION.getMajor() || upgraderStep.getToSchemaVersion().getMinor() != CURRENT_SCHEMA_VERSION.getMinor()) {
                        msg = msg + "; Failed to complete upgrade to current version.";
                        VM.log(CLASS, 3, msg);
                        if (this.execException != null) {
                            throw this.execException;
                        }
                        throw new CMException(1148, msg);
                    }
                    VM.log(CLASS, 1, msg);
                    this.closeLockResources(lockResultSet, lockStatement, lockConnection);
                    if (!this.isDB2zOS(database)) break;
                    database.releaseTransactionConnection(outerLockConnection);
                    break;
                }
                catch (Exception e) {
                    try {
                        String msg3 = "couldn't update MOB_SCHEMA_VERSION table to current version";
                        VM.log(CLASS, 3, msg3, e);
                        throw new CMException(1148, msg3, (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        this.closeLockResources(lockResultSet, lockStatement, lockConnection);
                        if (this.isDB2zOS(database)) {
                            database.releaseTransactionConnection(outerLockConnection);
                        }
                        throw throwable;
                    }
                }
            }
            case 0: {
                VM.log(CLASS, 1, "DB schema is " + databaseVersion + "; don't need to upgrade");
                break;
            }
            case 1: {
                VM.log(CLASS, 3, "database schema version is " + databaseVersion + "; code version is " + CURRENT_SCHEMA_VERSION + "; database is more recent, aborting");
                throw new CMException(1166);
            }
        }
    }

    private boolean isDB2zOS(ISQLDatabase database) {
        return DatabaseType.isDB2zOS(database);
    }

    private void createSchemaVersionTable(ISQLDatabase database, String scriptDir) {
        try {
            File dir = new File(scriptDir);
            VM.log(CLASS, 1, "looking for database MOB_SCHEMA_VERSION initialization script in '" + dir.getAbsolutePath() + "'  ");
            File script = new File(dir, SCHEMA_VERSION_TABLE_INIT_FILENAME);
            if (script != null && script.isFile()) {
                database.executeScript(script);
            }
        }
        catch (Exception e) {
            String msg = "WARNING: execution schema version table creation script failed; continue on path to attempt update.";
            VM.log(CLASS, 1, msg);
        }
    }

    private void updateSchemaVersionTable(ISQLDatabase database, String scriptDir) {
        try {
            File dir = new File(scriptDir);
            VM.log(CLASS, 1, "looking for database MOB_SCHEMA_VERSION update script in '" + dir.getAbsolutePath() + "'  ");
            File script = new File(dir, SCHEMA_VERSION_TABLE_UPDATE_FILENAME);
            if (script != null && script.isFile()) {
                database.executeScript(script);
            }
        }
        catch (Exception e) {
            String msg = "WARNING: execution schema version table update script failed; continue on path to attempt update.";
            VM.log(CLASS, 1, msg);
        }
    }

    private void createDB2zLockObjects(ISQLDatabase database, String scriptDir) {
        try {
            File dir = new File(scriptDir);
            VM.log(CLASS, 1, "looking for database upgrade lock initialization script in '" + dir.getAbsolutePath() + "'  ");
            File script = new File(dir, "upgrade-lock-object-init.sql");
            if (script != null && script.isFile()) {
                database.executeScript(script);
            }
        }
        catch (Exception e) {
            String msg = "WARNING: execution upgrade lock objects script failed; continue on path to attempt update.";
            VM.log(CLASS, 1, msg);
        }
    }

    protected ArrayList<UpgraderStep> getUpgradeScriptsList(String scriptDir) throws CMException {
        File dir = new File(scriptDir);
        VM.log(CLASS, 1, "looking for database upgrade scripts in '" + dir.getAbsolutePath() + "'");
        String[] files = dir.list();
        ArrayList<UpgraderStep> scripts = new ArrayList<UpgraderStep>();
        if (files != null) {
            Pattern re = Pattern.compile("^upgrade-(\\d{2}-\\d{3}\\w{0,1})-to-(\\d{2}-\\d{3}\\w{0,1}).sql$");
            for (int i = 0; i < files.length; ++i) {
                Matcher m;
                File script = new File(dir, files[i]);
                if (!script.isFile() || !(m = re.matcher(script.getName())).matches()) continue;
                String fromSchemaString = m.group(1);
                SchemaVersion from = SchemaVersion.parse(fromSchemaString);
                String toSchemaString = m.group(2);
                SchemaVersion to = SchemaVersion.parse(toSchemaString);
                if (from == null || to == null) continue;
                boolean majorEqual = from.getMajor() == to.getMajor();
                boolean minorEqual = from.getMinor() == to.getMinor();
                boolean minorGreaterEq = from.getMinor() >= to.getMinor();
                int subminorCompare = from.getSubminor().compareTo(to.getSubminor());
                boolean subminorFromEmpty = from.getSubminor().equals("");
                boolean subminorToEmpty = to.getSubminor().equals("");
                if (majorEqual && minorEqual && (subminorCompare >= 0 || !subminorFromEmpty && subminorToEmpty) || majorEqual && minorGreaterEq && subminorCompare == 0) {
                    String msg = "script name indicates illegal upgrade path: '" + script.getAbsolutePath() + "'";
                    VM.log(CLASS, 0, msg);
                    throw new CMException(1148, msg);
                }
                VM.log(CLASS, 0, "Found '" + script.getName() + "' to go from " + from.toString() + " to " + to.toString());
                scripts.add(new ScriptEntry(from, to, script));
            }
        }
        return scripts;
    }

    protected UpgraderStep getNextUpgradeStep(String scriptDir, SchemaVersion databaseVersion, SchemaUpgradeStepSelector stepSelector) throws CMException {
        UpgraderStep nextStep = stepSelector.getNextUpgradeScript(databaseVersion);
        if (nextStep == null) {
            StringBuffer sb = new StringBuffer();
            sb.append("couldn't find the next step  to upgrade from ");
            sb.append(databaseVersion.toString());
            sb.append(" to ");
            sb.append(CURRENT_SCHEMA_VERSION.toString());
            sb.append(" from scripts in ");
            sb.append(scriptDir);
            VM.log(CLASS, 3, sb.toString());
            throw new CMException(1148, sb.toString());
        }
        return nextStep;
    }

    protected void updateDatabaseVersion(ISQLDatabase database, Connection connection, ScriptEntry entry) throws CMException {
        try {
            database.updateSchemaVersion(connection, entry.getToSchemaVersion().getMajor(), entry.getToSchemaVersion().getMinor(), entry.getToSchemaVersion().getSubminor());
            VM.log(CLASS, 1, "updated MOB_SCHEMA_VERSION table to " + entry.getToSchemaVersion().toString());
        }
        catch (CMException e) {
            String msg = "couldn't update MOB_SCHEMA_VERSION table";
            VM.log(CLASS, 3, msg, e);
            throw new CMException(1148, msg, (Throwable)e);
        }
    }

    private void closeLockResources(ResultSet lockResultSet, Statement lockStatement, Connection lockConnection) {
        if (lockResultSet != null) {
            try {
                lockResultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (lockStatement != null) {
            try {
                lockStatement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (lockConnection != null) {
            try {
                lockConnection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

