/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.database.internal.schemaupgraders;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.database.ISQLDatabase;
import com.cognos.mobile.database.SchemaVersion;
import com.cognos.mobile.database.internal.schemaupgraders.DatabaseType;
import com.cognos.mobile.database.internal.schemaupgraders.UpgraderStep;
import com.cognos.mobile.vm.VM;
import java.io.File;
import java.sql.Connection;

public class ScriptEntry
implements UpgraderStep {
    private static Class CLASS = ScriptEntry.class;
    private final SchemaVersion from;
    private final SchemaVersion to;
    private final File script;

    public ScriptEntry(SchemaVersion from, SchemaVersion to, File script) {
        this.from = from;
        this.to = to;
        this.script = script;
    }

    @Override
    public SchemaVersion getFromSchemaVersion() {
        return this.from;
    }

    @Override
    public SchemaVersion getToSchemaVersion() {
        return this.to;
    }

    public File getScript() {
        return this.script;
    }

    private boolean useTransaction(ISQLDatabase database) {
        return database.getDatabaseType() == 6 || database.getDatabaseType() == 8 || DatabaseType.isDB2zOS(database);
    }

    @Override
    public void execute(ISQLDatabase database, Connection transactionConnection) throws CMException {
        File scriptFile = this.getScript();
        String scriptFilePath = scriptFile.getAbsolutePath();
        try {
            if (this.useTransaction(database)) {
                database.executeScript(scriptFile, transactionConnection);
            } else {
                database.executeScript(scriptFile);
            }
            VM.log(CLASS, 1, "executed script '" + scriptFilePath + "' successfully");
        }
        catch (CMException e) {
            String msg = "execution of script '" + scriptFilePath + "' failed";
            VM.log(CLASS, 3, msg, e);
            throw new CMException(1148, msg, (Throwable)e);
        }
    }
}

