/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.drill;

import com.cognos.mobile.common.CMLinkedHashtable;
import com.cognos.mobile.drill.DrillContextParam;
import com.cognos.mobile.xml.XMLHelper;
import java.util.Enumeration;
import java.util.Vector;

public class DrillContext {
    private int widgetID = -1;
    private int m_drillIndex = -1;
    private Vector m_parameters = new Vector();
    private final int MAX_SIGNATURE_LEN_IN_TABLE = 1000;

    public void addParameter(String name, String value) {
        this.addParameter(new DrillContextParam(name, value));
    }

    public void addParameter(DrillContextParam parameter) {
        this.m_parameters.addElement(parameter);
    }

    public void setParameterMun(String mun) {
        int size = this.m_parameters.size();
        if (size != 0) {
            DrillContextParam parameter = (DrillContextParam)this.m_parameters.elementAt(size - 1);
            parameter.setMun(mun);
        }
    }

    public void setDrillIndex(int index) {
        this.m_drillIndex = index;
    }

    public int getDrillIndex() {
        return this.m_drillIndex;
    }

    public Vector getParameters() {
        return this.m_parameters;
    }

    public String generateDrillParamsString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.m_parameters.size(); ++i) {
            DrillContextParam param = (DrillContextParam)this.m_parameters.elementAt(i);
            sb.append(param.getName());
            sb.append("=");
            if (param.getValue() != null) {
                sb.append(param.getValue());
            } else if (param.getSelections() != null) {
                CMLinkedHashtable selections = param.getSelections();
                Enumeration keys = selections.keys();
                while (keys.hasMoreElements()) {
                    String dispVal = (String)keys.nextElement();
                    String useVal = (String)selections.get(dispVal);
                    sb.append(dispVal).append(":").append(useVal).append("|");
                }
            }
            sb.append(";");
        }
        String result = sb.toString();
        return result.length() <= 1000 ? result : result.substring(0, 1000);
    }

    public String toXML() {
        StringBuffer sb = new StringBuffer();
        sb.append(XMLHelper.openTag("DrillContext"));
        sb.append(XMLHelper.openTag("DrillIndex"));
        sb.append(this.m_drillIndex);
        sb.append(XMLHelper.closeTag("DrillIndex"));
        for (int i = 0; i < this.m_parameters.size(); ++i) {
            DrillContextParam param = (DrillContextParam)this.m_parameters.elementAt(i);
            sb.append(XMLHelper.openTag("Parameter"));
            sb.append(XMLHelper.openTag("name"));
            sb.append(XMLHelper.encodeXml(param.getName()));
            sb.append(XMLHelper.closeTag("name"));
            sb.append(XMLHelper.openTag("value"));
            sb.append(XMLHelper.encodeXml(param.getValue()));
            sb.append(XMLHelper.closeTag("value"));
            sb.append(XMLHelper.openTag("mun"));
            if (param.getMun() != null) {
                sb.append(XMLHelper.encodeXml(param.getMun()));
            }
            sb.append(XMLHelper.closeTag("mun"));
            sb.append(XMLHelper.closeTag("Parameter"));
        }
        sb.append(XMLHelper.closeTag("DrillContext"));
        return sb.toString();
    }

    public int getWidgetID() {
        return this.widgetID;
    }

    public void setWidgetID(int widgetID) {
        this.widgetID = widgetID;
    }
}

