/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.drill;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.drill.DrillContext;
import com.cognos.mobile.drill.DrillTargetInfo;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.xml.XMLHelper;
import java.util.Vector;

public class DrillHelper {
    private static Class CLASS = DrillHelper.class;
    protected Vector contexts;
    protected Vector drillTargets;

    public DrillHelper() {
        this.contexts = new Vector();
    }

    public DrillHelper(Vector contexts, Vector drillTargets) {
        this.contexts = contexts;
        this.drillTargets = drillTargets;
    }

    public String[] getDrillTargetLabels() throws CMException {
        if (this.contexts.size() == 0) {
            String details = "no drill-through context available";
            VM.log(CLASS, 3, details);
            throw new CMException(2025, details);
        }
        String[] labels = new String[this.contexts.size()];
        Vector drillTargets = this.getTargetsOnWID(this.getContextWID());
        for (int i = 0; i < this.contexts.size(); ++i) {
            DrillContext aContext = (DrillContext)this.contexts.elementAt(i);
            int index = aContext.getDrillIndex();
            if (index < 0 || index >= drillTargets.size()) {
                VM.log(CLASS, 3, "getContextWID:" + this.getContextWID());
                VM.log(CLASS, 3, "this.drillTargetSize" + this.drillTargets.size() + " drillTarget size:" + drillTargets.size());
                String details = "invalid drill through target index: " + index;
                VM.log(CLASS, 3, details);
                throw new CMException(2025, details);
            }
            DrillTargetInfo aTarget = (DrillTargetInfo)drillTargets.elementAt(index);
            if (!aTarget.isValid()) continue;
            labels[i] = aTarget.getLabel();
        }
        return labels;
    }

    public String getSelectedTargetXML(int selectedIndex) throws CMException {
        DrillContext drillContext = (DrillContext)this.contexts.elementAt(selectedIndex);
        int index = drillContext.getDrillIndex();
        Vector drillTargets = this.getTargetsOnWID(this.getContextWID());
        DrillTargetInfo drillTargetInfo = (DrillTargetInfo)drillTargets.elementAt(index);
        if (drillContext != null && drillTargetInfo != null) {
            String context = XMLHelper.openTag("DrillThrough");
            context = context + drillContext.toXML();
            context = context + drillTargetInfo.toXML();
            context = context + XMLHelper.closeTag("DrillThrough");
            return context;
        }
        String details = "either drillContext or drillTargetInfo is null";
        VM.log(CLASS, 3, details);
        throw new CMException(2025, details);
    }

    public String getSelectedTargetCMPath(int selectedIndex) throws CMException {
        DrillContext drillContext = (DrillContext)this.contexts.elementAt(selectedIndex);
        int index = drillContext.getDrillIndex();
        Vector drillTargets = this.getTargetsOnWID(this.getContextWID());
        DrillTargetInfo drillTargetInfo = (DrillTargetInfo)drillTargets.elementAt(index);
        if (drillContext != null && drillTargetInfo != null) {
            return drillTargetInfo.getCMPath();
        }
        String details = "either drillContext or drillTargetInfo is null";
        VM.log(CLASS, 3, details);
        throw new CMException(2025, details);
    }

    public String getSelectedTargetParamString(int selectedIndex) throws CMException {
        DrillContext drillContext = (DrillContext)this.contexts.elementAt(selectedIndex);
        int index = drillContext.getDrillIndex();
        Vector drillTargets = this.getTargetsOnWID(this.getContextWID());
        DrillTargetInfo drillTargetInfo = (DrillTargetInfo)drillTargets.elementAt(index);
        if (drillContext != null && drillTargetInfo != null) {
            return drillContext.generateDrillParamsString();
        }
        String details = "either drillContext or drillTargetInfo is null";
        VM.log(CLASS, 3, details);
        throw new CMException(2025, details);
    }

    public int getContextWID() {
        if (this.contexts.size() != 0) {
            return ((DrillContext)this.contexts.elementAt(0)).getWidgetID();
        }
        return -1;
    }

    private Vector getTargetsOnWID(int wid) {
        if (wid == -1) {
            return this.drillTargets;
        }
        Vector<DrillTargetInfo> result = new Vector<DrillTargetInfo>();
        for (int i = 0; i < this.drillTargets.size(); ++i) {
            DrillTargetInfo aTarget = (DrillTargetInfo)this.drillTargets.elementAt(i);
            if (aTarget.getWidgetID() != wid) continue;
            result.addElement(aTarget);
        }
        return result;
    }

    public int getTargetsOffset(int wid) {
        for (int i = 0; i < this.drillTargets.size(); ++i) {
            DrillTargetInfo aTarget = (DrillTargetInfo)this.drillTargets.elementAt(i);
            if (aTarget.getWidgetID() != wid) continue;
            return i;
        }
        return 0;
    }
}

