/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.drill;

import com.cognos.mobile.drill.DrillTargetParam;
import com.cognos.mobile.xml.XMLHelper;
import java.util.Hashtable;
import java.util.Vector;

public class DrillTargetInfo {
    private String m_targetCMPath = "";
    private String m_targetLabel = "";
    private Vector m_parameters = new Vector();
    private Vector m_searchPathObjects = new Vector();
    private int widgetID = -1;
    private boolean isModelPathSameAsSource = true;

    public boolean isValid() {
        return this.m_targetCMPath != null && this.m_targetCMPath.length() != 0;
    }

    public int getWidgetID() {
        return this.widgetID;
    }

    public void setWidgetID(int widgetID) {
        this.widgetID = widgetID;
    }

    public void addParameter(String name, String type) {
        DrillTargetParam parameter = new DrillTargetParam(name, type);
        this.m_parameters.addElement(parameter);
    }

    public void addSearchPathObject(String objName) {
        this.m_searchPathObjects.addElement(objName);
    }

    public void setCMPath(String cmPath) {
        this.m_targetCMPath = cmPath;
    }

    public String getCMPath() {
        return this.m_targetCMPath;
    }

    public void setLabel(String label) {
        this.m_targetLabel = label;
    }

    public String getLabel() {
        return this.m_targetLabel;
    }

    public Vector getParams() {
        return this.m_parameters;
    }

    public Vector getSearchPathObjects() {
        return this.m_searchPathObjects;
    }

    public String toXML() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append(XMLHelper.openTag("DrillTarget"));
        sb.append(XMLHelper.openTag("cmPath"));
        sb.append(XMLHelper.encodeXml(this.m_targetCMPath));
        sb.append(XMLHelper.closeTag("cmPath"));
        for (i = 0; i < this.m_parameters.size(); ++i) {
            DrillTargetParam param = (DrillTargetParam)this.m_parameters.elementAt(i);
            sb.append(XMLHelper.openTag("Parameter"));
            sb.append(XMLHelper.openTag("name"));
            sb.append(XMLHelper.encodeXml(param.getName()));
            sb.append(XMLHelper.closeTag("name"));
            sb.append(XMLHelper.openTag("type"));
            sb.append(XMLHelper.encodeXml(param.getType()));
            sb.append(XMLHelper.closeTag("type"));
            sb.append(XMLHelper.closeTag("Parameter"));
        }
        for (i = 0; i < this.m_searchPathObjects.size(); ++i) {
            String path = (String)this.m_searchPathObjects.elementAt(i);
            sb.append(XMLHelper.openTag("pathObj"));
            sb.append(XMLHelper.encodeXml(path));
            sb.append(XMLHelper.closeTag("pathObj"));
        }
        sb.append(XMLHelper.closeTag("DrillTarget"));
        return sb.toString();
    }

    public Hashtable buildPamamTypeHash() {
        Hashtable<String, String> hash = new Hashtable<String, String>();
        for (int i = 0; i < this.m_parameters.size(); ++i) {
            DrillTargetParam param = (DrillTargetParam)this.m_parameters.elementAt(i);
            if (param.getName() == null) continue;
            hash.put(param.getName(), param.getType());
        }
        return hash;
    }

    public void setIsModelPathSame(boolean isSame) {
        this.isModelPathSameAsSource = isSame;
    }

    public boolean isModelPathSameAsSource() {
        return this.isModelPathSameAsSource;
    }
}

