/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.event;

import com.cognos.mobile.event.IEvent;
import com.cognos.mobile.vm.VM;

public class Event
implements IEvent {
    private static final Class CLASS = Event.class;
    private static final String[] EVENT_CODE_DESCRIPTIONS = new String[]{"CODE_NULL", "CODE_FONT_CHANGE", "CODE_PAGE_CHANGE", "CODE_INBOX_LOADED", "CODE_SEARCH_DONE", "CODE_SYNCHRONIZING_STATE_CHANGED", "CODE_CONNECTION_STATE_CHANGED", "CODE_INBOX_VIEW_CHANGED", "CODE_SETTINGS_CHANGED", "CONTEXT_UNREGISTERED", "CODE_AUTHENTICATION_STATE_CHANGED", "CODE_OPTIONS_CHANGED", "CODE_SCHEDULE_CHANGED", "CODE_INBOX_NEEDS_REPAINT", "CONTEXT_REGISTERED", "CODE_DETAIL", "CODE_FIRST_SYNCHRONIZATION_STARTED", "CODE_FAVOURITES_CHANGED", "CODE_WELCOME_CHANGED"};
    private final Object source;
    private final int code;
    private final Object argument;

    public Event(Object source, int code) {
        this(source, code, null);
    }

    public Event(Object source, int code, Object argument) {
        if (code < EVENT_CODE_DESCRIPTIONS.length) {
            VM.log(CLASS, 0, "Creating Event: " + EVENT_CODE_DESCRIPTIONS[code] + " from " + (source == null ? "" : source));
        }
        this.source = source;
        this.code = code;
        this.argument = argument;
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public Object getArgument() {
        return this.argument;
    }

    public String toString() {
        return "(source " + (this.getSource() == null ? "null" : this.getSource().toString()) + ", desc " + EVENT_CODE_DESCRIPTIONS[this.getCode()] + ", code " + this.getCode() + (this.getArgument() == null ? "" : ", arg " + this.getArgument()) + ")";
    }
}

