/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.generator;

import com.cognos.mobile.compiler.ReportCompiler;
import com.cognos.mobile.drill.DrillTargetInfo;
import com.cognos.mobile.drill.DrillTargetParam;
import com.cognos.mobile.generator.Area;
import com.cognos.mobile.generator.DocumentBase;
import com.cognos.mobile.generator.Element;
import com.cognos.mobile.generator.IDocument;
import com.cognos.mobile.generator.IElement;
import com.cognos.mobile.generator.IElementFactory;
import com.cognos.mobile.generator.IGenerator;
import com.cognos.mobile.generator.IGenericElement;
import com.cognos.mobile.generator.IGenericStyle;
import com.cognos.mobile.generator.IStyle;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Vector;

public abstract class Document
extends DocumentBase {
    private static Class CLASS = Document.class;
    private final IDocument containerDoc;
    private final IElementFactory m_reportElementFactory;
    private Vector m_namedStyles;
    private Hashtable m_namedStyleFingerprints;
    private Hashtable m_namedStyleMap;
    private Vector m_pages;
    private Vector m_drillElements;
    private Vector m_drillTargets;
    private IElement m_drillElement;
    private boolean isMUNUsed;
    private boolean hasUnsupportedDrillType;

    public Document(String outputType, IDocument containerDoc, ReportCompiler reportCompiler) {
        super(reportCompiler);
        this.containerDoc = containerDoc;
        this.m_reportElementFactory = ReportCompiler.createReportElementFactory(this, outputType);
        this.m_namedStyles = new Vector();
        this.m_namedStyleFingerprints = new Hashtable();
        this.m_namedStyleMap = new Hashtable();
        this.m_pages = new Vector();
        this.m_drillElements = new Vector();
        this.m_drillTargets = new Vector();
        this.isMUNUsed = false;
        this.hasUnsupportedDrillType = false;
    }

    @Override
    public void setIsMUNUsed(boolean isOLAP) {
        this.isMUNUsed = isOLAP;
    }

    @Override
    public boolean isMemberUniqueNameUsed() {
        if (this.isMUNUsed) {
            return true;
        }
        Vector targets = this.getDrillTargets();
        if (targets != null) {
            for (int i = 0; i < targets.size(); ++i) {
                DrillTargetInfo target = (DrillTargetInfo)targets.elementAt(i);
                Vector drillParams = target.getParams();
                for (int j = 0; j < drillParams.size(); ++j) {
                    DrillTargetParam param = (DrillTargetParam)drillParams.elementAt(j);
                    String type = param.getType();
                    if (!"memberUniqueName".equalsIgnoreCase(type)) continue;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean compareDrillthroughModelPath(String sourceModelPath, Hashtable targetModelPaths) {
        Vector targets = this.getDrillTargets();
        boolean misMatchFound = false;
        if (targets != null) {
            for (int i = 0; i < targets.size(); ++i) {
                DrillTargetInfo target = (DrillTargetInfo)targets.elementAt(i);
                String targetCMPath = target.getCMPath();
                boolean match = false;
                String targetModelPath = (String)targetModelPaths.get(targetCMPath);
                if (targetModelPath != null && targetModelPath.equalsIgnoreCase(sourceModelPath)) {
                    match = true;
                }
                target.setIsModelPathSame(match);
                if (match) continue;
                misMatchFound = true;
            }
        }
        return misMatchFound;
    }

    @Override
    public void getDrillTargetCMPaths(Hashtable hashtable) {
        Vector targets = this.getDrillTargets();
        if (targets != null) {
            for (int i = 0; i < targets.size(); ++i) {
                DrillTargetInfo target = (DrillTargetInfo)targets.elementAt(i);
                String cmPath = target.getCMPath();
                if (hashtable.contains(cmPath)) continue;
                hashtable.put(cmPath, cmPath);
            }
        }
    }

    @Override
    public void setUnsupportedDrillFlag(boolean flag) {
        this.hasUnsupportedDrillType = flag;
    }

    public boolean hasUnsupportedDrillFlag() {
        return this.hasUnsupportedDrillType;
    }

    public void addPageElement(IElement pageElement) {
        if (pageElement != null) {
            this.m_pages.add(pageElement);
        }
    }

    public IElement getPageElement() {
        if (this.m_pages.size() == 1) {
            return (IElement)this.m_pages.elementAt(0);
        }
        return (IElement)this.m_pages.elementAt(this.containerDoc.getPageIndex());
    }

    @Override
    public IElement getPageElement(int pageIndex) {
        if (this.m_pages.size() == 1) {
            return (IElement)this.m_pages.elementAt(0);
        }
        return (IElement)this.m_pages.elementAt(pageIndex);
    }

    @Override
    public int getPageCount() {
        return this.m_pages.size();
    }

    public void generateDrills(IGenerator generator, PrintStream out) {
        for (int i = 0; i < this.m_drillElements.size(); ++i) {
            Element drill = (Element)this.m_drillElements.elementAt(i);
            drill.generateProgram(generator, out);
        }
    }

    @Override
    public void addDrillElement(IGenericElement drillElement) {
        this.m_drillElements.add(drillElement);
    }

    @Override
    public void addDrillTarget(DrillTargetInfo drillTarget) {
        this.m_drillTargets.add(drillTarget);
    }

    public Vector getDrillTargets() {
        return this.m_drillTargets;
    }

    public IStyle[] getNamedStyles() {
        return this.m_reportElementFactory.getStyles(this.m_namedStyles);
    }

    public IStyle findNamedStyle(String name, boolean create) {
        IStyle style;
        for (int i = 0; i < this.m_namedStyles.size(); ++i) {
            style = this.m_reportElementFactory.getStyle(this.m_namedStyles.elementAt(i));
            if (!style.getName().equals(name)) continue;
            return style;
        }
        if (create) {
            style = this.m_reportElementFactory.createStyle();
            style.setName(name);
            this.m_namedStyles.addElement(style);
        } else {
            style = null;
        }
        return style;
    }

    @Override
    public void addNamedStyle(IGenericStyle styleObj) {
        IStyle style = (IStyle)styleObj;
        if (style == null) {
            return;
        }
        String styleFingerprint = style.generateFingerPrint();
        String foundName = (String)this.m_namedStyleFingerprints.get(styleFingerprint);
        if (foundName == null) {
            this.m_namedStyleFingerprints.put(styleFingerprint, style.getName());
            this.m_namedStyles.addElement(style);
        } else {
            this.m_namedStyleMap.put(style.getName(), foundName);
        }
    }

    public String getMappedStyleName(String styleName) {
        String mappedName = (String)this.m_namedStyleMap.get(styleName);
        if (mappedName != null) {
            return mappedName;
        }
        return styleName;
    }

    public IElementFactory getElementFactory() {
        return this.m_reportElementFactory;
    }

    @Override
    public void setHtmlElementValue(IGenericElement currentElement, String value) {
        currentElement.setValue(value);
    }

    @Override
    public void setTextFrameElementValue(IGenericElement currentElement, String value) {
        currentElement.setValue(value);
    }

    @Override
    public void setRowSpan(int childIndex, IGenericElement currentElement, int nestedLevels) {
        IElement[] vmCornerCells = ((IElement)currentElement).getChildren();
        if (vmCornerCells != null && vmCornerCells.length > 0) {
            vmCornerCells[childIndex].setRowspan(nestedLevels);
        }
    }

    @Override
    public void updateAreaLabel(IGenericElement elm, Area area, String label) {
        if (elm.getAreas() != null) {
            int index = elm.getAreas().indexOf(area);
            ((Area)elm.getAreas().get((int)index)).label = label;
        }
    }

    @Override
    public void setPromptActionHintCanBack(IGenericElement elm, boolean canBack) {
        ((IElement)elm).getPromptActionHints().setCanBack(canBack);
    }

    @Override
    public void setPromptActionHintCanNext(IGenericElement elm, boolean canNext) {
        ((IElement)elm).getPromptActionHints().setCanNext(canNext);
    }

    @Override
    public void setPromptActionHintCanFinish(IGenericElement elm, boolean canFinish) {
        ((IElement)elm).getPromptActionHints().setCanFinish(canFinish);
    }

    public int parseStyleColour(String[] colour) {
        return this.getElementFactory().getStyleParser().parseColor(colour);
    }

    public int parseTextAlign(String alignText) {
        return this.getElementFactory().getStyleParser().parseTextAlign(alignText);
    }
}

