/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.generator;

import com.cognos.mobile.compiler.ReportCompiler;
import com.cognos.mobile.generator.IDocument;
import com.cognos.mobile.generator.IGenericElement;
import com.cognos.mobile.generator.IReport;
import java.util.Stack;

public abstract class DocumentBase
implements IDocument {
    private static int ROOT_PAGE_WIDGET_ID = -1;
    private boolean buxReport = false;
    private int widgetNumberToAssign = -1;
    private Stack<Integer> widgetStack = new Stack();
    ReportCompiler reportCompiler;
    private int pageIndex;
    private boolean hasNextPage = false;

    public DocumentBase(ReportCompiler compiler) {
        this.reportCompiler = compiler;
    }

    @Override
    public void pushWidget() {
        this.buxReport = true;
        ++this.widgetNumberToAssign;
        this.widgetStack.push(new Integer(this.widgetNumberToAssign));
        this.setWidgetPageIndex(this.widgetNumberToAssign, this.getPageIndex());
    }

    @Override
    public void popWidget() {
        if (!this.widgetStack.empty()) {
            this.widgetStack.pop();
        }
    }

    @Override
    public int getCurrentWidget() {
        if (this.widgetStack.empty()) {
            return ROOT_PAGE_WIDGET_ID;
        }
        return this.widgetStack.peek();
    }

    public void setWidgetPageIndex(int widget, int page) {
        this.reportCompiler.setWidgetPageIndex(widget, page);
    }

    @Override
    public int getCurrentWidgetPage() {
        return this.reportCompiler.getWidgetPageIndex(this.getCurrentWidget());
    }

    @Override
    public void incrementWidgetPage() {
        this.setWidgetPageIndex(this.getCurrentWidget(), this.getCurrentWidgetPage() + 1);
    }

    @Override
    public IReport getReport() {
        return this.reportCompiler.getReport();
    }

    @Override
    public int getPageIndex() {
        if (this.getCurrentWidget() == ROOT_PAGE_WIDGET_ID) {
            return this.pageIndex;
        }
        return this.reportCompiler.getWidgetPageIndex(this.getCurrentWidget());
    }

    @Override
    public int getRootPageIndex() {
        return this.pageIndex;
    }

    @Override
    public void ensureDocuments(int pageIndex) {
        this.setPageIndex(pageIndex);
    }

    protected void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    @Override
    public void setHasNextPage() {
        boolean doesHaveNextPage = this.reportCompiler.getHasNextPage();
        if (this.getCurrentWidget() == ROOT_PAGE_WIDGET_ID) {
            this.hasNextPage = doesHaveNextPage;
        } else {
            this.reportCompiler.setWidgetHasNextPage(this.getCurrentWidget(), doesHaveNextPage);
            if (doesHaveNextPage) {
                this.hasNextPage = true;
            }
        }
    }

    @Override
    public boolean getHasNextPage() {
        if (this.getCurrentWidget() == ROOT_PAGE_WIDGET_ID) {
            return this.hasNextPage;
        }
        return this.reportCompiler.getWidgetHasNextPage(this.getCurrentWidget());
    }

    @Override
    public boolean isBuxReport() {
        return this.buxReport;
    }

    public void setWidgetNumberToAssign(int widgetNumber) {
        this.widgetNumberToAssign = widgetNumber;
    }

    @Override
    public IGenericElement createPageElement() {
        if (this.pageIndex == -1) {
            this.setPageIndex(this.pageIndex + 1);
        } else if (this.getPageCount() > 0) {
            this.setPageIndex(this.pageIndex + 1);
        }
        IGenericElement pageElement = this.createPageElementImpl();
        this.widgetNumberToAssign = -1;
        return pageElement;
    }

    protected abstract IGenericElement createPageElementImpl();
}

