/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.generator;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMPathHelper;
import com.cognos.mobile.drill.DrillContext;
import com.cognos.mobile.drill.DrillContextParam;
import com.cognos.mobile.drill.DrillTargetInfo;
import com.cognos.mobile.generator.Area;
import com.cognos.mobile.generator.Document;
import com.cognos.mobile.generator.DrillUpDownContext;
import com.cognos.mobile.generator.IDrillUpDownContext;
import com.cognos.mobile.generator.IElement;
import com.cognos.mobile.generator.IGenerator;
import com.cognos.mobile.generator.IGenericElement;
import com.cognos.mobile.generator.IPromptActionHints;
import com.cognos.mobile.generator.IStyle;
import com.cognos.mobile.generator.PromptActionHints;
import com.cognos.mobile.prompts.Prompt;
import com.cognos.mobile.request.URI;
import com.cognos.mobile.vm.VM;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Vector;

public class Element
implements IElement {
    private static Class CLASS = Element.class;
    public static final int ELEMENT_BODY = 1;
    public static final int ELEMENT_CELL = 2;
    public static final int ELEMENT_CHART = 3;
    public static final int ELEMENT_FOOTER = 4;
    public static final int ELEMENT_HEADER = 5;
    public static final int ELEMENT_IMAGE = 6;
    public static final int ELEMENT_PAGE = 7;
    public static final int ELEMENT_PROMPT = 8;
    public static final int ELEMENT_ROW = 9;
    public static final int ELEMENT_TABLE = 10;
    public static final int ELEMENT_TEXTFRAME = 11;
    public static final int ELEMENT_MAP = 12;
    public static final int ELEMENT_DRILL = 13;
    public static final int ELEMENT_PAGEELEMENT = 14;
    public static final int ELEMENT_BLOCK = 15;
    public static final int ELEMENT_HTML = 16;
    public static final int ELEMENT_PBUTTON = 17;
    public static final int ELEMENT_PTEXTBOX = 18;
    public static final int ELEMENT_PDATE = 19;
    public static final int ELEMENT_PTIME = 20;
    public static final int ELEMENT_PDTIME = 21;
    public static final int ELEMENT_PINTRVL = 22;
    public static final int ELEMENT_PVALUE = 23;
    public static final int ELEMENT_PTREE = 24;
    public static final int ELEMENT_PSEARCH = 25;
    public static final int ELEMENT_PDSRC = 26;
    public static final int ELEMENT_HLINK = 27;
    protected Document document;
    protected int m_elementType;
    protected IElement m_parent;
    private String m_id;
    protected String m_name;
    protected String m_type;
    protected IStyle unnamedStyle;
    protected Vector styles;
    protected Vector m_children;
    protected Integer m_colspan;
    protected Integer m_rowspan;
    protected Vector drillContexts;
    protected DrillContext m_currentDrillTarget;
    protected DrillContextParam m_currentDrillParameter;
    protected String m_nodePath;
    protected IDrillUpDownContext drillUpDownCtx;
    protected IPromptActionHints promptActionHints;

    public Element(Document document, int elementType) {
        this.document = document;
        this.m_elementType = elementType;
        this.styles = new Vector();
        this.m_children = new Vector();
        this.drillContexts = new Vector();
        this.drillUpDownCtx = new DrillUpDownContext();
        this.promptActionHints = new PromptActionHints();
    }

    public Element(Element other) {
        this.m_parent = null;
        this.m_children = new Vector();
        this.document = other.document;
        this.m_elementType = other.m_elementType;
        this.setID(other.getID());
        this.m_name = other.m_name;
        this.m_type = other.m_type;
        this.unnamedStyle = other.unnamedStyle;
        this.styles = other.styles;
        this.m_colspan = other.m_colspan;
        this.m_rowspan = other.m_rowspan;
        this.drillContexts = other.drillContexts;
        this.m_currentDrillTarget = other.m_currentDrillTarget;
        this.m_currentDrillParameter = other.m_currentDrillParameter;
        this.m_nodePath = other.m_nodePath;
    }

    @Override
    public Document getDocument() {
        return this.document;
    }

    @Override
    public int getElementType() {
        return this.m_elementType;
    }

    @Override
    public IElement getParent() {
        return this.m_parent;
    }

    @Override
    public void setParent(IElement parent) {
        this.m_parent = parent;
    }

    @Override
    public Vector getStyles() {
        if (this.styles == null) {
            this.styles = new Vector(5);
        }
        return this.styles;
    }

    @Override
    public String getID() {
        return this.m_id;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getType() {
        return this.m_type;
    }

    @Override
    public Integer getColspan() {
        return this.m_colspan;
    }

    @Override
    public void setColspan(Integer colspan) {
        this.m_colspan = colspan;
    }

    @Override
    public Integer getRowspan() {
        return this.m_rowspan;
    }

    @Override
    public void setRowspan(Integer rowspan) {
        this.m_rowspan = rowspan;
    }

    @Override
    public Vector getDrillContexts() {
        return this.drillContexts;
    }

    @Override
    public void addDrillContext(DrillContext drillContext) {
        if (this.drillContexts != null) {
            this.drillContexts.add(drillContext);
        }
    }

    @Override
    public void addChild(IGenericElement childElm) {
        IElement child = (IElement)childElm;
        this.m_children.addElement(child);
        child.setParent(this);
        child.setNodePath();
    }

    @Override
    public IElement[] getChildren() {
        return this.m_children.toArray(new Element[0]);
    }

    @Override
    public IStyle getUnnamedStyle(boolean create) {
        return this.unnamedStyle;
    }

    public void setUnnamedStyle(IStyle style) {
        this.unnamedStyle = style;
    }

    @Override
    public void generateProgram(IGenerator generator, PrintStream out) {
        this.generateStyles(generator, out);
        IElement[] children = this.getChildren();
        this.generateProgram(children, generator, out);
    }

    @Override
    public void debugDumpTree(int level, PrintStream out) {
        int i;
        for (i = 0; i < level; ++i) {
            out.print(".");
        }
        this.debugDumpObject(out);
        for (i = 0; i < this.m_children.size(); ++i) {
            Element child = (Element)this.m_children.elementAt(i);
            child.debugDumpTree(level + 1, out);
        }
    }

    @Override
    public void debugDumpObject(PrintStream out) {
    }

    protected String handleUrl(String url) {
        if (url.startsWith("cid:")) {
            return url;
        }
        if (url != null && !url.startsWith("http") && !url.startsWith("file")) {
            url = url.startsWith("?") ? this.fixDispatcherUrl(url) : this.fixGatewayUrl(url);
        }
        return url;
    }

    protected String fixGatewayUrl(String in) {
        URI uri;
        String url = this.document.getReport().getGatewayUrl();
        try {
            uri = URI.parseURI(url, true);
        }
        catch (CMException e) {
            uri = null;
            VM.log(CLASS, 3, "couldn't parse URI '" + url + "'", e);
        }
        if (!(in.startsWith("http:") || in.startsWith("https:") || in.startsWith("file:"))) {
            in = in.replace('\\', '/');
            String alias = this.getGatewayAlias();
            if (alias != null) {
                if (url != null) {
                    url = uri.getScheme() + "://" + uri.getHost() + ":" + uri.getPort();
                } else {
                    VM.log(CLASS, 3, "couldn't build absolute URL for relative path '" + in + "'");
                }
                if (in.startsWith("../")) {
                    in = alias + in.substring(2);
                }
                in = in.replaceAll("//" + alias + "/", "/../");
            }
        }
        return this.fixUrl(url, in);
    }

    protected String getGatewayAlias() {
        String gwUrl = this.document.getReport().getGatewayUrl();
        try {
            URI uri = URI.parseURI(gwUrl, true);
            return uri.getPath();
        }
        catch (CMException e) {
            VM.log(CLASS, 3, "couldn't parse URI '" + gwUrl + "'", e);
            return "";
        }
    }

    protected String fixDispatcherUrl(String in) {
        return this.fixUrl(this.document.getReport().getDispatcherUrl(), in);
    }

    private String fixUrl(String base, String in) {
        if (in.startsWith("http:")) {
            return in;
        }
        if (in.startsWith("https:")) {
            return in;
        }
        if (in.startsWith("file:")) {
            return in;
        }
        String out = CMPathHelper.ensureDir(base);
        out = in.startsWith("/") ? out + in.substring(1) : out + in;
        return out;
    }

    protected IElement[] getChildrenOfElementType(int elementType) {
        Vector<Element> results = new Vector<Element>();
        for (int i = 0; i < this.m_children.size(); ++i) {
            Element child = (Element)this.m_children.elementAt(i);
            if (child.getElementType() != elementType) continue;
            results.addElement(child);
        }
        if (results.size() == 0) {
            return new Element[0];
        }
        return results.toArray(new Element[0]);
    }

    @Override
    public int numChildren() {
        return this.m_children == null ? 0 : this.m_children.size();
    }

    @Override
    public Element getChild(int index) {
        return this.m_children == null ? null : (Element)this.m_children.elementAt(index);
    }

    @Override
    public void setNodePath() {
        String nodePathID;
        if (this.m_parent == null) {
            this.m_nodePath = "";
            return;
        }
        int siblingCount = this.m_parent.numChildren();
        int siblingIndex = -1;
        for (int i = 0; i < siblingCount; ++i) {
            if (this != this.m_parent.getChild(i)) continue;
            siblingIndex = i;
            break;
        }
        if (siblingIndex == -1) {
            this.m_nodePath = "";
            return;
        }
        if (this.m_parent.getNodePath() == null) {
            this.m_parent.setNodePath();
        }
        if ((nodePathID = this.m_parent.getNodePath()).length() > 0) {
            nodePathID = nodePathID + ".";
        }
        this.m_nodePath = nodePathID = nodePathID + Integer.toString(siblingIndex);
    }

    @Override
    public void resetNodePath(String parentPath, int index) throws StackOverflowError {
        this.m_nodePath = this.m_parent == null ? "" : ("".equals(parentPath) ? "" + index : parentPath + "." + index);
        for (int i = 0; i < this.m_children.size(); ++i) {
            Element child = (Element)this.m_children.elementAt(i);
            child.resetNodePath(this.m_nodePath, i);
        }
    }

    @Override
    public String getNodePath() {
        return this.m_nodePath;
    }

    @Override
    public void removeHidden() {
        Element child;
        int i;
        ArrayList<Element> toRemove = new ArrayList<Element>(this.m_children.size());
        for (i = 0; i < this.m_children.size(); ++i) {
            child = (Element)this.m_children.elementAt(i);
            if (!child.isHidden()) continue;
            toRemove.add(child);
        }
        this.m_children.removeAll(toRemove);
        for (i = 0; i < this.m_children.size(); ++i) {
            child = (Element)this.m_children.elementAt(i);
            child.removeHidden();
        }
    }

    @Override
    public boolean isHidden() {
        boolean isHidden = false;
        for (int i = 0; i < this.styles.size(); ++i) {
            String styleName = (String)this.styles.elementAt(i);
            IStyle style = this.document.findNamedStyle(styleName, false);
            if (style == null || style.isDeleted() || !style.isHidden()) continue;
            isHidden = true;
        }
        if (this.unnamedStyle != null && this.unnamedStyle.isHidden()) {
            isHidden = true;
        }
        return isHidden;
    }

    @Override
    public void addStyle(String styleName) {
        this.styles.add(styleName);
    }

    protected void generateProgram(IElement[] elements, IGenerator generator, PrintStream out) {
    }

    protected void generateDrillThrough(IGenerator generator, PrintStream out) {
    }

    protected void generateDrillThrough(PrintStream out, Vector drillTargets) {
    }

    protected void generateStyles(IGenerator generator, PrintStream out) {
    }

    @Override
    public void addDrillInfo(DrillTargetInfo drillInfo) {
    }

    @Override
    public Vector getAreas() {
        return null;
    }

    @Override
    public void setHeight(int height) {
    }

    @Override
    public void setIsTitle(boolean isTitle) {
    }

    @Override
    public void setUrl(String url) {
    }

    @Override
    public void setMap(String map) {
    }

    @Override
    public void setValue(String textNode) {
    }

    @Override
    public void setWidth(int width) {
    }

    @Override
    public void setIsLayout(boolean isLayout) {
    }

    @Override
    public void generateElement(String blobHref, IGenerator generator, PrintStream out) {
    }

    @Override
    public Prompt getPrompt() {
        return null;
    }

    @Override
    public IDrillUpDownContext getDrillUpDownContext() {
        return this.drillUpDownCtx;
    }

    @Override
    public IPromptActionHints getPromptActionHints() {
        return this.promptActionHints;
    }

    @Override
    public void setID(String id) {
        this.m_id = id;
    }

    public int validDrillTargets() {
        int iValid = 0;
        Vector targets = this.getDocument().getDrillTargets();
        if (targets != null) {
            for (int i = 0; i < targets.size(); ++i) {
                DrillTargetInfo t = (DrillTargetInfo)targets.elementAt(i);
                if (!t.isValid()) continue;
                ++iValid;
            }
        }
        return iValid;
    }

    public boolean validateDrillthrough(Vector contexts) {
        if (contexts == null || contexts.size() == 0) {
            return false;
        }
        if (this.getDocument().hasUnsupportedDrillFlag()) {
            return false;
        }
        return this.validateDrillContexts(contexts);
    }

    public boolean validateDrillContexts(Vector drillContexts) {
        Vector targets = this.getDocument().getDrillTargets();
        for (int i = 0; i < drillContexts.size(); ++i) {
            DrillTargetInfo target;
            DrillContext context = (DrillContext)drillContexts.elementAt(i);
            int drillTargetIndex = context.getDrillIndex();
            if (targets == null || drillTargetIndex >= targets.size() || (target = (DrillTargetInfo)targets.elementAt(drillTargetIndex)).isModelPathSameAsSource()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setCanDrillUp(boolean b) {
        IDrillUpDownContext drillUpDownContext = this.getDrillUpDownContext();
        if (drillUpDownContext != null) {
            drillUpDownContext.setCanDrillUp(b);
        }
    }

    @Override
    public void setCanDrillDown(boolean b) {
        IDrillUpDownContext drillUpDownContext = this.getDrillUpDownContext();
        if (drillUpDownContext != null) {
            drillUpDownContext.setCanDrillDown(b);
        }
    }

    @Override
    public void setDrillUpDownContext(String context) {
        IDrillUpDownContext drillUpDownContext = this.getDrillUpDownContext();
        if (drillUpDownContext != null) {
            drillUpDownContext.setDrillUpDownContext(context);
        }
    }

    @Override
    public void setDrillUpDownWidget(int widgetIdx) {
        IDrillUpDownContext drillUpDownContext = this.getDrillUpDownContext();
        if (drillUpDownContext != null) {
            drillUpDownContext.setDrillUpDownWidget(widgetIdx);
        }
    }

    @Override
    public void addArea(Area area) {
        this.getAreas().addElement(area.clone());
    }
}

