/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.generator;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.ImageInfo;
import com.cognos.mobile.compiler.ReportCompiler;
import com.cognos.mobile.generator.Document;
import com.cognos.mobile.generator.IElement;
import com.cognos.mobile.generator.IGenerator;
import com.cognos.mobile.generator.IReport;
import com.cognos.mobile.generator.IStyle;
import com.cognos.mobile.generator.output.vm.VmStyle;
import com.cognos.mobile.vm.IVMWriter;
import java.io.PrintStream;

public abstract class Generator
implements IGenerator {
    private int pass;
    private Document currentDocument;
    private IElement currentPage;
    private int renderID;
    protected ReportCompiler reportCompiler;
    private boolean testing = false;
    protected final IVMWriter writer;

    public Generator(ReportCompiler rc, IVMWriter writer) {
        this.reportCompiler = rc;
        this.writer = writer;
    }

    @Override
    public abstract void generate(Document var1, PrintStream var2) throws CMException;

    @Override
    public int getPass() {
        return this.pass;
    }

    @Override
    public void markStyleAsUsed(String styleName) {
        if (this.pass != 0) {
            return;
        }
        if (this.currentDocument == null) {
            return;
        }
        VmStyle style = (VmStyle)this.currentDocument.findNamedStyle(styleName, false);
        if (style != null) {
            style.markAsUsed();
        }
    }

    @Override
    public int getRenderID() {
        return this.renderID;
    }

    @Override
    public void cache(String key, Integer value) {
        this.writer.getBlobCache().put(key, value);
    }

    @Override
    public void cache(String key, String value) {
        this.writer.getBlobCache().put(key, value);
    }

    @Override
    public boolean isTesting() {
        return this.testing;
    }

    @Override
    public ImageInfo storeImageResource(String originalBlobUrl) throws CMException {
        return this.reportCompiler.storeImageResource(89, originalBlobUrl, this.writer);
    }

    @Override
    public String getGatewayUrl() {
        return null;
    }

    @Override
    public abstract void generateHeader(IReport var1, int var2, PrintStream var3);

    @Override
    public abstract void generateFooter(PrintStream var1);

    protected void generateStylesSubroutines(PrintStream out) {
        IStyle[] styles = this.currentDocument.getNamedStyles();
        for (int i = 0; i < styles.length; ++i) {
            boolean styleHasEffect;
            if (!styles[i].isUsed() || (styleHasEffect = styles[i].generateProgram(this.currentDocument.getPageIndex(), out))) continue;
            styles[i].markAsDeleted();
        }
    }

    protected void setCurrentPage(IElement m_currentPage) {
        this.currentPage = m_currentPage;
    }

    protected IElement getCurrentPage() {
        return this.currentPage;
    }

    protected void setRenderID(int m_renderID) {
        this.renderID = m_renderID;
    }

    protected void setCurrentDocument(Document currentDoc) {
        this.currentDocument = currentDoc;
    }

    protected Document getCurrentDocument() {
        return this.currentDocument;
    }

    protected void setPass(int m_pass) {
        this.pass = m_pass;
    }

    protected void setTesting(boolean m_testing) {
        this.testing = m_testing;
    }
}

