/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.generator;

import com.cognos.mobile.compiler.ReportCompiler;
import com.cognos.mobile.drill.DrillTargetInfo;
import com.cognos.mobile.generator.Area;
import com.cognos.mobile.generator.Document;
import com.cognos.mobile.generator.DocumentBase;
import com.cognos.mobile.generator.GenericElementStack;
import com.cognos.mobile.generator.IElement;
import com.cognos.mobile.generator.IGenericElement;
import com.cognos.mobile.generator.IGenericStyle;
import com.cognos.mobile.generator.IReport;
import com.cognos.mobile.generator.IStyle;
import com.cognos.mobile.generator.MultiElement;
import com.cognos.mobile.generator.MultiElementStack;
import com.cognos.mobile.generator.MultiStyle;
import com.cognos.mobile.generator.output.html.HtmlDocument;
import com.cognos.mobile.generator.output.vm.VmDocument;
import com.cognos.mobile.prompts.Prompt;
import java.util.Hashtable;
import java.util.Map;

public class MultiDocument
extends DocumentBase {
    private VmDocument vmDocument;
    private HtmlDocument htmlDocument;

    public MultiDocument(IReport report, ReportCompiler reportCompiler) {
        super(reportCompiler);
        this.vmDocument = new VmDocument(this, reportCompiler);
        this.htmlDocument = new HtmlDocument(this, reportCompiler);
    }

    @Override
    public void ensureDocuments(int pageIndex) {
        super.ensureDocuments(pageIndex);
    }

    public Document getDocument(String outputType) {
        if ("vm".equals(outputType)) {
            return this.vmDocument;
        }
        return this.htmlDocument;
    }

    @Override
    public IGenericElement createElement(int elementType, IGenericElement parentElement) {
        MultiElement multiElement = new MultiElement();
        IElement element = this.vmDocument.createElement(elementType, parentElement != null ? ((MultiElement)parentElement).getElement("vm") : null);
        multiElement.addElement("vm", element);
        element = this.htmlDocument.createElement(elementType, parentElement != null ? ((MultiElement)parentElement).getElement("html") : null);
        multiElement.addElement("html", element);
        return multiElement;
    }

    public IElement getPageElement(String outputType) {
        if ("vm".equals(outputType)) {
            return this.vmDocument.getPageElement(this.getRootPageIndex());
        }
        return this.htmlDocument.getPageElement(this.getRootPageIndex());
    }

    public IGenericElement getPageElement() {
        MultiElement multiElement = new MultiElement();
        multiElement.addElement("vm", this.vmDocument.getPageElement(this.getRootPageIndex()));
        multiElement.addElement("html", this.htmlDocument.getPageElement(this.getRootPageIndex()));
        return multiElement;
    }

    @Override
    public IGenericElement getPageElement(int pageIndex) {
        MultiElement multiElement = new MultiElement();
        multiElement.addElement("vm", this.vmDocument.getPageElement(pageIndex));
        multiElement.addElement("html", this.htmlDocument.getPageElement(pageIndex));
        return multiElement;
    }

    @Override
    public int getPageCount() {
        return this.vmDocument.getPageCount();
    }

    @Override
    protected IGenericElement createPageElementImpl() {
        MultiElement pageElement = (MultiElement)this.createElement(14, new MultiElement(null, null));
        this.vmDocument.addPageElement(pageElement.getElement("vm"));
        this.htmlDocument.addPageElement(pageElement.getElement("html"));
        return pageElement;
    }

    @Override
    public void addDrillElement(IGenericElement drillElement) {
        this.vmDocument.addDrillElement(((MultiElement)drillElement).getElement("vm"));
        this.htmlDocument.addDrillElement(((MultiElement)drillElement).getElement("html"));
    }

    @Override
    public void addDrillTarget(DrillTargetInfo drillTarget) {
        this.vmDocument.addDrillTarget(drillTarget);
        this.htmlDocument.addDrillTarget(drillTarget);
    }

    @Override
    public void setIsMUNUsed(boolean isOLAP) {
        this.vmDocument.setIsMUNUsed(isOLAP);
        this.htmlDocument.setIsMUNUsed(isOLAP);
    }

    @Override
    public boolean compareDrillthroughModelPath(String sourceModelPath, Hashtable targetModelPaths) {
        this.vmDocument.compareDrillthroughModelPath(sourceModelPath, targetModelPaths);
        return this.htmlDocument.compareDrillthroughModelPath(sourceModelPath, targetModelPaths);
    }

    @Override
    public void getDrillTargetCMPaths(Hashtable hashtable) {
        this.vmDocument.getDrillTargetCMPaths(hashtable);
    }

    @Override
    public void setUnsupportedDrillFlag(boolean flag) {
        this.vmDocument.setUnsupportedDrillFlag(flag);
        this.htmlDocument.setUnsupportedDrillFlag(flag);
    }

    @Override
    public boolean isMemberUniqueNameUsed() {
        return this.vmDocument.isMemberUniqueNameUsed();
    }

    @Override
    public void setHtmlElementValue(IGenericElement currentElement, String value) {
        this.vmDocument.setHtmlElementValue(((MultiElement)currentElement).getElement("vm"), value);
        this.htmlDocument.setHtmlElementValue(((MultiElement)currentElement).getElement("html"), value);
    }

    @Override
    public void setTextFrameElementValue(IGenericElement currentElement, String value) {
        this.vmDocument.setTextFrameElementValue(((MultiElement)currentElement).getElement("vm"), value);
        this.htmlDocument.setTextFrameElementValue(((MultiElement)currentElement).getElement("html"), value);
    }

    @Override
    public void setRowSpan(int childIndex, IGenericElement currentElement, int nestedLevels) {
        this.vmDocument.setRowSpan(childIndex, ((MultiElement)currentElement).getElement("vm"), nestedLevels);
        this.htmlDocument.setRowSpan(childIndex, ((MultiElement)currentElement).getElement("html"), nestedLevels);
    }

    @Override
    public IGenericStyle createStyle() {
        MultiStyle multiStyle = new MultiStyle();
        IStyle style = this.vmDocument.getElementFactory().createStyle();
        multiStyle.addElement("vm", style);
        style = this.htmlDocument.getElementFactory().createStyle();
        multiStyle.addElement("html", style);
        return multiStyle;
    }

    public int parseStyleColour(String outputType, String[] colour) {
        return this.getDocument(outputType).parseStyleColour(colour);
    }

    public int parseTextAlign(String outputType, String alignText) {
        return this.getDocument(outputType).parseTextAlign(alignText);
    }

    @Override
    public void addNamedStyle(IGenericStyle style) {
        this.vmDocument.addNamedStyle(((MultiStyle)style).getElement("vm"));
        this.htmlDocument.addNamedStyle(((MultiStyle)style).getElement("html"));
    }

    @Override
    public void updateAreaLabel(IGenericElement elm, Area area, String label) {
        MultiElement multiElm = (MultiElement)elm;
        IElement vmElement = multiElm.getElement("vm");
        int index = vmElement.getAreas().indexOf(area);
        Map<String, IElement> elements = multiElm.getElements();
        for (String elementType : elements.keySet()) {
            IElement element = multiElm.getElement(elementType);
            if (element.getAreas() == null || element.getAreas().get(index) == null) continue;
            ((Area)element.getAreas().get((int)index)).label = label;
        }
    }

    @Override
    public void setPromptActionHintCanBack(IGenericElement elm, boolean canBack) {
        MultiElement multiElm = (MultiElement)elm;
        for (String elementType : multiElm.getElements().keySet()) {
            multiElm.getElement(elementType).getPromptActionHints().setCanBack(canBack);
        }
    }

    @Override
    public void setPromptActionHintCanNext(IGenericElement elm, boolean canNext) {
        MultiElement multiElm = (MultiElement)elm;
        for (String elementType : multiElm.getElements().keySet()) {
            multiElm.getElement(elementType).getPromptActionHints().setCanNext(canNext);
        }
    }

    @Override
    public void setPromptActionHintCanFinish(IGenericElement elm, boolean canFinish) {
        MultiElement multiElm = (MultiElement)elm;
        for (String elementType : multiElm.getElements().keySet()) {
            multiElm.getElement(elementType).getPromptActionHints().setCanFinish(canFinish);
        }
    }

    @Override
    public Prompt findPromptBox(IGenericElement elm) {
        return this.htmlDocument.findPromptBox(((MultiElement)elm).getElement("html"));
    }

    @Override
    public GenericElementStack createGenericElementStack() {
        return new MultiElementStack();
    }

    @Override
    protected void setPageIndex(int pageIndex) {
        super.setPageIndex(pageIndex);
        this.htmlDocument.setPageIndex(pageIndex);
        this.vmDocument.setPageIndex(pageIndex);
    }
}

