/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.generator;

import com.cognos.mobile.drill.DrillContext;
import com.cognos.mobile.drill.DrillTargetInfo;
import com.cognos.mobile.generator.Area;
import com.cognos.mobile.generator.Element;
import com.cognos.mobile.generator.IDrillUpDownContext;
import com.cognos.mobile.generator.IElement;
import com.cognos.mobile.generator.IGenericElement;
import com.cognos.mobile.generator.NullElement;
import com.cognos.mobile.prompts.Prompt;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class MultiElement
implements IGenericElement {
    private Map<String, IElement> elements = new HashMap<String, IElement>();

    public MultiElement() {
        this(NullElement.instance(), NullElement.instance());
    }

    public MultiElement(MultiElement other) {
        for (String elementType : other.elements.keySet()) {
            this.elements.put(elementType, new Element((Element)other.getElement(elementType)));
        }
    }

    public MultiElement(IElement vmElement, IElement htmlElement) {
        this.elements.put("vm", vmElement);
        this.elements.put("html", htmlElement);
    }

    public Map<String, IElement> getElements() {
        return this.elements;
    }

    public IElement getElement(String elementType) {
        return this.elements.get(elementType);
    }

    public void addElement(String elementType, IElement element) {
        this.elements.put(elementType, element);
    }

    @Override
    public void addChild(IGenericElement elm) {
        MultiElement multiElm = (MultiElement)elm;
        for (String elementType : multiElm.elements.keySet()) {
            this.getElement(elementType).addChild(multiElm.getElement(elementType));
        }
    }

    @Override
    public void addStyle(String styleName) {
        for (String elementType : this.elements.keySet()) {
            IElement element = this.getElement(elementType);
            if (element.getStyles() == null) continue;
            element.addStyle(styleName);
        }
    }

    @Override
    public void setCanDrillUp(boolean b) {
        for (String elementType : this.elements.keySet()) {
            IDrillUpDownContext drillUpDownContext = this.getElement(elementType).getDrillUpDownContext();
            if (drillUpDownContext == null) continue;
            drillUpDownContext.setCanDrillUp(b);
        }
    }

    @Override
    public void setCanDrillDown(boolean b) {
        for (String elementType : this.elements.keySet()) {
            IDrillUpDownContext drillUpDownContext = this.getElement(elementType).getDrillUpDownContext();
            if (drillUpDownContext == null) continue;
            drillUpDownContext.setCanDrillDown(b);
        }
    }

    @Override
    public void setDrillUpDownContext(String s) {
        for (String elementType : this.elements.keySet()) {
            IDrillUpDownContext drillUpDownContext = this.getElement(elementType).getDrillUpDownContext();
            if (drillUpDownContext == null) continue;
            drillUpDownContext.setDrillUpDownContext(s);
        }
    }

    @Override
    public void setDrillUpDownWidget(int w) {
        for (String elementType : this.elements.keySet()) {
            IDrillUpDownContext drillUpDownContext = this.getElement(elementType).getDrillUpDownContext();
            if (drillUpDownContext == null) continue;
            drillUpDownContext.setDrillUpDownWidget(w);
        }
    }

    @Override
    public void addDrillContext(DrillContext drillContext) {
        for (String elementType : this.elements.keySet()) {
            this.getElement(elementType).addDrillContext(drillContext);
        }
    }

    @Override
    public void setIsTitle(boolean isTitle) {
        for (String elementType : this.elements.keySet()) {
            this.getElement(elementType).setIsTitle(isTitle);
        }
    }

    @Override
    public Vector getAreas() {
        IElement vmElement = this.getVMElement();
        return vmElement == null ? null : vmElement.getAreas();
    }

    @Override
    public void addArea(Area area) {
        for (String elementType : this.elements.keySet()) {
            this.getElement(elementType).addArea(area);
        }
    }

    @Override
    public void setWidth(int width) {
        for (String elementType : this.elements.keySet()) {
            this.getElement(elementType).setWidth(width);
        }
    }

    @Override
    public void setHeight(int height) {
        for (String elementType : this.elements.keySet()) {
            this.getElement(elementType).setHeight(height);
        }
    }

    @Override
    public void setIsLayout(boolean isLayout) {
        for (String elementType : this.elements.keySet()) {
            this.getElement(elementType).setIsLayout(isLayout);
        }
    }

    @Override
    public void setColspan(Integer colspan) {
        for (String elementType : this.elements.keySet()) {
            this.getElement(elementType).setColspan(colspan);
        }
    }

    @Override
    public void setRowspan(Integer rowspan) {
        for (String elementType : this.elements.keySet()) {
            this.getElement(elementType).setRowspan(rowspan);
        }
    }

    @Override
    public void setValue(String textNode) {
        for (String elementType : this.elements.keySet()) {
            this.getElement(elementType).setValue(textNode);
        }
    }

    @Override
    public void setUrl(String url) {
        for (String elementType : this.elements.keySet()) {
            this.getElement(elementType).setUrl(url);
        }
    }

    @Override
    public String getID() {
        return this.getVMElement().getID();
    }

    @Override
    public void setID(String id) {
        for (String elementType : this.elements.keySet()) {
            this.getElement(elementType).setID(id);
        }
    }

    @Override
    public void setMap(String map) {
        for (String elementType : this.elements.keySet()) {
            this.getElement(elementType).setMap(map);
        }
    }

    @Override
    public void addDrillInfo(DrillTargetInfo drillInfo) {
        for (String elementType : this.elements.keySet()) {
            this.getElement(elementType).addDrillInfo(drillInfo);
        }
    }

    @Override
    public void removeHidden() {
        for (String elementType : this.elements.keySet()) {
            this.getElement(elementType).removeHidden();
        }
    }

    @Override
    public void resetNodePath(String parentPath, int index) throws StackOverflowError {
        for (String elementType : this.elements.keySet()) {
            this.getElement(elementType).resetNodePath(parentPath, index);
        }
    }

    public String toString() {
        return this.getVMElement().toString();
    }

    private IElement getVMElement() {
        return this.elements.get("vm");
    }

    @Override
    public Prompt getPrompt() {
        IElement currentElement = this.getElement("html");
        return currentElement.getPrompt();
    }
}

