/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.generator;

import com.cognos.mobile.generator.IElement;
import java.util.Vector;

final class TemplateConnector {
    private String[] ids;
    private int[] templateIndexes;
    private String[] parentNodePaths;
    private IElement[] parentElements;

    TemplateConnector() {
    }

    public void add(String id, int templateIndex, String parentNodePath) {
        if (this.ids == null) {
            this.ids = new String[1];
            this.ids[0] = id;
            this.templateIndexes = new int[1];
            this.templateIndexes[0] = templateIndex;
            this.parentNodePaths = new String[1];
            this.parentNodePaths[0] = parentNodePath;
        } else {
            String[] tempIds = new String[this.ids.length + 1];
            System.arraycopy(this.ids, 0, tempIds, 0, this.ids.length);
            tempIds[this.ids.length] = id;
            this.ids = tempIds;
            int[] tempIndex = new int[this.templateIndexes.length + 1];
            System.arraycopy(this.templateIndexes, 0, tempIndex, 0, this.templateIndexes.length);
            tempIndex[this.templateIndexes.length] = templateIndex;
            this.templateIndexes = tempIndex;
            String[] tempParent = new String[this.parentNodePaths.length + 1];
            System.arraycopy(this.parentNodePaths, 0, tempParent, 0, this.parentNodePaths.length);
            tempParent[this.parentNodePaths.length] = parentNodePath;
            this.parentNodePaths = tempParent;
        }
    }

    public void add(String id, int templateIndex, IElement parentElement) {
        if (this.ids == null) {
            this.ids = new String[1];
            this.ids[0] = id;
            this.templateIndexes = new int[1];
            this.templateIndexes[0] = templateIndex;
            this.parentElements = new IElement[1];
            this.parentElements[0] = parentElement;
        } else {
            String[] tempIds = new String[this.ids.length + 1];
            System.arraycopy(this.ids, 0, tempIds, 0, this.ids.length);
            tempIds[this.ids.length] = id;
            this.ids = tempIds;
            int[] tempIndex = new int[this.templateIndexes.length + 1];
            System.arraycopy(this.templateIndexes, 0, tempIndex, 0, this.templateIndexes.length);
            tempIndex[this.templateIndexes.length] = templateIndex;
            this.templateIndexes = tempIndex;
            IElement[] tempParent = new IElement[this.parentElements.length + 1];
            System.arraycopy(this.parentElements, 0, tempParent, 0, this.parentElements.length);
            tempParent[this.parentElements.length] = parentElement;
            this.parentElements = tempParent;
        }
    }

    public int getTemplateIndex(String id) {
        if (this.ids == null || this.templateIndexes == null) {
            return -1;
        }
        for (int i = 0; i < this.ids.length; ++i) {
            if (!this.isMatch(this.ids[i], id)) continue;
            return this.templateIndexes[i];
        }
        return -1;
    }

    public int getLatestTemplateIndex(String id) {
        int latestIndex = -1;
        if (this.ids == null || this.templateIndexes == null) {
            return -1;
        }
        for (int i = 0; i < this.ids.length; ++i) {
            if (!this.isMatch(this.ids[i], id)) continue;
            latestIndex = latestIndex > this.templateIndexes[i] ? latestIndex : this.templateIndexes[i];
        }
        return latestIndex;
    }

    public String[] getIds(int masterIndex, String parentNodePath) {
        Vector<String> idList = new Vector<String>(1);
        if (masterIndex < 0 || parentNodePath == null || this.templateIndexes == null || this.parentNodePaths == null) {
            return null;
        }
        for (int i = 0; i < this.ids.length; ++i) {
            if (masterIndex != this.templateIndexes[i] || !this.parentNodePaths[i].equals(parentNodePath)) continue;
            idList.addElement(this.ids[i]);
        }
        return idList.toArray(new String[0]);
    }

    public IElement getParentElement(String id, int templateIndex) {
        if (this.ids == null || this.templateIndexes == null || this.parentElements == null) {
            return null;
        }
        for (int i = 0; i < this.ids.length; ++i) {
            if (!this.isMatch(this.ids[i], id) || templateIndex != this.templateIndexes[i]) continue;
            return this.parentElements[i];
        }
        return null;
    }

    private boolean isMatch(String idTemplate, String idRef) {
        return idTemplate.equals(idRef) || idTemplate.equals(idRef.replaceFirst("./layouts/layout/reportPages", ""));
    }
}

