/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.generator;

import com.cognos.mobile.generator.IElement;

final class TemplateList {
    private int[] templateIndexes;
    private int[] masterIndexes;
    private IElement[] rootElements;

    TemplateList() {
    }

    public void add(int templateIndex, int masterIndex) {
        if (this.templateIndexes == null) {
            this.templateIndexes = new int[1];
            this.templateIndexes[0] = templateIndex;
            this.masterIndexes = new int[1];
            this.masterIndexes[0] = masterIndex;
            this.rootElements = new IElement[1];
        } else {
            int[] tempIndex = new int[this.templateIndexes.length + 1];
            System.arraycopy(this.templateIndexes, 0, tempIndex, 0, this.templateIndexes.length);
            tempIndex[this.templateIndexes.length] = templateIndex;
            this.templateIndexes = tempIndex;
            tempIndex = new int[this.masterIndexes.length + 1];
            System.arraycopy(this.masterIndexes, 0, tempIndex, 0, this.masterIndexes.length);
            tempIndex[this.masterIndexes.length] = masterIndex;
            this.masterIndexes = tempIndex;
            IElement[] tempRoot = new IElement[this.rootElements.length + 1];
            System.arraycopy(this.rootElements, 0, tempRoot, 0, this.rootElements.length);
            tempRoot[this.rootElements.length] = null;
            this.rootElements = tempRoot;
        }
    }

    public void add(int templateIndex, int masterIndex, IElement rootElement) {
        if (this.templateIndexes == null) {
            this.templateIndexes = new int[1];
            this.templateIndexes[0] = templateIndex;
            this.masterIndexes = new int[1];
            this.masterIndexes[0] = masterIndex;
            this.rootElements = new IElement[1];
            this.rootElements[0] = rootElement;
        } else {
            int[] tempIndex = new int[this.templateIndexes.length + 1];
            System.arraycopy(this.templateIndexes, 0, tempIndex, 0, this.templateIndexes.length);
            tempIndex[this.templateIndexes.length] = templateIndex;
            this.templateIndexes = tempIndex;
            tempIndex = new int[this.masterIndexes.length + 1];
            System.arraycopy(this.masterIndexes, 0, tempIndex, 0, this.masterIndexes.length);
            tempIndex[this.masterIndexes.length] = masterIndex;
            this.masterIndexes = tempIndex;
            IElement[] tempRoot = new IElement[this.rootElements.length + 1];
            System.arraycopy(this.rootElements, 0, tempRoot, 0, this.rootElements.length);
            tempRoot[this.rootElements.length] = rootElement;
            this.rootElements = tempRoot;
        }
    }

    public int getMasterIndex(IElement rootElement) {
        if (this.masterIndexes == null || this.rootElements == null) {
            return -1;
        }
        for (int i = 0; i < this.rootElements.length; ++i) {
            if (!this.rootElements[i].equals(rootElement)) continue;
            return this.masterIndexes[i];
        }
        return -1;
    }

    public IElement getTemplate(int id) {
        if (this.templateIndexes == null || this.rootElements == null) {
            return null;
        }
        for (int i = 0; i < this.templateIndexes.length; ++i) {
            if (this.templateIndexes[i] != id) continue;
            return this.rootElements[i];
        }
        return null;
    }

    public void setRootElement(int templateIndex, IElement rootElement) {
        if (templateIndex >= 0 && this.rootElements != null) {
            for (int i = 0; i < this.templateIndexes.length; ++i) {
                if (this.templateIndexes[i] != templateIndex) continue;
                this.rootElements[i] = rootElement;
            }
        }
    }
}

