/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.generator;

import com.cognos.mobile.generator.IElement;
import com.cognos.mobile.generator.TemplateConnector;
import com.cognos.mobile.generator.TemplateList;

public class TemplateSet {
    private int m_currentTemplateIndex = -1;
    private TemplateList m_templates = null;
    private TemplateConnector m_templateConnector = null;

    public int addTemplate(IElement template) {
        if (template != null) {
            if (this.m_templates == null) {
                this.m_templates = new TemplateList();
            }
            this.m_templates.add(++this.m_currentTemplateIndex, this.m_currentTemplateIndex, template);
            return this.m_currentTemplateIndex;
        }
        return -1;
    }

    public int addTemplate(int masterIndex) {
        if (masterIndex < 0) {
            return -1;
        }
        if (this.m_templates == null) {
            this.m_templates = new TemplateList();
        }
        this.m_templates.add(++this.m_currentTemplateIndex, masterIndex);
        return this.m_currentTemplateIndex;
    }

    public IElement getTemplate(int index) {
        if (this.m_templates == null) {
            return null;
        }
        return this.m_templates.getTemplate(index);
    }

    public IElement getLatestTemplate(String id) {
        if (this.m_templates == null) {
            return null;
        }
        int templateIndex = this.m_templateConnector.getLatestTemplateIndex(id);
        return this.m_templates.getTemplate(templateIndex);
    }

    public IElement getLatestParentElement(String id) {
        if (this.m_templates == null) {
            return null;
        }
        int templateIndex = this.m_templateConnector.getLatestTemplateIndex(id);
        return this.m_templateConnector.getParentElement(id, templateIndex);
    }

    public int getLatestTemplateIndex(String id) {
        return this.m_templateConnector.getLatestTemplateIndex(id);
    }

    public void addTemplateConnector(String id, int masterIndex, IElement parentElement) {
        if (id != null && masterIndex >= 0 && parentElement != null) {
            if (this.m_templateConnector == null) {
                this.m_templateConnector = new TemplateConnector();
            }
            this.m_templateConnector.add(id, masterIndex, parentElement);
        }
    }

    public void addTemplateConnector(String id, int masterIndex, String parentNodePath) {
        if (id != null && masterIndex >= 0 && parentNodePath != null) {
            if (this.m_templateConnector == null) {
                this.m_templateConnector = new TemplateConnector();
            }
            this.m_templateConnector.add(id, masterIndex, parentNodePath);
        }
    }

    public int getMasterIndex(String id) {
        if (id == null || this.m_templateConnector == null) {
            return -1;
        }
        return this.m_templateConnector.getTemplateIndex(id);
    }

    public int getMasterIndex(IElement templateRoot) {
        if (templateRoot == null || this.m_templates == null) {
            return -1;
        }
        return this.m_templates.getMasterIndex(templateRoot);
    }

    public String[] getIds(int masterIndex, String parentNodePath) {
        return this.m_templateConnector.getIds(masterIndex, parentNodePath);
    }

    public void setTemplateRoot(int templateIndex, IElement rootElement) {
        this.m_templates.setRootElement(templateIndex, rootElement);
    }
}

