/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.generator.input.ldx;

import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.generator.IGenericElement;
import com.cognos.mobile.generator.input.ldx.LdxCGSColumn;
import com.cognos.mobile.generator.input.ldx.LdxCGSColumns;
import com.cognos.mobile.generator.input.ldx.LdxElement;
import com.cognos.mobile.generator.input.ldx.LdxSourceHandler;
import com.cognos.mobile.generator.input.ldx.LdxTableElement;

public class LdxCGSDataElement
extends LdxElement {
    private final LdxCGSColumns cgsDataColumns;

    public LdxCGSDataElement(LdxSourceHandler handler, IGenericElement origCurrentElement, LdxCGSColumns cgsDataColumns) {
        super(handler);
        this.cgsDataColumns = cgsDataColumns;
    }

    @Override
    public void processEvent(int event) {
        super.processEvent(event);
        switch (event) {
            case 130041: {
                this.handler.popFsm();
                break;
            }
            case 1070: {
                this.handler.pushFsm(new CGSDataTableElement(this.handler));
                this.handler.injectEvent(event);
                break;
            }
        }
    }

    private class Label {
        public String context = null;
        public String value = null;

        private Label() {
        }
    }

    private class CGSDataTableElement
    extends LdxTableElement {
        int colIndex;

        public CGSDataTableElement(LdxSourceHandler handler) {
            super(handler);
        }

        @Override
        public void reset() {
            super.reset();
        }

        @Override
        public void processEvent(int event) {
            switch (event) {
                case 1700: {
                    this.handler.pushFsm(new CGSColTitleElement(this.handler));
                    break;
                }
                case 1040: {
                    this.handler.pushFsm(new CGSDataRowElement(this.handler));
                    this.handler.injectEvent(event);
                    break;
                }
                case 1071: {
                    this.handler.popFsm();
                    break;
                }
                default: {
                    super.processEvent(event);
                }
            }
        }

        public class CGSDataCellElement
        extends LdxElement {
            private Label currentLabel;
            boolean m_hasFormatVal;

            public CGSDataCellElement(LdxSourceHandler handler) {
                super(handler);
                this.currentLabel = new Label();
                this.m_hasFormatVal = false;
            }

            @Override
            public void reset() {
                this.m_hasFormatVal = false;
            }

            @Override
            public void processEvent(int event) {
                switch (event) {
                    case 1300: {
                        break;
                    }
                    case 1301: {
                        LdxCGSColumn col;
                        if (this.currentLabel.context == null) {
                            this.currentLabel.context = "";
                        }
                        if ((col = LdxCGSDataElement.this.cgsDataColumns.get(CGSDataTableElement.this.colIndex)) != null) {
                            col.addValue(this.currentLabel.context, this.currentLabel.value);
                        } else {
                            col = null;
                        }
                        ++CGSDataTableElement.this.colIndex;
                        col = null;
                        this.handler.popFsm();
                        break;
                    }
                    case 8000: {
                        this.handler.RecordTextNodeOn();
                        break;
                    }
                    case 8001: {
                        String context;
                        String ctx = CMStringHelper.replaceAll(this.handler.getTextNode(), "::", ":", true);
                        if (ctx != null && ctx.length() > 0) {
                            if (ctx.indexOf(":") > 0) {
                                String[] ctxArray = CMStringHelper.split(ctx, ':', true);
                                context = ctxArray[0];
                            } else {
                                context = ctx;
                            }
                        } else {
                            context = "";
                        }
                        this.currentLabel.context = context;
                        this.handler.RecordTextNodeOff();
                        break;
                    }
                    case 1080: {
                        if (this.m_hasFormatVal) break;
                        this.handler.RecordTextNodeOn();
                        break;
                    }
                    case 1081: {
                        if (this.m_hasFormatVal) break;
                        this.currentLabel.value = this.handler.getTextNode();
                        this.handler.RecordTextNodeOff();
                        break;
                    }
                    case 3800: {
                        this.m_hasFormatVal = true;
                        this.handler.RecordTextNodeOn();
                        break;
                    }
                    case 3801: {
                        this.currentLabel.value = this.handler.getTextNode();
                        this.handler.RecordTextNodeOff();
                    }
                }
            }
        }

        private class CGSDataRowElement
        extends LdxElement {
            public CGSDataRowElement(LdxSourceHandler handler) {
                super(handler);
                CGSDataTableElement.this.colIndex = 0;
            }

            @Override
            public void processEvent(int event) {
                if (event == 1300) {
                    this.handler.pushFsm(new CGSDataCellElement(this.handler));
                    this.handler.injectEvent(event);
                } else if (event == 1041) {
                    this.handler.popFsm();
                } else {
                    super.processEvent(event);
                }
            }
        }

        public class CGSColTitleElement
        extends LdxElement {
            private LdxCGSColumn currentColInfo;

            public CGSColTitleElement(LdxSourceHandler handler) {
                super(handler);
                this.currentColInfo = new LdxCGSColumn();
            }

            @Override
            public void processEvent(int event) {
                switch (event) {
                    case 1701: {
                        LdxCGSDataElement.this.cgsDataColumns.add(this.currentColInfo);
                        this.handler.popFsm();
                        break;
                    }
                    case 1010: {
                        this.handler.RecordTextNodeOn();
                        break;
                    }
                    case 1011: {
                        this.currentColInfo.id = this.handler.getTextNode();
                        this.handler.RecordTextNodeOff();
                        break;
                    }
                    case 8000: {
                        this.handler.RecordTextNodeOn();
                        break;
                    }
                    case 8001: {
                        this.currentColInfo.context = this.handler.getTextNode();
                        this.handler.RecordTextNodeOff();
                        break;
                    }
                    case 1080: {
                        if (CGSDataTableElement.this.m_hasFormatVal) break;
                        this.handler.RecordTextNodeOn();
                        break;
                    }
                    case 1081: {
                        if (CGSDataTableElement.this.m_hasFormatVal) break;
                        this.currentColInfo.label = this.handler.getTextNode();
                        this.handler.RecordTextNodeOff();
                        break;
                    }
                    case 3800: {
                        CGSDataTableElement.this.m_hasFormatVal = true;
                        this.handler.RecordTextNodeOn();
                        break;
                    }
                    case 3801: {
                        this.currentColInfo.label = this.handler.getTextNode();
                        this.handler.RecordTextNodeOff();
                        break;
                    }
                    default: {
                        super.processEvent(event);
                    }
                }
            }
        }
    }
}

