/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.generator.input.ldx;

import com.cognos.mobile.generator.input.ldx.LdxCGSColumn;
import com.cognos.mobile.generator.input.ldx.LdxCGSColumns;
import com.cognos.mobile.generator.input.ldx.LdxElement;
import com.cognos.mobile.generator.input.ldx.LdxSourceHandler;

public class LdxCGSDataInfoElement
extends LdxElement {
    private final LdxCGSColumns cgsDataColumns;

    public LdxCGSDataInfoElement(LdxSourceHandler handler, LdxCGSColumns cgsDataColumns) {
        super(handler);
        this.cgsDataColumns = cgsDataColumns;
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public void processEvent(int event) {
        switch (event) {
            case 130043: {
                this.handler.popFsm();
                break;
            }
            case 130044: {
                this.handler.pushFsm(new CGSColInfoElement(this.handler, this.cgsDataColumns));
                this.handler.injectEvent(event);
                break;
            }
        }
    }

    private boolean setColumnType(String id, String type, LdxCGSColumns cgsDataColumns) {
        boolean set = false;
        for (int i = 0; i < cgsDataColumns.size(); ++i) {
            LdxCGSColumn col = cgsDataColumns.get(i);
            if (col == null || col.id == null || !col.id.equals(id)) continue;
            col.type = type;
            set = true;
            break;
        }
        return set;
    }

    private class CGSColInfoElement
    extends LdxElement {
        private LdxCGSColumn currentColInfo;
        private final LdxCGSColumns cgsDataColumns;

        public CGSColInfoElement(LdxSourceHandler handler, LdxCGSColumns cgsDataColumns) {
            super(handler);
            this.cgsDataColumns = cgsDataColumns;
            this.currentColInfo = new LdxCGSColumn();
        }

        @Override
        public void reset() {
            super.reset();
            this.currentColInfo = new LdxCGSColumn();
        }

        @Override
        public void processEvent(int event) {
            super.processEvent(event);
            switch (event) {
                case 130045: {
                    LdxCGSDataInfoElement.this.setColumnType(this.currentColInfo.id, this.currentColInfo.type, this.cgsDataColumns);
                    this.handler.popFsm();
                    break;
                }
                case 1010: {
                    this.handler.RecordTextNodeOn();
                    break;
                }
                case 1011: {
                    this.currentColInfo.id = this.handler.getTextNode();
                    this.handler.RecordTextNodeOff();
                    break;
                }
                case 110004: {
                    this.handler.RecordTextNodeOn();
                    break;
                }
                case 110005: {
                    this.currentColInfo.type = this.handler.getTextNode();
                    this.handler.RecordTextNodeOff();
                    break;
                }
            }
        }
    }
}

