/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.generator.input.ldx;

import com.cognos.mobile.generator.input.ldx.LdxElement;
import com.cognos.mobile.generator.input.ldx.LdxSourceHandler;
import com.cognos.mobile.generator.input.ldx.LdxSourceObserver;
import com.cognos.mobile.vm.VM;

public class LdxCellElement
extends LdxElement {
    private static Class CLASS = LdxCellElement.class;
    protected int m_startEvent;
    protected int m_closeEvent;
    protected boolean m_isTitle;
    protected boolean m_currentElementPushed = false;

    public LdxCellElement(LdxSourceHandler handler, int start, boolean isTitle) {
        super(handler);
        this.m_startEvent = start;
        this.m_closeEvent = start + 1;
        this.m_isTitle = isTitle;
    }

    public LdxCellElement(LdxSourceHandler handler, int start) {
        super(handler);
        this.m_startEvent = start;
        this.m_closeEvent = start + 1;
    }

    @Override
    public void reset() {
        this.m_isTitle = false;
        this.m_currentElementPushed = false;
    }

    @Override
    public void processEvent(int event) {
        if (event == this.m_startEvent) {
            this.handler.createAndAddElement(2);
            this.m_currentElementPushed = true;
        } else if (event == this.m_closeEvent) {
            if (this.m_isTitle) {
                this.handler.getCurrentElement().setIsTitle(true);
            }
            if (this.m_currentElementPushed) {
                this.handler.popCurrentElement();
            }
            this.handler.popFsm();
            this.handler.injectEvent(event);
        } else {
            switch (event) {
                case 1600: {
                    this.handler.RecordTextNodeOn();
                    break;
                }
                case 1601: {
                    this.handleRowspan();
                    break;
                }
                case 1500: {
                    this.handler.RecordTextNodeOn();
                    break;
                }
                case 1501: {
                    this.handleColumnspan();
                    break;
                }
                case 2300: {
                    this.handler.pushFsm(new LdxSourceObserver(this.handler, 2301));
                    break;
                }
                default: {
                    super.processEvent(event);
                }
            }
        }
    }

    protected void handleColumnspan() {
        try {
            int span = Integer.parseInt(this.handler.getTextNode());
            if (span != 1) {
                this.handler.getCurrentElement().setColspan(new Integer(span));
            }
        }
        catch (NumberFormatException ex) {
            VM.log(CLASS, 2, "invalid colspan: " + this.handler.getTextNode());
        }
        this.handler.RecordTextNodeOff();
    }

    protected void handleRowspan() {
        try {
            int span = Integer.parseInt(this.handler.getTextNode());
            if (span != 1) {
                this.handler.getCurrentElement().setRowspan(new Integer(span));
            }
        }
        catch (NumberFormatException ex) {
            VM.log(CLASS, 2, "invalid rowspan: " + this.handler.getTextNode());
        }
        this.handler.RecordTextNodeOff();
    }
}

