/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.generator.input.ldx;

import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.generator.Area;
import com.cognos.mobile.generator.IGenericElement;
import com.cognos.mobile.generator.input.ldx.LdxCGSColumn;
import com.cognos.mobile.generator.input.ldx.LdxCGSColumns;
import com.cognos.mobile.generator.input.ldx.LdxCGSDataElement;
import com.cognos.mobile.generator.input.ldx.LdxCGSDataInfoElement;
import com.cognos.mobile.generator.input.ldx.LdxElement;
import com.cognos.mobile.generator.input.ldx.LdxSourceHandler;
import com.cognos.mobile.vm.VM;
import java.util.Vector;

public class LdxChartElement
extends LdxElement {
    private static Class CLASS = LdxChartElement.class;
    private IGenericElement mapElement = null;
    private IGenericElement origCurrentElement = null;
    private LdxCGSColumns cgsDataColumns = new LdxCGSColumns();
    private static final String AREATYPE_CHARTELEMENT = "chartElement";
    private static final String AREATYPE_LEGENDLABEL = "legendLabel";
    private static final String AREATYPE_ORIANLAXISLABEL = "ordinalAxisLabel";
    private static final String COLUMNTYPE_SERIES = "eSeries";
    private static final String COLUMNTYPE_CATEGORY = "eCategory";
    private static final String COLUMNTYPE_MEASURE = "eMeasure";
    private static final String COLUMNTYPE_CATEGORYMAPREGION = "eCategoryMapRegion";
    private static final String COLUMNTYPE_MEASUREMAPREGIONCOLOR = "eMeasureMapRegionColor";
    private static final String TOOTIP_COMPONENT_SEPARATOR = " | ";

    public LdxChartElement(LdxSourceHandler handler) {
        super(handler);
    }

    @Override
    public void reset() {
        this.mapElement = null;
        this.origCurrentElement = null;
        this.cgsDataColumns = new LdxCGSColumns();
    }

    @Override
    public void processEvent(int event) {
        switch (event) {
            case 2700: {
                this.handler.createAndAddElement(3);
                this.handler.startRecording();
                break;
            }
            case 2701: {
                if (this.mapElement != null) {
                    this.handler.getCurrentElement().addChild(this.mapElement);
                    this.handler.getCurrentElement().setMap(this.mapElement.getID());
                }
                this.populateAreaLabels();
                this.handler.popCurrentElement();
                this.handler.popFsm();
                this.handler.getCurrentElement().setValue(this.handler.getRecordedText());
                this.handler.stopRecording();
                break;
            }
            case 3200: {
                this.handler.RecordTextNodeOn();
                break;
            }
            case 3201: {
                this.handler.getCurrentElement().setUrl(this.handler.getTextNode());
                this.handler.RecordTextNodeOff();
                break;
            }
            case 110000: {
                this.mapElement = this.handler.createElement(12);
                break;
            }
            case 110002: {
                this.handler.pushFsm(new AreaElement(this.handler));
                this.handler.injectEvent(event);
                break;
            }
            case 16500: {
                this.handler.pushFsm(new SizeElement(this.handler));
                break;
            }
            case 130040: {
                this.origCurrentElement = this.handler.getCurrentElement();
                this.handler.pushFsm(new LdxCGSDataElement(this.handler, this.origCurrentElement, this.cgsDataColumns));
                break;
            }
            case 130042: {
                this.handler.pushFsm(new LdxCGSDataInfoElement(this.handler, this.cgsDataColumns));
                break;
            }
            default: {
                super.processEvent(event);
            }
        }
    }

    private int[] parsePoly(Vector poly) {
        int[] coords = new int[poly.size()];
        for (int i = 0; i < poly.size(); ++i) {
            coords[i] = CMStringHelper.parseInteger((String)poly.elementAt(i), 0);
        }
        return coords;
    }

    private String parseLabel(String label) {
        if (label != null) {
            return label.replace("\n", TOOTIP_COMPONENT_SEPARATOR);
        }
        return null;
    }

    private boolean isValidPoly(int[] poly) {
        return poly != null;
    }

    private void populateAreaLabels() {
        if (!this.cgsDataColumns.isEmpty() && this.mapElement != null && this.mapElement.getAreas() != null) {
            Vector areas = this.mapElement.getAreas();
            for (Area area : areas) {
                if (area.ctx == null || area.label != null && area.label.length() != 0) continue;
                StringBuffer label = new StringBuffer();
                String[] ctxs = area.ctx;
                if (ctxs.length == 1 && this.cgsDataColumns.size() > 1) {
                    for (int i = 0; i < this.cgsDataColumns.size(); ++i) {
                        LdxCGSColumn col = this.cgsDataColumns.get(i);
                        String text = col.getValue(ctxs[0]);
                        if (text == null) continue;
                        label.append(col.label).append("=");
                        label.append(this.parseLabel(text));
                        break;
                    }
                } else {
                    StringBuffer eSeries = new StringBuffer();
                    StringBuffer eCategory = new StringBuffer();
                    StringBuffer eMeasure = new StringBuffer();
                    for (int i = 0; i < ctxs.length; ++i) {
                        String text;
                        LdxCGSColumn col = this.cgsDataColumns.get(i);
                        if (col == null || (text = col.getValue(ctxs[i])) == null) continue;
                        if (COLUMNTYPE_SERIES.equals(col.type)) {
                            if (eSeries.length() > 0) {
                                eSeries.append(TOOTIP_COMPONENT_SEPARATOR);
                            }
                            eSeries.append(col.label).append("=");
                            eSeries.append(this.parseLabel(text));
                            continue;
                        }
                        if (COLUMNTYPE_CATEGORY.equals(col.type)) {
                            if (eCategory.length() > 0) {
                                eCategory.append(TOOTIP_COMPONENT_SEPARATOR);
                            }
                            eCategory.append(col.label).append("=");
                            eCategory.append(this.parseLabel(text));
                            continue;
                        }
                        if (eMeasure.length() > 0) {
                            eMeasure.append(TOOTIP_COMPONENT_SEPARATOR);
                        }
                        eMeasure.append(col.label).append("=");
                        eMeasure.append(this.parseLabel(text));
                    }
                    if (eSeries.length() > 0) {
                        label.append(eSeries);
                    }
                    if (eCategory.length() > 0) {
                        if (label.length() > 0) {
                            label.append(TOOTIP_COMPONENT_SEPARATOR);
                        }
                        label.append(eCategory);
                    }
                    if (eMeasure.length() > 0) {
                        if (label.length() > 0) {
                            label.append(TOOTIP_COMPONENT_SEPARATOR);
                        }
                        label.append(eMeasure);
                    }
                }
                if (label.length() <= 0 || area.label.length() == 0) continue;
                this.handler.getDocument().updateAreaLabel(this.mapElement, area, label.toString());
            }
        }
    }

    private class DrillElement
    extends LdxElement.DrillElement {
        Area m_currentArea;

        public DrillElement(LdxSourceHandler handler, Area currentArea) {
            super(LdxChartElement.this, handler);
            this.m_currentArea = currentArea;
        }

        @Override
        public void reset() {
            super.reset();
            this.m_currentArea = null;
        }

        @Override
        public void processEvent(int event) {
            switch (event) {
                case 110019: {
                    if (LdxChartElement.this.m_currentDrillContext != null) {
                        if (LdxChartElement.this.m_currentDrillContext.getDrillIndex() < 0) {
                            VM.log(CLASS, 3, "ignoring invalid drill target");
                        } else {
                            this.m_currentArea.drillTargetFingerprint = LdxChartElement.this.m_currentDrillContextFingerprint;
                            this.m_currentArea.addDrillTarget(LdxChartElement.this.m_currentDrillContext);
                        }
                        LdxChartElement.this.m_currentDrillContext = null;
                    }
                    LdxChartElement.this.handler.popFsm();
                    break;
                }
                default: {
                    super.processEvent(event);
                }
            }
        }
    }

    private class SizeElement
    extends LdxElement {
        public SizeElement(LdxSourceHandler handler) {
            super(handler);
        }

        @Override
        public void reset() {
        }

        @Override
        public void processEvent(int event) {
            super.processEvent(event);
            switch (event) {
                case 16501: {
                    this.handler.popFsm();
                    break;
                }
                case 100020: {
                    this.handler.RecordTextNodeOn();
                    break;
                }
                case 100021: {
                    int width;
                    try {
                        width = Integer.parseInt(this.handler.getTextNode());
                    }
                    catch (NumberFormatException e) {
                        width = 0;
                    }
                    this.handler.getCurrentElement().setWidth(width);
                    this.handler.RecordTextNodeOff();
                    break;
                }
                case 100022: {
                    this.handler.RecordTextNodeOn();
                    break;
                }
                case 100023: {
                    int height;
                    try {
                        height = Integer.parseInt(this.handler.getTextNode());
                    }
                    catch (NumberFormatException e) {
                        height = 0;
                    }
                    this.handler.getCurrentElement().setHeight(height);
                    this.handler.RecordTextNodeOff();
                    break;
                }
            }
        }
    }

    private class AreaElement
    extends LdxElement {
        Area m_currentArea;
        private Vector coords;

        public AreaElement(LdxSourceHandler handler) {
            super(handler);
        }

        @Override
        public void reset() {
            this.m_currentArea = null;
            this.coords = null;
        }

        @Override
        public void processEvent(int event) {
            switch (event) {
                case 110002: {
                    this.m_currentArea = new Area();
                    this.coords = new Vector();
                    break;
                }
                case 110003: {
                    if (this.m_currentArea != null && this.m_currentArea.type == 2 || this.m_currentArea.type == 1 || this.m_currentArea.type == 3) {
                        this.m_currentArea.poly = LdxChartElement.this.parsePoly(this.coords);
                        if (this.m_currentArea.label == null || !LdxChartElement.this.isValidPoly(this.m_currentArea.poly)) {
                            VM.log(CLASS, 2, "area has missing label or missing/invalid polygon");
                        } else {
                            LdxChartElement.this.mapElement.addArea(this.m_currentArea);
                        }
                        this.m_currentArea = null;
                    }
                    this.handler.popFsm();
                    break;
                }
                case 110004: {
                    this.handler.RecordTextNodeOn();
                    break;
                }
                case 110005: {
                    String areaTypeText = this.handler.getTextNode();
                    if (LdxChartElement.AREATYPE_CHARTELEMENT.equals(areaTypeText)) {
                        this.m_currentArea.type = 1;
                    } else if (LdxChartElement.AREATYPE_LEGENDLABEL.equals(areaTypeText)) {
                        this.m_currentArea.type = 2;
                    } else if (LdxChartElement.AREATYPE_ORIANLAXISLABEL.equals(areaTypeText)) {
                        this.m_currentArea.type = 3;
                    }
                    this.handler.RecordTextNodeOff();
                    break;
                }
                case 110006: {
                    this.handler.RecordTextNodeOn();
                    break;
                }
                case 110007: {
                    if (this.m_currentArea.label == null || this.m_currentArea.label.length() <= 0) {
                        this.m_currentArea.label = LdxChartElement.this.parseLabel(this.handler.getTextNode());
                    }
                    this.handler.RecordTextNodeOff();
                    break;
                }
                case 110010: 
                case 110012: {
                    this.handler.RecordTextNodeOn();
                    break;
                }
                case 110011: 
                case 110013: {
                    this.coords.add(this.handler.getTextNode());
                    this.handler.RecordTextNodeOff();
                    break;
                }
                case 110018: {
                    this.handler.pushFsm(new DrillElement(this.handler, this.m_currentArea));
                    this.handler.injectEvent(event);
                    break;
                }
                case 17600: {
                    this.handler.RecordTextNodeOn();
                    break;
                }
                case 17601: {
                    if (this.m_currentArea.drillCtx == null) break;
                    String direction = this.handler.getTextNode();
                    if (direction.equalsIgnoreCase("UP")) {
                        this.m_currentArea.drillCtx.setCanDrillUp(true);
                    }
                    if (!direction.equalsIgnoreCase("DOWN")) break;
                    this.m_currentArea.drillCtx.setCanDrillDown(true);
                    break;
                }
                case 8000: {
                    this.handler.RecordTextNodeOn();
                    break;
                }
                case 8001: {
                    String ctx = CMStringHelper.replaceAll(this.handler.getTextNode(), "::", ":", true);
                    if (ctx != null && ctx.length() > 0) {
                        if (ctx.indexOf(":") >= 0) {
                            String[] ctxTemp = this.removeEmptyString(CMStringHelper.split(ctx, ':', true));
                            String[] temp = new String[ctxTemp.length];
                            int count = 0;
                            for (int i = 0; i < ctxTemp.length; ++i) {
                                if (ctxTemp[ctxTemp.length - 1 - i].length() == 0) continue;
                                temp[i] = ctxTemp[ctxTemp.length - 1 - i];
                                ++count;
                            }
                            this.m_currentArea.ctx = new String[count];
                            System.arraycopy(temp, 0, this.m_currentArea.ctx, 0, count);
                        } else {
                            this.m_currentArea.ctx = new String[1];
                            this.m_currentArea.ctx[0] = ctx;
                        }
                    }
                    if (this.m_currentArea.drillCtx != null) {
                        this.m_currentArea.drillCtx.setDrillUpDownContext(this.handler.getTextNode());
                        this.m_currentArea.drillCtx.setDrillUpDownWidget(this.document.getCurrentWidget());
                    }
                    this.handler.RecordTextNodeOff();
                    break;
                }
            }
        }

        private String[] removeEmptyString(String[] temp) {
            int count = 0;
            for (int i = 0; i < temp.length; ++i) {
                if (temp[i] == null || temp[i].length() == 0) continue;
                ++count;
            }
            if (count == temp.length) {
                return temp;
            }
            String[] output = new String[count];
            count = 0;
            for (int i = 0; i < temp.length; ++i) {
                if (temp[i] == null || temp[i].length() == 0) continue;
                output[count++] = temp[i];
            }
            return output;
        }
    }
}

