/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.generator.input.ldx;

import com.cognos.mobile.generator.IGenericElement;
import com.cognos.mobile.generator.input.ldx.LdxCellElement;
import com.cognos.mobile.generator.input.ldx.LdxDimensions;
import com.cognos.mobile.generator.input.ldx.LdxElement;
import com.cognos.mobile.generator.input.ldx.LdxRowElement;
import com.cognos.mobile.generator.input.ldx.LdxSourceHandler;
import com.cognos.mobile.generator.input.ldx.LdxTableElement;
import com.cognos.mobile.vm.VM;

public class LdxCrosstabElement
extends LdxTableElement {
    private static Class CLASS = LdxCrosstabElement.class;
    boolean m_inColTitle;
    boolean m_inRowTitle;
    LdxDimensions m_columnDims = null;
    LdxDimensions m_rowDims = null;
    private int m_rowCount = 0;
    IGenericElement m_cornerRow = null;

    public LdxCrosstabElement(LdxSourceHandler handler) {
        super(handler);
        this.m_columnDims = new LdxDimensions(handler);
        this.m_rowDims = new LdxDimensions(handler);
    }

    @Override
    public void reset() {
        super.reset();
        this.m_inColTitle = false;
        this.m_inRowTitle = false;
        this.m_rowCount = 0;
        this.m_columnDims = new LdxDimensions(this.handler);
        this.m_rowDims = new LdxDimensions(this.handler);
        this.m_cornerRow = null;
    }

    @Override
    public void processEvent(int event) {
        switch (event) {
            case 1030: {
                this.handler.createAndAddElement(10);
                this.handler.getCurrentElement().setIsLayout(false);
                break;
            }
            case 1400: {
                this.handler.createAndAddElement(9, null);
                this.m_cornerRow = this.handler.getCurrentElement();
                this.handler.pushFsm(new LdxCellElement(this.handler, event, true));
                this.handler.injectEvent(event);
                break;
            }
            case 1050: {
                this.handler.pushFsm(this.m_columnDims);
                this.handler.injectEvent(event);
                break;
            }
            case 1040: {
                this.handler.pushFsm(this.m_rowDims);
                this.handler.injectEvent(event);
                break;
            }
            case 1070: {
                this.handler.pushFsm(new CrosstabDataTable(this.handler));
                this.handler.injectEvent(event);
                break;
            }
            case 1031: {
                this.handler.popCurrentElement();
                this.handler.popFsm();
                break;
            }
            default: {
                super.processEvent(event);
            }
        }
    }

    private void handleColumnDims() {
        int nestedLevels = this.m_columnDims.getNestedLevels();
        for (int i = 0; i < nestedLevels; ++i) {
            IGenericElement[] dimCells = this.m_columnDims.getDimensionCells(i);
            if (i == 0 && this.m_cornerRow != null) {
                this.document.setRowSpan(0, this.m_cornerRow, nestedLevels);
                this.handler.setCurrentElement(this.m_cornerRow);
            } else {
                this.handler.createAndAddElement(9, null);
            }
            this.handleDimensionCells(dimCells);
            this.handler.popCurrentElement();
        }
    }

    public void handleRowDim() {
        this.handler.createAndAddElement(9, null);
        IGenericElement[] dimCells = this.m_rowDims.getDimensionCells(this.m_rowCount);
        this.handleDimensionCells(dimCells);
        ++this.m_rowCount;
    }

    private void handleDimensionCells(IGenericElement[] dimCells) {
        for (int j = 0; j < dimCells.length; ++j) {
            try {
                this.handler.addElement(dimCells[j], null);
                this.handler.popCurrentElement();
                continue;
            }
            catch (Exception ex) {
                VM.log(CLASS, 3, "Error handling dimension cells for table: ");
            }
        }
    }

    private class CrosstabDataTable
    extends LdxElement {
        public CrosstabDataTable(LdxSourceHandler handler) {
            super(handler);
        }

        @Override
        public void processEvent(int event) {
            switch (event) {
                case 1070: {
                    LdxCrosstabElement.this.handleColumnDims();
                    break;
                }
                case 1040: {
                    LdxCrosstabElement.this.handleRowDim();
                    this.handler.pushFsm(new LdxRowElement(this.handler, 1040, 1300));
                    break;
                }
                case 1071: {
                    this.handler.popFsm();
                }
            }
        }
    }
}

