/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.generator.input.ldx;

import com.cognos.mobile.generator.IGenericElement;
import com.cognos.mobile.generator.NullElement;
import com.cognos.mobile.generator.input.ldx.LdxCellElement;
import com.cognos.mobile.generator.input.ldx.LdxElement;
import com.cognos.mobile.generator.input.ldx.LdxSourceHandler;
import java.util.ArrayList;
import java.util.List;

public class LdxDimensions
extends LdxElement {
    String cellXML = null;
    List<List<IGenericElement>> m_rowcols = new ArrayList<List<IGenericElement>>();
    boolean firstChild = true;

    public LdxDimensions(LdxSourceHandler handler) {
        super(handler);
    }

    @Override
    public void processEvent(int event) {
        switch (event) {
            case 1050: {
                this.handler.pushFsm(new LdxDimension(this.handler, 0, true, this.firstChild));
                if (!this.firstChild) break;
                this.firstChild = false;
                break;
            }
            case 1040: {
                this.insertRowIfNeeded(0);
                this.handler.pushFsm(new LdxDimension(this.handler, 0, false, this.firstChild));
                if (!this.firstChild) break;
                this.firstChild = false;
                break;
            }
            case 1041: 
            case 1051: {
                this.handler.popFsm();
            }
        }
    }

    private void addDimensionCell(LdxDimension dim, IGenericElement cell, int pos) {
        if (dim.isColumn) {
            List<IGenericElement> dims = this.getRow(pos);
            dims.add(cell);
        } else if (dim.isFirstCell) {
            List<IGenericElement> dims = this.getRow(this.m_rowcols.size() - 1);
            dims.add(cell);
        } else {
            this.insertRowIfNeeded(this.m_rowcols.size());
            List<IGenericElement> dims = this.getRow(this.m_rowcols.size() - 1);
            dims.add(cell);
        }
    }

    private void insertRowIfNeeded(int pos) {
        if (this.m_rowcols.size() <= pos) {
            this.m_rowcols.add(new ArrayList());
        }
    }

    private List<IGenericElement> getRow(int pos) {
        if (this.m_rowcols.size() <= pos) {
            return new ArrayList<IGenericElement>(0);
        }
        List<IGenericElement> dims = this.m_rowcols.get(pos);
        return dims;
    }

    public int getNestedLevels() {
        return this.m_rowcols.size();
    }

    public IGenericElement[] getDimensionCells(int pos) {
        List<IGenericElement> dims = this.getRow(pos);
        return dims.toArray(new IGenericElement[dims.size()]);
    }

    private class LdxDimension
    extends LdxElement {
        private int position;
        private boolean isColumn;
        private boolean isFirstCell;
        private boolean isFirstChild;
        private IGenericElement currentCell;

        public LdxDimension(LdxSourceHandler handler, int pos, boolean isCol, boolean isFirst) {
            super(handler);
            this.position = 0;
            this.isColumn = false;
            this.isFirstCell = false;
            this.isFirstChild = true;
            this.currentCell = null;
            this.position = pos;
            this.isColumn = isCol;
            this.isFirstCell = isFirst;
        }

        @Override
        public void processEvent(int event) {
            switch (event) {
                case 1100: {
                    if (this.isColumn) {
                        LdxDimensions.this.insertRowIfNeeded(this.position);
                    }
                    this.currentCell = this.handler.createElement(2, null);
                    this.handler.addElement(this.currentCell, NullElement.instance());
                    this.currentCell.setIsTitle(true);
                    LdxCellElement cellHandler = new LdxCellElement(this.handler, 1100, true);
                    this.handler.pushFsm(cellHandler);
                    break;
                }
                case 1101: {
                    LdxDimensions.this.addDimensionCell(this, this.currentCell, this.position);
                    this.handler.popCurrentElement();
                    break;
                }
                case 1090: {
                    this.handler.pushFsm(new LdxDimension(this.handler, this.position + 1, this.isColumn, this.isFirstChild));
                    if (!this.isFirstChild) break;
                    this.isFirstChild = false;
                    break;
                }
                case 1091: {
                    this.handler.popFsm();
                    break;
                }
                case 1041: 
                case 1051: {
                    this.handler.popFsm();
                    this.handler.injectEvent(event);
                }
            }
        }
    }
}

