/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.generator.input.ldx;

import com.cognos.mobile.drill.DrillContext;
import com.cognos.mobile.drill.DrillContextParam;
import com.cognos.mobile.generator.IDocument;
import com.cognos.mobile.generator.IGenericElement;
import com.cognos.mobile.generator.input.ldx.LdxHandler;
import com.cognos.mobile.generator.input.ldx.LdxSourceHandler;
import com.cognos.mobile.vm.VM;

public class LdxElement
implements LdxHandler.FilterFSM {
    private static Class CLASS = LdxElement.class;
    protected LdxSourceHandler handler = null;
    protected IDocument document = null;
    protected String refId = null;
    protected DrillContext m_currentDrillContext;
    protected boolean isBookmark = false;
    protected DrillContextParam m_currentDrillParameter;
    protected int m_currentDrillContextFingerprint;

    public LdxElement(LdxSourceHandler handler) {
        this.handler = handler;
        this.document = handler.getDocument();
    }

    public void recordText(boolean on) {
        if (on) {
            this.handler.RecordTextNodeOn();
        }
        if (!on) {
            this.handler.RecordTextNodeOff();
        }
    }

    public String getText() {
        String text = this.handler.getTextNode();
        this.recordText(false);
        return text;
    }

    public boolean isTrue() {
        String text = this.handler.getTextNode();
        this.recordText(false);
        return text.startsWith("t");
    }

    @Override
    public void reset() {
    }

    public final IDocument getDocument() {
        return this.document;
    }

    public final LdxHandler getHandler() {
        return this.handler;
    }

    @Override
    public void processEvent(int event) {
        switch (event) {
            case 2400: {
                this.handler.RecordTextNodeOn();
                break;
            }
            case 2401: {
                this.handler.getCurrentElement().addStyle(this.handler.generateStyleName(this.handler.getTextNode()));
                this.handler.RecordTextNodeOff();
                break;
            }
            case 110018: {
                this.handler.pushFsm(new DrillElement(this.handler));
                this.handler.injectEvent(event);
                break;
            }
            case 17600: {
                this.handler.RecordTextNodeOn();
                break;
            }
            case 17601: {
                IGenericElement me = this.handler.getCurrentElement();
                if (me == null) break;
                String direction = this.handler.getTextNode();
                if (direction.equalsIgnoreCase("UP")) {
                    me.setCanDrillUp(true);
                }
                if (!direction.equalsIgnoreCase("DOWN")) break;
                me.setCanDrillDown(true);
                break;
            }
            case 8000: {
                this.handler.RecordTextNodeOn();
                break;
            }
            case 8001: {
                IGenericElement me = this.handler.getCurrentElement();
                if (me != null) {
                    String ctx = this.handler.getTextNode();
                    me.setDrillUpDownContext(ctx);
                    me.setDrillUpDownWidget(this.document.getCurrentWidget());
                }
                this.handler.RecordTextNodeOff();
                break;
            }
        }
    }

    protected int generateDrillTargetFingerprint(String characters) {
        byte[] byteArray;
        int charSum = 0;
        try {
            byteArray = characters.getBytes("UTF-8");
        }
        catch (Exception e) {
            byteArray = characters.getBytes();
        }
        for (int i = 0; i < byteArray.length; ++i) {
            charSum += byteArray[i];
        }
        return charSum;
    }

    protected class DrillElement
    implements LdxHandler.FilterFSM {
        public DrillElement(LdxSourceHandler handler) {
            LdxElement.this.document = handler.getDocument();
        }

        @Override
        public void reset() {
            LdxElement.this.m_currentDrillContext = null;
            LdxElement.this.m_currentDrillParameter = null;
            LdxElement.this.m_currentDrillContextFingerprint = 0;
            LdxElement.this.isBookmark = false;
        }

        @Override
        public void processEvent(int event) {
            switch (event) {
                case 110018: {
                    LdxElement.this.m_currentDrillContext = new DrillContext();
                    LdxElement.this.m_currentDrillContextFingerprint = 0;
                    break;
                }
                case 110019: {
                    if (LdxElement.this.m_currentDrillContext != null && !LdxElement.this.isBookmark) {
                        if (LdxElement.this.m_currentDrillContext.getDrillIndex() < 0) {
                            VM.log(CLASS, 3, "ignoring invalid drill target");
                        } else {
                            LdxElement.this.handler.getCurrentElement().addDrillContext(LdxElement.this.m_currentDrillContext);
                        }
                        LdxElement.this.m_currentDrillContext = null;
                        LdxElement.this.isBookmark = false;
                    }
                    LdxElement.this.handler.popFsm();
                    break;
                }
                case 110016: {
                    LdxElement.this.handler.RecordTextNodeOn();
                    break;
                }
                case 110017: {
                    if (LdxElement.this.m_currentDrillContext == null) break;
                    LdxElement.this.m_currentDrillContext.setDrillIndex(Integer.parseInt(LdxElement.this.handler.getTextNode()));
                    LdxElement.this.m_currentDrillContext.setWidgetID(LdxElement.this.handler.getDocument().getCurrentWidget());
                    break;
                }
                case 110026: {
                    if (LdxElement.this.m_currentDrillContext == null) break;
                    LdxElement.this.m_currentDrillParameter = new DrillContextParam();
                    break;
                }
                case 110027: {
                    if (LdxElement.this.m_currentDrillParameter == null) break;
                    if (LdxElement.this.m_currentDrillParameter.getName() == null || LdxElement.this.m_currentDrillParameter.getValue() == null) {
                        VM.log(CLASS, 3, "ignoring invalid or incomplete drill parameter");
                    } else {
                        LdxElement.this.m_currentDrillContext.addParameter(LdxElement.this.m_currentDrillParameter);
                    }
                    LdxElement.this.m_currentDrillParameter = null;
                    break;
                }
                case 1100: {
                    LdxElement.this.handler.RecordTextNodeOn();
                    break;
                }
                case 1101: {
                    if (LdxElement.this.m_currentDrillContext != null && LdxElement.this.m_currentDrillParameter != null) {
                        LdxElement.this.m_currentDrillParameter.setName(LdxElement.this.handler.getTextNode());
                    }
                    LdxElement.this.m_currentDrillContextFingerprint += LdxElement.this.generateDrillTargetFingerprint(LdxElement.this.handler.getTextNode());
                    LdxElement.this.handler.RecordTextNodeOff();
                    break;
                }
                case 110028: {
                    LdxElement.this.handler.RecordTextNodeOn();
                    break;
                }
                case 110029: {
                    if (LdxElement.this.m_currentDrillContext != null) {
                        LdxElement.this.m_currentDrillParameter.setValue(LdxElement.this.handler.getTextNode());
                    }
                    LdxElement.this.m_currentDrillContextFingerprint += LdxElement.this.generateDrillTargetFingerprint(LdxElement.this.handler.getTextNode());
                    LdxElement.this.handler.RecordTextNodeOff();
                    break;
                }
                case 130038: {
                    LdxElement.this.handler.RecordTextNodeOn();
                    break;
                }
                case 130039: {
                    if (LdxElement.this.m_currentDrillContext != null) {
                        LdxElement.this.m_currentDrillParameter.setMun(LdxElement.this.handler.getTextNode());
                        LdxElement.this.handler.getDocument().setIsMUNUsed(true);
                    }
                    LdxElement.this.m_currentDrillContextFingerprint += LdxElement.this.generateDrillTargetFingerprint(LdxElement.this.handler.getTextNode());
                    LdxElement.this.handler.RecordTextNodeOff();
                    break;
                }
            }
        }
    }
}

